package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.SalContractDDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;

import java.util.List;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/9 11:26 上午
 */
public interface SalContractDRepo extends JpaRepository<SalContractDDO, Long>, QuerydslPredicateExecutor<SalContractDDO> {

    // 根据合同主表ID，获取所有明细
    List<SalContractDDO> findAllByMasId(Long masId);

    // 根据合同主表ID，物理删除明细
    void deleteAllByMasId(Long masId);

}
