package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.api.dto.BipCartDTO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCartItemRespVO;
import com.elitesland.yst.production.sale.entity.QBipCartDO;
import com.elitesland.yst.production.sale.entity.QBipItemDO;
import com.elitesland.yst.production.sale.entity.QBipItemSkuDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Objects;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/09/11:50
 * @Description:
 */
@Repository
public class BipCartRepoProc {

    @Autowired
    private BipCartRepo bipCartRepo;

    private final QBipItemDO qBipItemDo = QBipItemDO.bipItemDO;

    private final QBipCartDO qBipCartDo = QBipCartDO.bipCartDO;

    private final QBipItemSkuDO qBipItemSkuDO = QBipItemSkuDO.bipItemSkuDO;

//    private final QBipimagesDo qBipimagesDo=QBipimagesDo.bipimagesDo;

    @Autowired
    private JPAQueryFactory jpaQueryFactory;


    /**
     * 查询购物车商品详情
     * @param userId
     * @param isEnabled
     * @return
     */
    public JPAQuery<BipCartItemRespVO> findUserCartItemInfo(Long userId, String isEnabled) {

        return jpaQueryFactory.select(
                Projections.bean(BipCartItemRespVO.class,
                        qBipCartDo.id,
                        qBipCartDo.itemNum,
                        qBipCartDo.putAmt,
                        qBipCartDo.userId,
                        qBipCartDo.itemId,
                        qBipCartDo.skuCode,
                        qBipCartDo.skuId,
                        qBipCartDo.firstItemFlag


//                        qBipItemDo.baseAmt,
//                        qBipItemDo.buCode,
//                        qBipItemDo.buId,
//                        qBipItemDo.buName,
//                        qBipItemDo.catId,
//                        qBipItemDo.createTime,
//                        qBipItemDo.createUserId,
//                        qBipItemDo.creator,
//                        qBipItemDo.custAmt,
//                        qBipItemDo.fareMethod,
//                        qBipItemDo.fareTmplId,
//                        qBipItemDo.id,
//                        qBipItemDo.isGift,
//                        qBipItemDo.itemCode,
//                        qBipItemDo.itemId,
//                        qBipItemDo.itemName,
//                        qBipItemDo.minBuyQty,
//                        qBipItemDo.status,
//                        qBipItemDo.offlineTime,
//                        qBipItemDo.onlineTime,
//                        qBipItemDo.ouCode,
//                        qBipItemDo.ouId,
//                        qBipItemDo.ouName,
//                        qBipItemDo.salNum,
//                        qBipItemDo.title,
//                        qBipItemDo.spuCode,
//                        qBipItemDo.stockNum,
//                        qBipItemDo.itemBrand,
//
//                        qBipimagesDo.id.as("itemPicId")
                )
        )
                .from(qBipCartDo)
//                .leftJoin(qBipItemDo)
//                .leftJoin(qBipimagesDo)
//                .on(qBipCartDo.itemId.eq(qBipItemDo.id).and(qBipCartDo.itemId.eq(qBipimagesDo.itmeId)))
                .where(where(userId,isEnabled));
    }

    /**
        * @Description:
        * @Param: [userId, isEnabled]
        * @return: com.querydsl.core.types.Predicate
        * @Author: wangyinghao
        * @Date: 2021/8/16
        */
    public Predicate where(Long userId,String isEnabled) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);;
        if (!Objects.isNull(userId)) {
            predicate = ExpressionUtils.and(predicate, qBipCartDo.userId.eq(userId));
        }

        if (StringUtils.isNotBlank(isEnabled)) {
            predicate = ExpressionUtils.and(predicate, qBipCartDo.isEabled.eq(isEnabled));
        }
        predicate = ExpressionUtils.and(predicate, qBipCartDo.deleteFlag.eq(0));

        return predicate;
    }

    /**
        * @Description: 批量删除
        * @Param: [ids]
        * @return: void
        * @Author: wangyinghao
        * @Date: 2021/8/16
        */
    public void deleteCartByIds(List<Long> ids){
        jpaQueryFactory.delete(qBipCartDo).
//                set(qBipCartDo.deleteFlag,1).
                where(qBipCartDo.id.in(ids)).
                execute();
    }

    /**
     * 调整库存时查询正在调整商品库存的购物车
     * @param skuId sku
     * @return 购物车信息
     */
    public List<BipCartDTO> searchCart(Long skuId){
        return jpaQueryFactory.select(Projections.bean(BipCartDTO.class,
                qBipCartDo.id,
                qBipCartDo.itemId,
                qBipCartDo.userId,
                qBipCartDo.skuId,
                qBipCartDo.stockEnough))
                .from(qBipCartDo)
                .where(qBipCartDo.skuId.eq(skuId).and(qBipCartDo.stockEnough.eq(false)))
                .fetch();
    }

    public List<BipCartDTO> searchCartByCode(Long skuId, String priceType){
        return jpaQueryFactory.select(Projections.bean(BipCartDTO.class,
                qBipCartDo.id,
                qBipCartDo.itemId,
                qBipCartDo.userId,
                qBipCartDo.skuId,
                qBipCartDo.stockEnough))
                .from(qBipCartDo)
                .where(qBipCartDo.skuId.eq(skuId).and(qBipCartDo.priceType.eq(priceType)))
                .fetch();
    }

}
