package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.entity.BipOrderBackDDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/21/18:51
 * @Description:
 */
public interface BipOrderBackDRepo extends JpaRepository<BipOrderBackDDO, Long>, QuerydslPredicateExecutor<BipOrderBackDDO> {
    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update bip_order_back_d set delete_flag = 1 where id in ?1", nativeQuery = true)
    void deleteOrderBackDByIds(List<Long> ids);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update bip_order_back_d set delete_flag = 1 where order_back_id in ?1", nativeQuery = true)
    void deleteOrderBackDByOrderbackIds(List<Long> ids);


    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update bip_order_back_d set status = ?1 where order_back_id in ?2", nativeQuery = true)
    void updateOrderBackDByOrderbackIds(List<Long> ids,String status);

    List<BipOrderBackDDO> findByOrderBackId(Long orderBackId);


    List<BipOrderBackDDO> findByOrderIdAndStatusIsNot(Long orderId,String status);

    List<BipOrderBackDDO> findByOrderBackDocNo(String docNo);

}
