package com.elitesland.yst.production.sale.search.store.service.impl;

import cn.hutool.core.util.ArrayUtil;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.SearchResult;
import cn.zhxu.bs.util.Builder;
import cn.zhxu.bs.util.MapBuilder;
import com.elitescloud.boot.core.support.udc.support.SysUdcProxyService;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.SaleStatisticsDtlService;
import com.elitesland.yst.production.sale.api.service.SaleStatisticsService;
import com.elitesland.yst.production.sale.api.service.StatisticsDealerDtlService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.*;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.convert.StatisticsDealerConvert;
import com.elitesland.yst.production.sale.convert.StatisticsStoreConvert;
import com.elitesland.yst.production.sale.entity.SaleStatisticsDealerDO;
import com.elitesland.yst.production.sale.entity.SaleStatisticsStoreDO;
import com.elitesland.yst.production.sale.repo.SaleStatisticsStoreDtlRepoProc;
import com.elitesland.yst.production.sale.repo.SaleStatisticsStoreRepo;
import com.elitesland.yst.production.sale.repo.SaleStatisticsStoreRepoProc;
import com.elitesland.yst.production.sale.repo.SaleStatisticsStoreRepoSqlProc;
import com.elitesland.yst.production.sale.search.bean.StatisticsDealerDtlSearchBean;
import com.elitesland.yst.production.sale.search.store.bean.*;
import com.elitesland.yst.production.sale.search.store.service.SearchBeanService;
import com.elitesland.yst.production.sale.search.store.service.StatisticsStoreSearchService;
import com.elitesland.yst.production.sale.util.BeanSearchUtil;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author wz
 * @Date 2023/07/04
 * @Version 1.0
 * @Content:
 */
@Service
public class StatisticsStoreSearchServiceImpl implements StatisticsStoreSearchService {

    @Autowired
    private SearchBeanService searchBeanService;
    @Autowired
    private SaleStatisticsStoreRepo saleStatisticsStoreRepo;
    @Autowired
    private  SaleStatisticsStoreRepoProc saleStatisticsRepoProc;
    @Autowired
    private SaleStatisticsStoreRepoSqlProc saleStatisticsStoreRepoSqlProc;
    @Autowired
    private  SysUdcProxyService sysUdcProxyService;
    @Autowired
    private SaleStatisticsService saleStatisticsService;

    @Autowired
    private SaleStatisticsDtlService saleStatisticsDtlService;

    /**
     * 经销商销售业绩分页查询
     *
     * @param pageParam 入参
     * @return 经销商销售业绩信息集合
     */
    @Override
    @SysCodeProc
    public PagingVO<SaleStatisticsStoreRespVO> page(SaleStatisticsStoreQueryVO pageParam) {
        //根据统计月份的日期拼装入参里的统计时间起始、统计时间截至
        assembleDocTime(pageParam);
        if (Objects.isNull(pageParam.getDocTimeStart()) || Objects.isNull(pageParam.getDocTimeEnd())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "统计日期为空!");
        }

//        if (Objects.nonNull(pageParam.getDocTimeStart())) {
//            String timeStrStart = pageParam.getDocTimeStart().format(DateTimeFormatter.ofPattern("yyyyMMDD"));
//            Integer integerStart = Integer.valueOf(timeStrStart);
//            pageParam.setDocTimeItStart(integerStart);
//        }
//        if (Objects.nonNull(pageParam.getDocTimeEnd())) {
//            String timeStrEnd = pageParam.getDocTimeEnd().format(DateTimeFormatter.ofPattern("yyyyMMDD"));
//            Integer integerEnd = Integer.valueOf(timeStrEnd);
//            pageParam.setDocTimeItEnd(integerEnd);
//
//        }
//        //明细入参查询
//        SaleStatisticsStoreDtlQueryVO storeDtlQueryVO = new SaleStatisticsStoreDtlQueryVO();
//        if (StringUtils.isNotBlank(pageParam.getAgentEmp())) {
//            storeDtlQueryVO.setCode(pageParam.getAgentEmp());
//        }
//        //List<Long> masIdList = selectMasIdByDtlParam(dealerDtlQueryVO);
//        MapBuilder mapBuilderDtl = this.setDtlMapBuilder(storeDtlQueryVO);
//
//        List<StatisticsStoreDtlSearchBean> searchBeanSearchResultDtl = searchBeanService.getBeanSearcher().searchAll(StatisticsStoreDtlSearchBean.class, mapBuilderDtl.build());
//        if (CollectionUtils.isEmpty(searchBeanSearchResultDtl)) {
//            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
//        }
//        List<Long> masIdList = searchBeanSearchResultDtl.stream().map(StatisticsStoreDtlSearchBean::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        if (CollectionUtils.isEmpty(masIdList)) {
//            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
//        }
//        List<Long> ids = CollectionUtils.isEmpty(pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
//        List<Long> idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        pageParam.setIds(idList);

        PagingVO<SaleStatisticsStoreRespVO> page = saleStatisticsRepoProc.pcPage(pageParam);
        if (CollectionUtils.isEmpty(page.getRecords())) {
            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        sysUdcProxyService.translate(page.getRecords());
        this.translateDealer(page.getRecords());
        return page;
    }

    /**
     * 经销商销售业绩分页查询-APP端
     *
     * @param pageParam 入参
     * @return 经销商销售业绩信息集合
     */
    @Override
    @SysCodeProc
    public PagingVO<SaleStatisticsStoreRespVO> appPage(SaleStatisticsStoreQueryVO pageParam) {
        //根据统计月份的日期拼装入参里的统计时间起始、统计时间截至
        assembleDocTime(pageParam);


//        if (Objects.nonNull(pageParam.getDocTimeStart())) {
//            String timeStrStart = pageParam.getDocTimeStart().format(DateTimeFormatter.ofPattern("yyyyMM"));
//            Integer integerStart = Integer.valueOf(timeStrStart);
//            pageParam.setDocTimeItStart(integerStart);
//        }
//        if (Objects.nonNull(pageParam.getDocTimeEnd())) {
//            String timeStrEnd = pageParam.getDocTimeEnd().format(DateTimeFormatter.ofPattern("yyyyMM"));
//            Integer integerEnd = Integer.valueOf(timeStrEnd);
//            pageParam.setDocTimeItEnd(integerEnd);
//
//        }
//        //明细入参查询
//        SaleStatisticsStoreDtlQueryVO storeDtlQueryVO = new SaleStatisticsStoreDtlQueryVO();
//        if (StringUtils.isNotBlank(pageParam.getAgentEmp())) {
//            storeDtlQueryVO.setCode(pageParam.getAgentEmp());
//        }
//        //List<Long> masIdList = selectMasIdByDtlParam(dealerDtlQueryVO);
//        MapBuilder mapBuilderDtl = this.setDtlMapBuilder(storeDtlQueryVO);
//
//        List<StatisticsStoreDtlSearchBean> searchBeanSearchResultDtl = searchBeanService.getBeanSearcher().searchAll(StatisticsStoreDtlSearchBean.class, mapBuilderDtl.build());
//        if (CollectionUtils.isEmpty(searchBeanSearchResultDtl)) {
//            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
//        }
//        List<Long> masIdList = searchBeanSearchResultDtl.stream().map(StatisticsStoreDtlSearchBean::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        if (CollectionUtils.isEmpty(masIdList)) {
//            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
//        }
//        List<Long> ids = CollectionUtils.isEmpty(pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
//        List<Long> idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        pageParam.setIds(idList);

        PagingVO<SaleStatisticsStoreRespVO> page = saleStatisticsRepoProc.appPage(pageParam);
        if (CollectionUtils.isEmpty(page.getRecords())) {
            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        sysUdcProxyService.translate(page.getRecords());
        this.translateDealer(page.getRecords());
        return page;
    }

    /**
     * 经销商销售业绩统计汇总
     *
     * @param pageParam 入参
     * @return 统计汇总信息
     */
    @Override
    public StatisticsStoreSumRespVO pageSum(SaleStatisticsStoreQueryVO pageParam) {
        //根据统计月份的日期拼装入参里的统计时间起始、统计时间截至
        assembleDocTime(pageParam);

//        if (Objects.nonNull(pageParam.getDocTimeStart())) {
//            String timeStrStart = pageParam.getDocTimeStart().format(DateTimeFormatter.ofPattern("yyyyMM"));
//            Integer integerStart = Integer.valueOf(timeStrStart);
//            pageParam.setDocTimeItStart(integerStart);
//        }
//        if (Objects.nonNull(pageParam.getDocTimeEnd())) {
//            String timeStrEnd = pageParam.getDocTimeEnd().format(DateTimeFormatter.ofPattern("yyyyMM"));
//            Integer integerEnd = Integer.valueOf(timeStrEnd);
//            pageParam.setDocTimeItEnd(integerEnd);
//
//        }
//        //明细入参查询
//        SaleStatisticsStoreDtlQueryVO storeDtlQueryVO = new SaleStatisticsStoreDtlQueryVO();
//        if (StringUtils.isNotBlank(pageParam.getAgentEmp())) {
//            storeDtlQueryVO.setCode(pageParam.getAgentEmp());
//        }
//        //List<Long> masIdList = selectMasIdByDtlParam(dealerDtlQueryVO);
//        MapBuilder mapBuilderDtl = this.setDtlMapBuilder(storeDtlQueryVO);
//
//        List<StatisticsStoreDtlSearchBean> searchBeanSearchResultDtl = searchBeanService.getBeanSearcher().searchAll(StatisticsStoreDtlSearchBean.class, mapBuilderDtl.build());
//        if (CollectionUtils.isEmpty(searchBeanSearchResultDtl)) {
//            return null;
//        }
//        List<Long> masIdList = searchBeanSearchResultDtl.stream().map(StatisticsStoreDtlSearchBean::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        if (CollectionUtils.isEmpty(masIdList)) {
//            return null;
//        }
//        List<Long> ids = CollectionUtils.isEmpty(pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
//        List<Long> idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        pageParam.setIds(idList);

        StatisticsStoreSumRespVO statisticsStoreSumRespVO = saleStatisticsStoreRepoSqlProc.pageSumPc(pageParam);
        if (Objects.isNull(statisticsStoreSumRespVO)) {
            return null;
        }
        return statisticsStoreSumRespVO;
    }

    /**
     * 经销商销售业绩统计汇总-APP端
     *
     * @param pageParam 入参
     * @return 统计汇总信息
     */
    @Override
    public StatisticsStoreSumRespVO appPageSum(SaleStatisticsStoreQueryVO pageParam) {

        //根据统计月份的日期拼装入参里的统计时间起始、统计时间截至
        assembleDocTime(pageParam);



//        if (Objects.nonNull(pageParam.getDocTimeStart())) {
//            String timeStrStart = pageParam.getDocTimeStart().format(DateTimeFormatter.ofPattern("yyyyMM"));
//            Integer integerStart = Integer.valueOf(timeStrStart);
//            pageParam.setDocTimeItStart(integerStart);
//        }
//        if (Objects.nonNull(pageParam.getDocTimeEnd())) {
//            String timeStrEnd = pageParam.getDocTimeEnd().format(DateTimeFormatter.ofPattern("yyyyMM"));
//            Integer integerEnd = Integer.valueOf(timeStrEnd);
//            pageParam.setDocTimeItEnd(integerEnd);
//
//        }
//        //明细入参查询
//        SaleStatisticsStoreDtlQueryVO storeDtlQueryVO = new SaleStatisticsStoreDtlQueryVO();
//        if (StringUtils.isNotBlank(pageParam.getAgentEmp())) {
//            storeDtlQueryVO.setCode(pageParam.getAgentEmp());
//        }
//        MapBuilder mapBuilderDtl = this.setDtlMapBuilder(storeDtlQueryVO);
//
//        List<StatisticsStoreDtlSearchBean> searchBeanSearchResultDtl = searchBeanService.getBeanSearcher().searchAll(StatisticsStoreDtlSearchBean.class, mapBuilderDtl.build());
//        if (CollectionUtils.isEmpty(searchBeanSearchResultDtl)) {
//            return null;
//        }
//        List<Long> masIdList = searchBeanSearchResultDtl.stream().map(StatisticsStoreDtlSearchBean::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        if (CollectionUtils.isEmpty(masIdList)) {
//            return null;
//        }
//        List<Long> ids = CollectionUtils.isEmpty(pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
//        List<Long> idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        pageParam.setIds(idList);

        StatisticsStoreSumRespVO statisticsStoreSumRespVO = saleStatisticsStoreRepoSqlProc.pageSumPc(pageParam);
        if (Objects.isNull(statisticsStoreSumRespVO)) {
            return null;
        }
        return statisticsStoreSumRespVO;
    }

    /**
     * 经销商销售业绩详情-头部信息和车型分页明细数据
     *
     * @param pageParam 入参
     * @return 经销商销售业绩详情信息
     */
    @Override
    @SysCodeProc
    public PagingVO<SaleStatisticsStoreRespVO> appDetails(SaleStatisticsStoreQueryVO pageParam) {

        // 当有id存在时，以下参数由id的数据获取
        if(pageParam.getId() != null){
            Optional<SaleStatisticsStoreDO> byId = saleStatisticsStoreRepo.findById(pageParam.getId());
            if(byId.isPresent()){
                pageParam.setRegion(byId.get().getRegion());
                pageParam.setSalesmanPath(byId.get().getSalesmanPath());
                pageParam.setDealerCode(byId.get().getDealerCode());
                pageParam.setStoreCode(byId.get().getStoreCode());
                pageParam.setDocTimeStart(LocalDateTime.of(byId.get().getDocTime().toLocalDate(),LocalTime.MIN));
                pageParam.setDocTimeEnd(LocalDateTime.of(byId.get().getDocTime().toLocalDate(),ConstantsSale.LOCAL_TIME_MAX));
            }
            pageParam.setId(null);
        }
        //校验入参必填项
        appDetailsCheck(pageParam);


//        //明细入参查询
//        SaleStatisticsStoreDtlQueryVO storeDtlQueryVO = new SaleStatisticsStoreDtlQueryVO();
//        if (StringUtils.isNotBlank(pageParam.getAgentEmp())) {
//            storeDtlQueryVO.setCode(pageParam.getAgentEmp());
//        }
//        //List<Long> masIdList = selectMasIdByDtlParam(dealerDtlQueryVO);
//        MapBuilder mapBuilderDtl = this.setDtlMapBuilder(storeDtlQueryVO);
//
//        List<StatisticsStoreDtlSearchBean> searchBeanSearchResultDtl = searchBeanService.getBeanSearcher().searchAll(StatisticsStoreDtlSearchBean.class, mapBuilderDtl.build());
//        if (CollectionUtils.isEmpty(searchBeanSearchResultDtl)) {
//            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
//        }
//        List<Long> masIdList = searchBeanSearchResultDtl.stream().map(StatisticsStoreDtlSearchBean::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        if (CollectionUtils.isEmpty(masIdList)) {
//            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
//        }
//        List<Long> ids = CollectionUtils.isEmpty(pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
//        List<Long> idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        pageParam.setIds(idList);

        List<SaleStatisticsStoreRespVO> query = saleStatisticsRepoProc.query(pageParam);
        sysUdcProxyService.translate(query);
        this.translateDealer(query);
        return PagingVO.<SaleStatisticsStoreRespVO>builder().total(query.size()).records(query).build();

    }


    private MapBuilder setMapBuilder(SaleStatisticsStoreQueryVO queryVO) {
        var whereSqlMapBuilder = cn.zhxu.bs.util.MapUtils.builder()
                .page(queryVO.getPageRequest().getPageNumber(), queryVO.getPageRequest().getPageSize());
        whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDeleteFlag, 0).op(FieldOps.Equal);
        if (!Objects.isNull(queryVO.getId())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getId, queryVO.getId()).op(FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty(queryVO.getIds())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getId, queryVO.getIds()).op(FieldOps.InList);
        }
        if (!StringUtils.isEmpty(queryVO.getDealerCode())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDealerCode, queryVO.getDealerCode()).op(FieldOps.Equal);
        }
        if (!StringUtils.isEmpty(queryVO.getDealerName())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDealerName, queryVO.getDealerName()).op(FieldOps.Contain);
        }
        if (!StringUtils.isEmpty(queryVO.getDealerKeyword())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDealerCode, StatisticsStoreSearchBean::getDealerName).sql("$1 like '%?' or $2 like '%?' ", queryVO.getDealerKeyword(), queryVO.getDealerKeyword());

        }
        if (!StringUtils.isEmpty(queryVO.getKeyword())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getStoreName, StatisticsStoreSearchBean::getStoreCode).sql("$1 like '%?' or $2 like '%?' ", queryVO.getKeyword(), queryVO.getKeyword());

        }
        if (!StringUtils.isEmpty(queryVO.getDealerSerialNo())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDealerSerialNo, queryVO.getDealerSerialNo()).op(FieldOps.Contain);

        }
        if (!StringUtils.isEmpty(queryVO.getRegion())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getRegion, queryVO.getRegion()).op(FieldOps.Equal);

        }
        if (!StringUtils.isEmpty(queryVO.getType())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getType, queryVO.getType()).op(FieldOps.Equal);

        }
        if (!StringUtils.isEmpty(queryVO.getSalesmanPath())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getSalesmanPath, queryVO.getSalesmanPath()).op(FieldOps.Equal);

        }
        if (!StringUtils.isEmpty(queryVO.getVehicleType())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getVehicleType, queryVO.getVehicleType()).op(FieldOps.Equal);

        }

        if (queryVO.getDocTimeStart() != null && queryVO.getDocTimeEnd() != null) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDocTime, queryVO.getDocTimeStart(), queryVO.getDocTimeEnd()).op(FieldOps.Between);
        } else {
            if (queryVO.getDocTimeStart() != null) {
                whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDocTime, queryVO.getDocTimeStart()).op(FieldOps.GreaterEqual);
            }
            if (queryVO.getDocTimeEnd() != null) {
                whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDocTime, queryVO.getDocTimeEnd()).op(FieldOps.LessEqual);
            }
        }
        if (Objects.nonNull(queryVO.getDocTimeItStart())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getYearMonthInt, queryVO.getDocTimeItStart()).op(FieldOps.GreaterEqual);
        }
        if (Objects.nonNull(queryVO.getDocTimeItEnd())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getYearMonthInt, queryVO.getDocTimeItEnd()).op(FieldOps.LessEqual);
        }
        if (Objects.nonNull(queryVO.getDocMonth())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDocMonth, queryVO.getDocMonth()).op(FieldOps.Equal);
        }
        if (Objects.nonNull(queryVO.getDocTime())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDocDate, queryVO.getDocTime().toLocalDate().toString()).op(FieldOps.Equal);
        }

        if (!Objects.isNull(queryVO.getShipQty())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getShipQty, queryVO.getShipQty()).op(FieldOps.Equal);
        }
        if (!StringUtils.isEmpty(queryVO.getItemType3())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getItemType3, queryVO.getItemType3()).op(FieldOps.Equal);
        }
        if (!StringUtils.isEmpty(queryVO.getStoreCode())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getStoreCode, queryVO.getStoreCode()).op(FieldOps.Equal);
        }
        if (!StringUtils.isEmpty(queryVO.getStoreName())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getStoreName, queryVO.getStoreName()).op(FieldOps.Equal);
        }
        if (!StringUtils.isEmpty(queryVO.getEmpCode())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getEmpCode, queryVO.getEmpCode()).op(FieldOps.Equal);
        }
        if (!StringUtils.isEmpty(queryVO.getEmpName())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getEmpName, queryVO.getEmpName()).op(FieldOps.Equal);
        }
        if (!Objects.isNull(queryVO.getUserId2())) {
            whereSqlMapBuilder.field(StatisticsStoreSearchBean::getUserId2, queryVO.getUserId2()).op(FieldOps.Equal);
        }

        return whereSqlMapBuilder;
    }
    /*********************************************/

    /**
     * 根据统计月份的日期拼装入参里的统计时间起始、统计时间截至
     * 根据传入的当前年月日获取其所在月份的第一天最小值和最后一天最大值
     *
     * @param pageParam 查询入参
     */
    public void assembleDocTime(SaleStatisticsStoreQueryVO pageParam) {
        if (Objects.isNull(pageParam.getDocTimeStart()) || Objects.isNull(pageParam.getDocTimeEnd())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "统计日期为空!");
        }
        if (Objects.nonNull(pageParam.getDocTimeStart())) {
            // 获取第一天的最小时间
            LocalDate localDateStart = pageParam.getDocTimeStart().toLocalDate();
            LocalDateTime minTime = LocalDateTime.of(localDateStart, LocalTime.MIN);
            pageParam.setDocTimeStart(minTime);
        }
        if (Objects.nonNull(pageParam.getDocTimeEnd())) {
            // 获取最后一天的最大时间
            LocalDate localDateEnd = pageParam.getDocTimeEnd().toLocalDate();
            LocalDateTime maxTime = LocalDateTime.of(localDateEnd, ConstantsSale.LOCAL_TIME_MAX);
            pageParam.setDocTimeEnd(maxTime);
        }
    }

    /**
     * 组装填充经销商销售业绩的相关信息
     *
     * @param respVOList 主表数据信息
     * @return
     */
    private void translateDealer(List<SaleStatisticsStoreRespVO> respVOList) {
        //根据主表ID查询附表信息
        List<Long> idList = respVOList.stream().map(SaleStatisticsStoreRespVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SaleStatisticsStoreDtlRespVO> dtlRespVOList = selectDtlByMasId(idList);
        respVOList.forEach(respVO -> {
            //查询附件信息
            List<SaleStatisticsStoreDtlRespVO> dtlRespVOS = dtlRespVOList.stream().filter(dtlRespVO -> Objects.equals(dtlRespVO.getMasId(), respVO.getId())).collect(Collectors.toList());
            respVO.setDtlRespVOS(dtlRespVOS);
            String docMonth = respVO.getDocTime().format(DateTimeFormatter.ofPattern("yyyy-MM"));
            respVO.setDocMonth(docMonth);

            dtlRespVOS.stream().forEach(dtlRespVO -> {
                StringJoiner spliceName = new StringJoiner(" ").add(dtlRespVO.getTypeName()).add(dtlRespVO.getName());
                if (Objects.equals(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_0, dtlRespVO.getLevel())) {
                    respVO.setAgentEmp(dtlRespVO.getCode());
                    respVO.setAgentEmpName(spliceName.toString());
                } else if (Objects.equals(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_1, dtlRespVO.getLevel())) {
                    respVO.setLevelOne(spliceName.toString());
                } else if (Objects.equals(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_2, dtlRespVO.getLevel())) {
                    respVO.setLevelTwo(spliceName.toString());
                } else if (Objects.equals(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_3, dtlRespVO.getLevel())) {
                    respVO.setLevelThree(spliceName.toString());
                } else if (Objects.equals(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_4, dtlRespVO.getLevel())) {
                    respVO.setLevelFour(spliceName.toString());
                } else if (Objects.equals(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_5, dtlRespVO.getLevel())) {
                    respVO.setLevelFive(spliceName.toString());
                }
            });

        });
    }

    private MapBuilder setDtlMapBuilder(SaleStatisticsStoreDtlQueryVO queryVO) {
        var whereSqlMapBuilderDtl = cn.zhxu.bs.util.MapUtils.builder();

        whereSqlMapBuilderDtl.field(StatisticsStoreDtlSearchBean::getDeleteFlag, 0).op(FieldOps.Equal);

        if (!Objects.isNull(queryVO.getUserId())) {
            whereSqlMapBuilderDtl.field(StatisticsStoreDtlSearchBean::getUserId, queryVO.getUserId()).op(FieldOps.Equal);
        }
        if (!StringUtils.isEmpty(queryVO.getLevel())) {
            whereSqlMapBuilderDtl.field(StatisticsStoreDtlSearchBean::getLevel, queryVO.getLevel()).op(FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty(queryVO.getLevels())) {
            whereSqlMapBuilderDtl.field(StatisticsStoreDtlSearchBean::getLevel, queryVO.getLevels()).op(FieldOps.InList);
        }
        if (!StringUtils.isEmpty(queryVO.getCode())) {
            whereSqlMapBuilderDtl.field(StatisticsStoreDtlSearchBean::getCode, queryVO.getCode()).op(FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty(queryVO.getCodes())) {
            whereSqlMapBuilderDtl.field(StatisticsStoreDtlSearchBean::getCode, queryVO.getCodes()).op(FieldOps.InList);
        }

        return whereSqlMapBuilderDtl;
    }

    private List<SaleStatisticsStoreDtlRespVO> selectDtlByMasId(List<Long> masIds) {
        if (CollectionUtils.isEmpty(masIds)) {
            return Collections.EMPTY_LIST;
        }
        SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
        queryVO.setMasIds(masIds);
        List<SaleStatisticsStoreDtlRespVO> dtlRespVOList = saleStatisticsDtlService.selectByParam(queryVO);
        if (CollectionUtils.isEmpty(dtlRespVOList)) {
            return Collections.EMPTY_LIST;
        }
        return dtlRespVOList;
    }

    private void appDetailsCheck(SaleStatisticsStoreQueryVO pageParam) {
        if (StringUtils.isBlank(pageParam.getDealerCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "客户编码为空!");
        }
//        if (Objects.isNull(pageParam.getDocMonth())) {
//            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "统计月份为空!");
//        }
        if (Objects.isNull(pageParam.getDocTimeStart())||Objects.isNull(pageParam.getDocTimeEnd())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "统计时间为空!");
        }
        if (Objects.isNull(pageParam.getStoreCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "门店编码为空!");
        }
//        if (StringUtils.isBlank(pageParam.getRegion())) {
//            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "区域为空!");
//        }
        /*if (StringUtils.isBlank(pageParam.getAgentEmp())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "业务员编码为空!");
        }*/
        /*if (StringUtils.isBlank(pageParam.getVehicleType())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "车型为空!");
        }*/
    }
}
