package com.elitesland.yst.production.sale.service;

import com.elitesland.yst.production.sale.api.service.CrmCust2Service;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustPageRespVO;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/11/16 18:00
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmCust2ServiceImpl  extends BaseServiceImpl implements CrmCust2Service {

    @Autowired
    private CrmCustService crmCustService;

    @Override
    public ApiResult<PagingVO<CrmCustPageRespVO>> searchForExport(CrmCustQueryParamVO queryParamVO) {
        queryParamVO.setSize(200000);
        return ApiResult.ok(crmCustService.search(queryParamVO));
    }

}
