package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.IterUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.yst.production.order.param.SalDoSignUserInfoDto;
import com.elitesland.yst.production.order.param.SalSoSignReqDto;
import com.elitesland.yst.production.sale.api.service.shop.HotSelingService;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.shop.*;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiDoRpcService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSettingService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.dsl.BooleanExpression;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;


@Service
@RequiredArgsConstructor
@Slf4j
public class HotSellingServiceImpl implements HotSelingService {
    @Autowired
    private BipOrderRepo bipOrderRepo;
    @Autowired
    private BipOrderDRepo bipOrderDRepo;

    @Autowired
    private BipItemRepo bipItemRepo;

    @Autowired
    private BipOrderRepoProc bipOrderRepoProc;

    @Autowired
    private RmiSettingService rmiSettingService;

    @Autowired
    private BipCustUserBindRepoProc bipCustUserBindRepoProc;

    @Autowired
    private RmiDoRpcService rmiDoRpcService;

    @Autowired
    private BipMessageRepo bipMessageRepo;


    private static final String SETTING_CODE = "ORDER_AUTO_SIGN_DAY";

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update90HotSelling() {
        log.info("热销商品-------------------");
        //所有90t天支付订单数量初始化为0
        List<BipItemDO> itemDoList = getItem();
        if(null != itemDoList && !itemDoList.isEmpty()){
            itemDoList.stream().forEach(item -> {
                item.setNumSale90(0L);
                bipItemRepo.save(item);
            });
        }
        //查询90天支付成功的订单
        List<BipOrderDO> allOrders = getPaySuccessOrder();
        log.info("查询90天支付成功的订单-------:"+allOrders.size());
        if(null != allOrders && !allOrders.isEmpty()){
            //查询订单明细
            allOrders.stream().forEach(order ->{
                List<BipOrderDDO> orderds = getOrderDetail(order.getId());
                log.info("热销orders------------:"+JSON.toJSONString(orderds));
                if(null != orderds && !orderds.isEmpty()){
                    orderds.stream().forEach(orderd ->{
                        log.info("热销orderd------------:"+JSON.toJSONString(orderd));
                        if(null != orderd.getOuId() && null != orderd.getItemId()){
                            BipItemDO item = getItemById(orderd.getItemId(),orderd.getOuId());
                            if(null != item && null != orderd.getBuyQty()){
                                log.info("热销商品增加数量---:"+ JSON.toJSONString(item));
                                item.setNumSale90(item.getNumSale90() + orderd.getBuyQty());
                                log.info("热销商品增加之后---:"+ JSON.toJSONString(item));
                                bipItemRepo.save(item);
                                log.info("热销商品保存成功");
                            }
                        }
                    });
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void auOrderSignPush() {
        // 1.查询所有订单在自动签收范围之内的订单
        SysSettingVO settingByCode = rmiSettingService.findSettingByCode(SETTING_CODE);
        String settingVal = settingByCode.getSettingVal();

        List<String> aoOrders = bipOrderRepo.findAoOrders(Integer.parseInt(settingVal),
                UdcEnum.SAL_SO_STATUS_SHIP.getValueCode(),UdcEnum.SAL_SO_TYPE2_B.getValueCode(),
                UdcEnum.COM_DOC_CLS_SO.getValueCode(),UdcEnum.SAL_SO_TYPE_SOB1.getValueCode(),UdcEnum.SAL_SO_TYPE_SOB2.getValueCode());
        log.info("自动签收订单号：{}", JSON.toJSONString(aoOrders));

        List<BipOrderDO> bipOrderDOList = bipOrderRepo.findAllByDocNoIn(aoOrders);

        // 查询签收人名称
//        List<String> accountIds = bipOrderDOList.stream().map(BipOrderDO::getContPerson).distinct().filter(Objects::nonNull)
//                .collect(Collectors.toList());
//        List<BipCustUserBindDO> allByUserIds = bipCustUserBindRepoProc.getAllByUserIds(accountIds);
        // 2.调用mos的方法进行签收
        bipOrderDOList.forEach(bip ->{
            SalSoSignReqDto salSoSignReqDto = new SalSoSignReqDto();
            salSoSignReqDto.setDocNo(bip.getDocNo());
            SalDoSignUserInfoDto salDoSignUserInfoDto = new SalDoSignUserInfoDto();
            salDoSignUserInfoDto.setConfirmUserId(bip.getAdressId());
            salDoSignUserInfoDto.setConfirmUserName(bip.getContPerson());
            salSoSignReqDto.setSalDoSignUserInfoDto(salDoSignUserInfoDto);
            if (!ObjectUtils.isEmpty(bip.getAdressId()) && !ObjectUtils.isEmpty(bip.getContPerson())){
//                ApiResult<Boolean> result = rmiDoRpcService.SignBySalSo(salSoSignReqDto);
//                if (result.isSuccess()){
//                    bip.setAutoSignFlag(Boolean.TRUE);
//                }else{
//                    bip.setAutoSignFlag(Boolean.FALSE);
//                }
            }
        } );
        // 3.修改我方订单的状态
        List<BipOrderDO> bipOrderDOS = bipOrderDOList.stream().filter(b -> b.getAutoSignFlag().equals(Boolean.TRUE)).collect(Collectors.toList());
        List<BipOrderDO> bipOrderDOS1 = bipOrderDOS.stream().filter(b -> !ObjectUtils.isEmpty(b.getAdressId()) && !ObjectUtils.isEmpty(b.getContPerson())).collect(Collectors.toList());
        bipOrderDOS1.forEach(i -> i.setStatus(ConstantsSale.SIGNED));
        bipOrderRepo.saveAll(bipOrderDOS1);
        // 4.生成消息推送
        List<BipMessageDO> bipMessageDOS = bipOrderDOS1.stream().map(mes -> {
            BipMessageDO bipMessageDO = new BipMessageDO();
            bipMessageDO.setTitle("【签收通知】");
            bipMessageDO.setContext("您有订单已自动签收了");
            bipMessageDO.setToCustId(mes.getCustAccountId());
            bipMessageDO.setStatus(UdcEnum.MESSAGE_STATUS_NOTREAD.getValueCode());
            return bipMessageDO;
        }).collect(Collectors.toList());
        bipMessageRepo.saveAll(bipMessageDOS);
    }

    public BipItemDO getItemById(Long itemId,Long ouId){
        QBipItemDO qBipItemDO = QBipItemDO.bipItemDO;
        BooleanExpression expression = qBipItemDO.id.eq(itemId).and(qBipItemDO.ouId.eq(ouId));
        Optional<BipItemDO> optional = bipItemRepo.findOne(expression);
        if(optional.isEmpty()){
            return null;
        }
        return optional.get();
    }

    public List<BipItemDO> getItem(){
        QBipItemDO qBipItemDO = QBipItemDO.bipItemDO;
        BooleanExpression expression = qBipItemDO.numSale90.gt(0L).and(qBipItemDO.deleteFlag.eq(0));
        Iterable<BipItemDO> iterables = bipItemRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
            return Lists.newArrayList(iterables);
        }
        return null;
    }

    /**
     * 查询订单明细
     */
    public List<BipOrderDDO> getOrderDetail(Long orderId){
        QBipOrderDDO qBipOrderDDo = QBipOrderDDO.bipOrderDDO;
        BooleanExpression expression = qBipOrderDDo.orderId.eq(orderId).and(qBipOrderDDo.itemType.eq(UdcEnum.ITM_ITM_TYPE_10.getValueCode()));
        Iterable<BipOrderDDO> iterables = bipOrderDRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
            return Lists.newArrayList(iterables);
        }
        return null;
    }

    /**
     * 90天已支付订单
     * @return
     */
    public List<BipOrderDO> getPaySuccessOrder(){
        LocalDateTime date90After = LocalDateTime.now().minusDays(90);
        QBipOrderDO qBipOrderDo = QBipOrderDO.bipOrderDO;
        BooleanExpression expression = qBipOrderDo.payStatus.eq("ps").and(qBipOrderDo.payTime.between(date90After,LocalDateTime.now()));
        Iterable<BipOrderDO> iterables = bipOrderRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
           return Lists.newArrayList(iterables);
        }
        return null;
    }


}
