package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.service.shop.MktDiscountGiftService;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountGiftDSaveVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountGiftQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountGiftSaveVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.*;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.MktDiscountGiftConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.shop.*;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.dsl.BooleanExpression;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 满减赠折扣赠服务
 * </p>
 *
 * @author ssy
 * @since 2021/8/23
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class MktDiscountGiftServiceImpl extends BaseServiceImpl implements MktDiscountGiftService {

    /**
     * service
     */
    private final OrgEmpRpcService orgEmpRpcService;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final BipCompanyManageService bipCompanyManageService;
    /**
     * repo
     */
    private final MktDiscountGiftRepo mktDiscountGiftRepo;
    private final MktDiscountGiftDRepo mktDiscountGiftDRepo;
    private final MktGiftRepo mktGiftRepo;
    private final BipItemSkuRepo bipItemSkuRepo;
    /**
     * proc
     */
    private final MktGiftRepoProc mktGiftRepoProc;
    private final MktDiscountGiftRepoProc mktDiscountGiftRepoProc;
    private final MktDiscountOffsetRepoProc mktDiscountOffsetRepoProc;

    @Autowired
    private UdcProvider udcProvider;

    @Override
    public PagingVO<MktDiscountGiftRespVO> search(MktDiscountGiftQueryVO queryParam) {

        List<String> first = mktDiscountGiftRepoProc.findDiscountCode(queryParam.getItemCode());
        queryParam.setCodeByItem(first!=null && first.size()>0 ? first.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()) : new ArrayList<>());
        List<String> second = mktGiftRepoProc.findDiscountCode(queryParam.getGiftCode());
        queryParam.setCodeByGift(second!=null && second.size()>0 ? second.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()) : new ArrayList<>());

        QMktDiscountGiftDO qmktDiscountGiftDO = QMktDiscountGiftDO.mktDiscountGiftDO;
        var jpaQuery = mktDiscountGiftRepoProc.select(queryParam);
        long total = jpaQuery.fetchCount();
        if (total == 0) {
            return PagingVO.<MktDiscountGiftRespVO>builder().build();
        }
        var pageRequest = wrapperPageRequest(queryParam.getPageRequest(), null);
        appendPageAndSort(jpaQuery, pageRequest, qmktDiscountGiftDO);
        List<MktDiscountGiftRespVO> pageResult = jpaQuery.fetch();
        // udc 翻译
        transUdc(pageResult);
        return PagingVO.<MktDiscountGiftRespVO>builder().total(total).records(pageResult).build();
    }

    @Override
    public Optional<MktDiscountGiftRespVO> findCodeOne(String code) {
        QMktDiscountGiftDO qmktDiscountGiftDO = QMktDiscountGiftDO.mktDiscountGiftDO;
        MktDiscountGiftRespVO mktDiscountGiftRespVO = mktDiscountGiftRepoProc.select(null).where(qmktDiscountGiftDO.code.eq(code)).fetchOne();
        if (mktDiscountGiftRespVO == null) {
            return Optional.empty();
        }
        setDetails(mktDiscountGiftRespVO);
        // udc 翻译
        transUdc(Collections.singletonList(mktDiscountGiftRespVO));
        return Optional.of(mktDiscountGiftRespVO);
    }

    @Override
    public Optional<MktDiscountGiftRespVO> findIdOne(Long id) {
        QMktDiscountGiftDO qmktDiscountGiftDO = QMktDiscountGiftDO.mktDiscountGiftDO;
        MktDiscountGiftRespVO mktDiscountGiftRespVO = mktDiscountGiftRepoProc.select(null).where(qmktDiscountGiftDO.id.eq(id)).fetchOne();
        if (mktDiscountGiftRespVO == null) {
            return Optional.empty();
        }
        setDetails(mktDiscountGiftRespVO);
        // udc 翻译
        transUdc(Collections.singletonList(mktDiscountGiftRespVO));
        return Optional.of(mktDiscountGiftRespVO);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<Long> createBatch(List<MktDiscountGiftSaveVO> list) {
        //新增数据
        if (!CollectionUtil.isEmpty(list)) {
            // 1.数据校验
            OrgUserEmpInfoRpcDTO userEmpInfo = getCurrentEmpInfo();
            List<BipCompanyManageRespVO> manageByOuIds = bipCompanyManageService.findCompanyManageByOuIds(Arrays.asList(userEmpInfo.getOuId()));
            if (CollectionUtils.isEmpty(manageByOuIds)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户公司信息为空");
            }
            paramCheck(list, true);
//            paramDbCheck(list, true, userEmpInfo.getOuId());
            // 2.业务处理
            List<Long> result = list.stream().map(i -> {
                // 保存主表
                MktDiscountGiftConvert mktDiscountGiftConvert = MktDiscountGiftConvert.INSTANCE;
                MktDiscountGiftDO mktDiscountGiftDO = mktDiscountGiftConvert.saveVoToDo(i);
                mktDiscountGiftDO.setSecOuId(userEmpInfo.getOuId());
                mktDiscountGiftDO.setSecUserId(userEmpInfo.getUserId());
                mktDiscountGiftDO.setSecBuId(manageByOuIds.get(0).getBuId());
                mktDiscountGiftDO.setId(null);  // ID 置为null

                String code = rmiSysNextNumberService.generateCode("yst-sale","CX", new ArrayList<>());
                mktDiscountGiftDO.setCode(code);
                // 填充当前登录人的ou、bu信息
                mktDiscountGiftDO.setOuId(userEmpInfo.getOuId());
                mktDiscountGiftDO.setOuCode(userEmpInfo.getOuCode());
                mktDiscountGiftDO.setOuName(userEmpInfo.getOuName());
                mktDiscountGiftDO.setBuId(userEmpInfo.getBuId());
                mktDiscountGiftDO.setBuCode(userEmpInfo.getBuCode());
                mktDiscountGiftDO.setBuName(userEmpInfo.getBuName());
                mktDiscountGiftDO.setDeleteFlag(ConstantsSale.COMMON_DELETE_NO);
                Long masId = mktDiscountGiftRepo.save(mktDiscountGiftDO).getId();
                // 保存明细
                List<MktDiscountGiftDDO> mktDiscountGiftDDOS = i.getDetails().stream().map(d -> {
                    MktDiscountGiftDDO mktDiscountGiftDDO = mktDiscountGiftConvert.dsaveVoToDo(d);mktDiscountGiftDO.setSecOuId(userEmpInfo.getOuId());
                    String skuCode = mktDiscountGiftDDO.getItemCode();
                    if(StringUtils.isNotBlank(skuCode)){
                        //查询skuId进行补偿
                        QBipItemSkuDO qBipItemSkuDO = QBipItemSkuDO.bipItemSkuDO;
                        BooleanExpression exp = qBipItemSkuDO.skuCode.eq(skuCode).and(qBipItemSkuDO.deleteFlag.eq(0));
                        Iterable<BipItemSkuDO> iterables = bipItemSkuRepo.findAll(exp);
                        if(!IterUtil.isEmpty(iterables)){
                            List<BipItemSkuDO> listSkus = Lists.newArrayList(iterables);
                            mktDiscountGiftDDO.setItemId(listSkus.get(0).getId());
                        }
                    }

                    mktDiscountGiftDDO.setSecOuId(userEmpInfo.getOuId());
                    mktDiscountGiftDDO.setSecUserId(userEmpInfo.getUserId());
                    mktDiscountGiftDDO.setSecBuId(manageByOuIds.get(0).getBuId());
                    mktDiscountGiftDDO.setId(null);
                    mktDiscountGiftDDO.setMktDiscountGiftId(masId);
                    mktDiscountGiftDDO.setDiscountGiftCode(code);
                    mktDiscountGiftDDO.setDeleteFlag(ConstantsSale.COMMON_DELETE_NO);
                    return mktDiscountGiftDDO;
                }).collect(Collectors.toList());
                mktDiscountGiftDRepo.saveAll(mktDiscountGiftDDOS);
                // 保存赠品明细
                List<MktGiftDO> mktGiftDOS = i.getGiftDetails().stream().map(d -> {
                    MktGiftDO mktGiftDO = mktDiscountGiftConvert.gsaveVoToDo(d);
                    mktGiftDO.setStockNowNum(d.getStockNum());
                    mktGiftDO.setSecOuId(userEmpInfo.getOuId());
                    mktGiftDO.setSecUserId(userEmpInfo.getUserId());
                    mktGiftDO.setSecBuId(manageByOuIds.get(0).getBuId());
                    mktGiftDO.setId(null);
                    mktGiftDO.setDiscountGiftCode(code);
                    mktGiftDO.setDeleteFlag(ConstantsSale.COMMON_DELETE_NO);
                    return mktGiftDO;
                }).collect(Collectors.toList());
                mktGiftRepo.saveAll(mktGiftDOS);
                return mktDiscountGiftDO.getId();
            }).collect(Collectors.toList());
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(MktDiscountGiftSaveVO updateParam) {
        OrgUserEmpInfoRpcDTO userEmpInfo = getCurrentEmpInfo();
        List<BipCompanyManageRespVO> manageByOuIds = bipCompanyManageService.findCompanyManageByOuIds(Arrays.asList(userEmpInfo.getOuId()));
        if (CollectionUtils.isEmpty(manageByOuIds)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户公司信息为空");
        }
        // 1.数据校验
        paramCheck(Collections.singletonList(updateParam), false);
        // 原数据
        MktDiscountGiftDO oldDO = mktDiscountGiftRepo.findById(updateParam.getId()).get();
        Assert.isFalse(Validator.isNull(oldDO), "[满减赠促销]操作数据不存在");
//        paramDbCheck(Collections.singletonList(updateParam), false, oldDO.getOuId());
        // 2.业务处理
        MktDiscountGiftConvert mktDiscountGiftConvert = MktDiscountGiftConvert.INSTANCE;
        MktDiscountGiftDO mktDiscountGiftDO = mktDiscountGiftConvert.saveVoToDo(updateParam);
        mktDiscountGiftDO.setSecOuId(userEmpInfo.getOuId());
        mktDiscountGiftDO.setSecUserId(userEmpInfo.getUserId());
        mktDiscountGiftDO.setSecBuId(manageByOuIds.get(0).getBuId());
        mktDiscountGiftDO.setOuId(oldDO.getOuId());
        mktDiscountGiftDO.setOuCode(oldDO.getOuCode());
        mktDiscountGiftDO.setOuName(oldDO.getOuName());
        mktDiscountGiftDO.setBuId(oldDO.getBuId());
        mktDiscountGiftDO.setBuCode(oldDO.getBuCode());
        mktDiscountGiftDO.setBuName(oldDO.getBuName());
        if (mktDiscountGiftDO.getDeleteFlag() == null) {
            mktDiscountGiftDO.setDeleteFlag(ConstantsSale.COMMON_DELETE_NO);
        }
        List<MktDiscountGiftDDO> details = updateParam.getDetails().stream().map(i -> {
            MktDiscountGiftDDO mktDiscountGiftDDO = mktDiscountGiftConvert.dsaveVoToDo(i);
            String skuCode = mktDiscountGiftDDO.getItemCode();
            if(StringUtils.isNotBlank(skuCode)){
                //查询skuId进行补偿
                QBipItemSkuDO qBipItemSkuDO = QBipItemSkuDO.bipItemSkuDO;
                BooleanExpression exp = qBipItemSkuDO.skuCode.eq(skuCode).and(qBipItemSkuDO.deleteFlag.eq(0));
                Iterable<BipItemSkuDO> iterables = bipItemSkuRepo.findAll(exp);
                if(!IterUtil.isEmpty(iterables)){
                    List<BipItemSkuDO> listSkus = Lists.newArrayList(iterables);
                    mktDiscountGiftDDO.setItemId(listSkus.get(0).getId());
                }
            }
            mktDiscountGiftDDO.setSecOuId(userEmpInfo.getOuId());
            mktDiscountGiftDDO.setSecUserId(userEmpInfo.getUserId());
            mktDiscountGiftDDO.setSecBuId(manageByOuIds.get(0).getBuId());
            mktDiscountGiftDDO.setMktDiscountGiftId(oldDO.getId());
            mktDiscountGiftDDO.setDiscountGiftCode(oldDO.getCode());
            if (mktDiscountGiftDDO.getDeleteFlag() == null) {
                mktDiscountGiftDDO.setDeleteFlag(ConstantsSale.COMMON_DELETE_NO);
            }
            return mktDiscountGiftDDO;
        }).collect(Collectors.toList());
        List<MktGiftDO> giftDetails = updateParam.getGiftDetails().stream().map(i -> {
            MktGiftDO mktGiftDO = mktDiscountGiftConvert.gsaveVoToDo(i);
            mktGiftDO.setSecOuId(userEmpInfo.getOuId());
            mktGiftDO.setSecUserId(userEmpInfo.getUserId());
            mktGiftDO.setSecBuId(manageByOuIds.get(0).getBuId());
            mktGiftDO.setDiscountGiftCode(oldDO.getCode());
            if (mktGiftDO.getDeleteFlag() == null) {
                mktGiftDO.setDeleteFlag(ConstantsSale.COMMON_DELETE_NO);
            }
            return mktGiftDO;
        }).collect(Collectors.toList());
        mktDiscountGiftRepo.save(mktDiscountGiftDO);
        mktDiscountGiftDRepo.saveAll(details);
        mktGiftRepo.saveAll(giftDetails);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<Long> idList) {
        if (CollectionUtil.isEmpty(idList)) {
            return;
        }
        List<String> codeList = mktDiscountGiftRepoProc.getCodeById(idList);
        mktDiscountGiftRepoProc.deleteIdBatch(codeList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteDBatch(List<Long> idList) {
        List<MktDiscountGiftDDO> allDetails = mktDiscountGiftDRepo.findAllById(idList);
        allDetails.forEach(i -> {
            mktDiscountGiftRepoProc.deleteDetailInfo(i.getId());
            mktDiscountGiftRepoProc.deleteGiftInfo(i.getDiscountGiftCode(), i.getItemId());
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteGiftBatch(List<Long> idList) {
        mktDiscountGiftRepoProc.deleteGiftInfo(idList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDeleteFlag(Long id) {
        this.updateDeleteFlagBatch(Collections.singletonList(id));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDeleteFlagBatch(List<Long> ids) {
        Assert.isFalse(CollectionUtil.isEmpty(ids), "[满减赠促销]操作数据为空");

        List<String> codeList = mktDiscountGiftRepoProc.getCodeById(ids);
        mktDiscountGiftRepoProc.updateDeleteFlagBatch(codeList, ConstantsSale.COMMON_DELETE_YSE);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void appr(List<Long> ids, String status) {
        Map<String, String> statusUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_STATUS");
        Assert.isFalse(CollectionUtil.isEmpty(ids), "[满减赠促销]操作数据为空");
        Assert.isTrue(checkUdcValueExit(statusUdcMap, status), "促销状态异常");
        if(status.equals("ENABLE")){
            //查询详情商品  同一商品不能同时满减和满赠
            boolean flag = getOffsetSkuIds(ids);
            log.info("查询满减满赠同时存在：---------"+flag);
            if(!flag){
                throw new BusinessException("一个商品只能是满减或买赠");
            }
        }
        mktDiscountGiftRepoProc.updateStatusBatch(ids, status);
    }

    public boolean getOffsetSkuIds(List<Long> ids){
        for(Long id : ids){
            //满减ID
            List<String> giftItemCodes = mktDiscountGiftRepoProc.getGiftSkuCode(id);
            Long ouId = mktDiscountGiftRepoProc.getOuIdById(id).get(0);
            //查询是否存在满赠
            List<Long> offSetIds = mktDiscountOffsetRepoProc.getOffsetId(ouId);
            if(null != offSetIds && !offSetIds.isEmpty()){
                //查询买赠详情skuId
                List<String> offsetSkuCodes = mktDiscountOffsetRepoProc.getOffsetDetailSkuCode(offSetIds);
                if(!offsetSkuCodes.isEmpty() && !offsetSkuCodes.isEmpty()){
                    //交集s
                    offsetSkuCodes.retainAll(giftItemCodes);
                    if(!offsetSkuCodes.isEmpty()){
                        return false;
                    }
                }
            }
        }
        return true;
    }



    @Override
    public List<MktDiscountGiftVO> findMktDiscountGiftByParam(Long ouId, String customLevel, List<Long> itemIds) {
        Assert.isFalse(CollectionUtil.isEmpty(itemIds), "商品数据为空");
        Assert.isFalse(Validator.isNull(ouId), "公司数据为空");
        // 主表、明细信息
        List<MktDiscountGiftVO> mktDiscountGiftVOS =
                mktDiscountGiftRepoProc.findMktDisCountGift(ouId, customLevel, LocalDateTime.now(), itemIds).fetch();

        // 买赠赠品集合
        mktDiscountGiftVOS.forEach(i ->
                i.setGiftDetails(mktDiscountGiftRepoProc.selectGiftDetailsByMasCodeOrItemId(i.getCode(), i.getItemId()).fetch()));
        // UDC翻译
        if (CollectionUtil.isNotEmpty(mktDiscountGiftVOS)) {
            Map<String, String> custGroupUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "CUST_GROUP");
            Map<String, String> statusUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_STATUS");
            Map<String, String> typeUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_TYPE");
            Map<String, String> uomUdcMap = udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
            Map<String, String> giftMaterielUdcMap = udcProvider.getValueMapByUdcCode("yst-supp", "ITEM_TYPE2");
            Map<String, String> giftTypeUdcMap = udcProvider.getValueMapByUdcCode("yst-supp", "ITEM_TYPE");

            mktDiscountGiftVOS.forEach(i -> {
                if (StringUtils.isNotBlank(i.getCustomLevel()) && !MapUtils.isEmpty(custGroupUdcMap)) {
                    i.setCustomLevelName(custGroupUdcMap.get(i.getCustomLevel()));
                }
                if (StringUtils.isNotBlank(i.getType()) && !MapUtils.isEmpty(typeUdcMap)) {
                    i.setTypeName(typeUdcMap.get(i.getType()));
                }
                if (StringUtils.isNotBlank(i.getStatus()) && !MapUtils.isEmpty(statusUdcMap)) {
                    i.setStatusName(statusUdcMap.get(i.getStatus()));
                }
                if (StringUtils.isNotBlank(i.getUom()) && !MapUtils.isEmpty(uomUdcMap)) {
                    i.setUomName(uomUdcMap.get(i.getUom()));
                }
                // 赠品明细
                if (!CollectionUtil.isEmpty(i.getGiftDetails())) {
                    i.getGiftDetails().forEach(d -> {
                        if (StringUtils.isNotBlank(d.getMateriel()) && !MapUtils.isEmpty(giftMaterielUdcMap)) {
                            d.setMaterielName(giftMaterielUdcMap.get(d.getMateriel()));
                        }
                        if (StringUtils.isNotBlank(d.getType()) && !MapUtils.isEmpty(giftTypeUdcMap)) {
                            d.setTypeName(giftTypeUdcMap.get(d.getType()));
                        }
                    });
                }
            });
        }
        return mktDiscountGiftVOS;
    }

    /**
     * 根据主表ID 获取明细，并赋值
     *
     * @param mktDiscountGiftRespVO 折扣信息
     */
    private void setDetails(MktDiscountGiftRespVO mktDiscountGiftRespVO) {
        if (mktDiscountGiftRespVO == null) {
            return;
        }
        // 买赠明细集合
        List<MktDiscountGiftRespDVO> details = mktDiscountGiftRepoProc.selectDetailsByMasIdOrCode(mktDiscountGiftRespVO.getId(), null).fetch();
        // 买赠赠品集合
        List<MktGiftRespVO> giftDetails = mktDiscountGiftRepoProc.selectGiftDetailsByMasCodeOrItemId(mktDiscountGiftRespVO.getCode(), null).fetch();

        mktDiscountGiftRespVO.setDetails(details);
        mktDiscountGiftRespVO.setGiftDetails(giftDetails);
    }

    /**
     * 获取当前登录人信息
     *
     * @return 当前登录人信息
     */
    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户已失效,请重登录重试");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法获取当前用户信息");
        }
        return userEmpInfo;
    }

    /**
     * 数据校验，部分字段附默认值
     *
     * @param source 保存信息
     * @param isNew  是否新增
     */
    private void paramCheck(List<MktDiscountGiftSaveVO> source, boolean isNew) {

        Map<String, String> custGroupUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "CUST_GROUP");
        Map<String, String> statusUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_STATUS");
        Map<String, String> typeUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_TYPE");
        Map<String, String> uomUdcMap = udcProvider.getValueMapByUdcCode("yst-supp", "UOM");

        source.forEach(i -> {
            Assert.isFalse(Validator.isNull(i), "[满减赠促销]操作数据为空");
            if (!isNew) {
                Assert.isFalse(Validator.isNull(i.getId()), "更新主键缺失");
                Assert.isFalse(Validator.isEmpty(i.getCode()), "促销编码为空");
            }
            Assert.isFalse(Validator.isEmpty(i.getName()), "促销名称为空");
            Assert.isFalse(Validator.isNull(i.getValidStime()), "促销生效时间为空");
            Assert.isFalse(Validator.isNull(i.getValidEtime()), "促销失效时间为空");
            Assert.isFalse(Validator.isEmpty(i.getType()), "促销条件为空");
            Assert.isFalse(CollectionUtil.isEmpty(i.getDetails()), "促销明细为空");
            Assert.isFalse(CollectionUtil.isEmpty(i.getGiftDetails()), "促销赠品明细为空");
            Assert.isTrue(checkUdcValueExit(typeUdcMap, i.getType()), "促销类型异常");
            Assert.isTrue(checkUdcValueExit(statusUdcMap, i.getStatus()), "促销状态异常");

            if (!StringUtils.isEmpty(i.getCustomLevel())) {
                Assert.isTrue(checkUdcValueExit(custGroupUdcMap, i.getCustomLevel()), "客户等级数据异常");
            }
            List<Long> itemIds = i.getDetails().stream().map(MktDiscountGiftDSaveVO::getItemId).distinct().collect(Collectors.toList());
            Assert.isFalse(itemIds.size() != i.getDetails().size(), "明细中存在相同的商品");
            i.getDetails().forEach(d -> {
                Assert.isTrue(checkUdcValueExit(uomUdcMap, d.getUom()), "明细商品单位异常");
                Assert.isFalse(i.getGiftDetails().stream().noneMatch(m -> d.getItemId().equals(m.getDiscountGiftItemId())), "满赠赠品为空");
                if (UdcEnum.MKT_DISCOUNT_OFFSET_TYPE_0.getValueCode().equals(i.getType())) {
                    Assert.isFalse(Validator.isNull(d.getLimitNum()), "【促销条件】为【按数量】，满赠达标数量为空");
                    d.setLimitAmt(null);
                } else if (UdcEnum.MKT_DISCOUNT_OFFSET_TYPE_1.getValueCode().equals(i.getType())) {
                    Assert.isFalse(Validator.isNull(d.getLimitAmt()), "【促销条件】为【按金额】，满赠达标金额为空");
                    d.setLimitNum(null);
                }

            });
        });
    }

    /**
     * 数据库唯一性校验
     *
     * @param source 入参信息
     */
    private void paramDbCheck(List<MktDiscountGiftSaveVO> source, boolean isNew, Long ouId) {
        source.forEach(i -> {
            // 未失效的数据 进行校验
            if (i.getValidEtime().isAfter(LocalDateTime.now())) {
                List<Long> itemIds = i.getDetails().stream().map(MktDiscountGiftDSaveVO::getItemId).distinct().collect(Collectors.toList());
                List<Tuple> itemCodes =
                        mktDiscountGiftRepoProc.checkItemExitsInValidDate(isNew ? null : i.getId(), ouId, i.getCustomLevel(), i.getValidStime(), i.getValidEtime(), itemIds);
                Assert.isFalse(itemCodes.size() > 0, "数据库已存在符合生效规则的[买赠活动]商品明细：{}",
                        String.join(StrUtil.COMMA, itemCodes.stream().map(t ->
                                StrUtil.format("[促销编码为：{}，商品编号为:{}]", t.get(0, String.class), t.get(1, String.class))).collect(Collectors.toList())));
                itemCodes =
                        mktDiscountOffsetRepoProc.checkItemExitsInValidDate(isNew ? null : i.getId(), ouId, i.getCustomLevel(), i.getValidStime(), i.getValidEtime(), itemIds);
                Assert.isFalse(itemCodes.size() > 0, "数据库已存在符合生效规则的[满减活动]商品明细：{}",
                        String.join(StrUtil.COMMA, itemCodes.stream().map(t ->
                                StrUtil.format("[促销编码为：{}，商品编号为:{}]", t.get(0, String.class), t.get(1, String.class))).collect(Collectors.toList())));
            }
        });
    }

    /**
     * udc 翻译
     *
     * @param source 入参
     */
    private void transUdc(List<MktDiscountGiftRespVO> source) {
        Map<String, String> custGroupUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "CUST_GROUP");
        Map<String, String> statusUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_STATUS");
        Map<String, String> typeUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_TYPE");
        Map<String, String> uomUdcMap = udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
        Map<String, String> giftMaterielUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "ITEM_TYPE2");
        Map<String, String> giftTypeUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "ITEM_TYPE");

        source.forEach(i -> {
            // 表头
            if (StringUtils.isNotBlank(i.getCustomLevel()) && !MapUtils.isEmpty(custGroupUdcMap)) {
                i.setCustomLevelName(custGroupUdcMap.get(i.getCustomLevel()));
            }
            if (StringUtils.isNotBlank(i.getType()) && !MapUtils.isEmpty(typeUdcMap)) {
                i.setTypeName(typeUdcMap.get(i.getType()));
            }
            if (StringUtils.isNotBlank(i.getStatus()) && !MapUtils.isEmpty(statusUdcMap)) {
                i.setStatusName(statusUdcMap.get(i.getStatus()));
            }
            // 表明细
            if (!CollectionUtil.isEmpty(i.getDetails())) {
                i.getDetails().forEach(d -> {
                    if (StringUtils.isNotBlank(d.getUom()) && !MapUtils.isEmpty(uomUdcMap)) {
                        d.setUomName(uomUdcMap.get(d.getUom()));
                    }
                });
            }
            // 赠品明细
            if (!CollectionUtil.isEmpty(i.getGiftDetails())) {
                i.getGiftDetails().forEach(d -> {
                    if (StringUtils.isNotBlank(d.getMateriel()) && !MapUtils.isEmpty(giftMaterielUdcMap)) {
                        d.setMaterielName(giftMaterielUdcMap.get(d.getMateriel()));
                    }
                    if (StringUtils.isNotBlank(d.getType()) && !MapUtils.isEmpty(giftTypeUdcMap)) {
                        d.setTypeName(giftTypeUdcMap.get(d.getType()));
                    }
                });
            }
        });
    }


}
