/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.controller.shop;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.service.shop.BipCartService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCartParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipFareAmtQueryParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipBuyNowSettleParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipCartSettleParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCartVo;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.AttrAPPRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.AttrAppParamVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bip/cart"})
@Api(value="\u8d2d\u7269\u8f66", tags={"\u8d2d\u7269\u8f66"})
public class BipItemCartController {
    private static final Logger log = LoggerFactory.getLogger(BipItemCartController.class);
    @Autowired
    private BipCartService bipCartService;
    @Autowired
    private BipItemService bipItemService;

    @PostMapping(value={"/find/{ouId}"})
    @ApiOperation(value="\u6211\u7684\u8d2d\u7269\u8f66")
    @ApiOperationSupport(order=1)
    public ApiResult<BipCartVo> findMyCart(@PathVariable Long ouId) {
        BipCartVo bipCartVo = this.bipCartService.findMyCart(ouId);
        if (bipCartVo == null) {
            return ApiResult.ok(null, (String)"\u6682\u65e0\u8d2d\u7269\u4fe1\u606f!");
        }
        return ApiResult.ok((Object)bipCartVo);
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u8d2d\u7269\u8f66\u66f4\u65b0")
    @ApiOperationSupport(order=2)
    public ApiResult updateCart(@RequestBody BipCartParmVO bipCartParmVO) {
        this.bipCartService.updateCart(bipCartParmVO);
        return ApiResult.ok();
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u8d2d\u7269\u8f66\u65b0\u589e")
    @ApiOperationSupport(order=3)
    public ApiResult addItemCart(@RequestBody BipCartParmVO bipCartParmVO) {
        this.bipCartService.addItemToCart(bipCartParmVO);
        return ApiResult.ok();
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u8d2d\u7269\u8f66\u5220\u9664")
    @ApiOperationSupport(order=4)
    public ApiResult deleteCart(@RequestBody List<Long> idList) {
        this.bipCartService.deleteCart(idList);
        return ApiResult.ok();
    }

    @PostMapping(value={"/per/pay/{ouId}"})
    @ApiOperation(value="\u8d2d\u7269\u8f66\u7ed3\u7b97\u9875\u9762")
    @ApiOperationSupport(order=5)
    public ApiResult<BipCartVo> perPay(@RequestBody BipCartSettleParmVO bipCartSettleParmVO, @PathVariable Long ouId) {
        bipCartSettleParmVO.setOuId(ouId);
        BipCartVo bipCartVo = this.bipCartService.findMyCartEable(bipCartSettleParmVO);
        return ApiResult.ok((Object)bipCartVo);
    }

    @PostMapping(value={"/buyNow/per/pay"})
    @ApiOperation(value="\u7acb\u5373\u8d2d\u4e70\u7ed3\u7b97\u9875\u9762")
    @ApiOperationSupport(order=6)
    public ApiResult<BipCartVo> buyNowPer(@RequestBody BipBuyNowSettleParmVO bipBuyNowSettleParmVO) {
        BipCartVo bipCartVo = this.bipCartService.findBuyNowOrderPer(bipBuyNowSettleParmVO);
        return ApiResult.ok((Object)bipCartVo);
    }

    @PostMapping(value={"/per/pay/farefee"})
    @ApiOperation(value="\u7ed3\u7b97\u9875\u9762\u83b7\u53d6\u8fd0\u8d39\u4fe1\u606f")
    @ApiOperationSupport(order=7)
    public ApiResult<HashMap> buyNowPer(@RequestBody BipFareAmtQueryParmVO bipFareAmtQueryParmVO) {
        HashMap hashMap = this.bipCartService.findFeeFare(bipFareAmtQueryParmVO);
        return ApiResult.ok((Object)hashMap);
    }

    @PostMapping(value={"/getAttrList"})
    @ApiOperation(value="SKU\u5339\u914d")
    @ApiOperationSupport(order=7)
    public ApiResult<List<AttrAPPRespVO>> getAttrList(@RequestBody AttrAppParamVO attrAppParamVO) {
        List list = this.bipCartService.getAttrList(attrAppParamVO);
        return ApiResult.ok((Object)list);
    }
}

