/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.event.listener;

import com.alibaba.fastjson.JSON;
import com.elitesland.yst.production.sale.api.dto.BipCartDTO;
import com.elitesland.yst.production.sale.api.dto.CustDTO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipMessageSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.shop.BipMessageConvert;
import com.elitesland.yst.production.sale.entity.BipItemSkuDO;
import com.elitesland.yst.production.sale.entity.BipMessageDO;
import com.elitesland.yst.production.sale.event.ItemPriceReduceEvent;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipCartRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipMessageRepo;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ItemPriceReduceListener
implements ApplicationListener<ItemPriceReduceEvent> {
    private static final Logger log = LoggerFactory.getLogger(ItemPriceReduceListener.class);
    @Autowired
    private BipCartRepoProc bipCartRepoProc;
    @Autowired
    private BipMessageRepo bipMessageRepo;
    @Autowired
    private BipItemSkuRepoProc bipItemSkuRepoProc;
    @Autowired
    private BipCustUserBindRepoProc bipCustUserBindRepoProc;
    @Autowired
    private CrmCustRepoProc crmCustRepoProc;

    public void onApplicationEvent(ItemPriceReduceEvent event) {
        log.info("\u76d1\u542c\u5230\u964d\u4ef7\u4e8b\u4ef6\uff1a{}, {}, {}, {}", new Object[]{event.getItemCode(), event.getPriceType(), event.getPrice(), event.getCustLevel()});
        CompletableFuture.runAsync(() -> this.noticeForShoppingCar(event)).exceptionally(e -> {
            log.error("\u5546\u54c1\u964d\u4ef7\u901a\u77e5\u8d2d\u7269\u8f66\u7684\u7528\u6237\u6d88\u606f\u5931\u8d25\u3010" + event.getItemCode() + "\u3011", e);
            return null;
        });
    }

    private void noticeForShoppingCar(ItemPriceReduceEvent event) {
        List<BipItemSkuDO> skuDOS = this.bipItemSkuRepoProc.findSkuByCode(event.getItemCode());
        log.info("\u5546\u54c1\u964d\u4ef7SKU\uff1a" + JSON.toJSONString(skuDOS));
        if (skuDOS == null || skuDOS.size() == 0) {
            return;
        }
        BipItemSkuDO skuDO = skuDOS.get(0);
        List<BipCartDTO> carts = this.bipCartRepoProc.searchCartByCode(skuDO.getId(), event.getPriceType());
        log.info("\u5546\u54c1\u964d\u4ef7\u6d88\u606f event:" + JSON.toJSONString((Object)((Object)event)));
        log.info("\u5546\u54c1\u964d\u4ef7\u6d88\u606f carts:" + JSON.toJSONString(carts));
        log.info("\u5546\u54c1\u964d\u4ef7\u6d88\u606f sku:" + JSON.toJSONString((Object)skuDO));
        for (BipCartDTO cart : carts) {
            Long custId = this.bipCustUserBindRepoProc.getCustIdByUserId(cart.getUserId());
            CustDTO custDTO = this.crmCustRepoProc.getCustSimpleInfo(custId);
            if (UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode().equals(event.getPriceType()) && !event.getCustLevel().equals(custDTO.getCustLevel())) continue;
            String itemName = skuDO.getItemName();
            BipMessageSaveVO param = new BipMessageSaveVO();
            param.setTitle("\u3010\u5546\u54c1\u964d\u4ef7\u3011");
            param.setStatus(UdcEnum.MESSAGE_STATUS_NOTREAD.getValueCode());
            param.setToCustId(cart.getUserId());
            param.setContext("\u60a8\u6dfb\u52a0\u5230\u8d2d\u7269\u8f66\u7684\u5546\u54c1" + itemName + "\u964d\u4ef7\u4e86\uff01");
            BipMessageDO bipMessageDO = BipMessageConvert.INSTANCE.voToDo(param);
            this.bipMessageRepo.save(bipMessageDO);
        }
    }
}

