/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsStoreRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsStoreSumRespVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.QSaleStatisticsStoreDO;
import com.elitesland.yst.production.sale.entity.QSaleStatisticsStoreDtlDO;
import com.elitesland.yst.production.sale.entity.SaleStatisticsStoreDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SaleStatisticsStoreRepoProc
extends BaseRepoProc<SaleStatisticsStoreDO> {
    private static final QSaleStatisticsStoreDO QDO = QSaleStatisticsStoreDO.saleStatisticsStoreDO;
    private static final QSaleStatisticsStoreDtlDO DTL_DO = QSaleStatisticsStoreDtlDO.saleStatisticsStoreDtlDO;
    private final String SHIP_TOTAL_QTY = "shipTotalQty";
    private final String STORE_TOTAL_QTY = "storeTotalQty";

    protected SaleStatisticsStoreRepoProc() {
        super((EntityPathBase)QDO);
    }

    public PagingVO<SaleStatisticsStoreRespVO> pcPage(SaleStatisticsStoreQueryVO saleStatisticsStorePageParam) {
        JPAQuery query = (JPAQuery)((JPAQuery)this.selectTwo(SaleStatisticsStoreRespVO.class).where(ExpressionUtils.allOf(this.bulidPredicatePc(saleStatisticsStorePageParam)))).groupBy(new Expression[]{SaleStatisticsStoreRepoProc.QDO.region, SaleStatisticsStoreRepoProc.QDO.storeCode, SaleStatisticsStoreRepoProc.QDO.dealerCode, SaleStatisticsStoreRepoProc.QDO.salesmanPath, SaleStatisticsStoreRepoProc.QDO.vehicleType, SaleStatisticsStoreRepoProc.QDO.docTime});
        if (!Objects.isNull(saleStatisticsStorePageParam.getShipTotalQtyFrom())) {
            query.having((Predicate)SaleStatisticsStoreRepoProc.QDO.shipQty.sum().goe((Number)saleStatisticsStorePageParam.getShipTotalQtyFrom()));
        }
        if (!Objects.isNull(saleStatisticsStorePageParam.getShipTotalQtyTo())) {
            query.having((Predicate)SaleStatisticsStoreRepoProc.QDO.shipQty.sum().loe((Number)saleStatisticsStorePageParam.getShipTotalQtyTo()));
        }
        saleStatisticsStorePageParam.setPaging(query);
        if (CollectionUtils.isNotEmpty((Collection)saleStatisticsStorePageParam.getOrders())) {
            for (OrderItem orderItem : saleStatisticsStorePageParam.getOrders()) {
                if (!StringUtils.isNotBlank((CharSequence)orderItem.getColumn())) continue;
                Order order = orderItem.isAsc() ? Order.ASC : Order.DESC;
                OrderSpecifier orderSpecifier3 = new OrderSpecifier(order, (Expression)Expressions.stringTemplate((String)orderItem.getColumn(), (Object[])new Object[0]));
                query.orderBy(orderSpecifier3);
            }
        }
        query.orderBy(SaleStatisticsStoreRepoProc.QDO.docTime.desc());
        query.orderBy(SaleStatisticsStoreRepoProc.QDO.createTime.desc());
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public PagingVO<SaleStatisticsStoreRespVO> appPage(SaleStatisticsStoreQueryVO saleStatisticsStorePageParam) {
        JPAQuery query = (JPAQuery)((JPAQuery)this.selectTwo(SaleStatisticsStoreRespVO.class).where(ExpressionUtils.allOf(this.bulidPredicatePc(saleStatisticsStorePageParam)))).groupBy(new Expression[]{SaleStatisticsStoreRepoProc.QDO.region, SaleStatisticsStoreRepoProc.QDO.storeCode, SaleStatisticsStoreRepoProc.QDO.dealerCode, SaleStatisticsStoreRepoProc.QDO.salesmanPath, SaleStatisticsStoreRepoProc.QDO.docTime});
        if (!Objects.isNull(saleStatisticsStorePageParam.getShipTotalQtyFrom())) {
            query.having((Predicate)SaleStatisticsStoreRepoProc.QDO.shipQty.sum().goe((Number)saleStatisticsStorePageParam.getShipTotalQtyFrom()));
        }
        if (!Objects.isNull(saleStatisticsStorePageParam.getShipTotalQtyTo())) {
            query.having((Predicate)SaleStatisticsStoreRepoProc.QDO.shipQty.sum().loe((Number)saleStatisticsStorePageParam.getShipTotalQtyTo()));
        }
        saleStatisticsStorePageParam.setPaging(query);
        if (CollectionUtils.isNotEmpty((Collection)saleStatisticsStorePageParam.getOrders())) {
            for (OrderItem orderItem : saleStatisticsStorePageParam.getOrders()) {
                if (!StringUtils.isNotBlank((CharSequence)orderItem.getColumn())) continue;
                Order order = orderItem.isAsc() ? Order.ASC : Order.DESC;
                OrderSpecifier orderSpecifier3 = new OrderSpecifier(order, (Expression)Expressions.stringTemplate((String)orderItem.getColumn(), (Object[])new Object[0]));
                query.orderBy(orderSpecifier3);
            }
        }
        query.orderBy(SaleStatisticsStoreRepoProc.QDO.docTime.desc());
        query.orderBy(SaleStatisticsStoreRepoProc.QDO.createTime.desc());
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public List<SaleStatisticsStoreRespVO> query(SaleStatisticsStoreQueryVO saleStatisticsStorePageParam) {
        JPAQuery query = (JPAQuery)((JPAQuery)this.selectTwo(SaleStatisticsStoreRespVO.class).where(ExpressionUtils.allOf(this.detailBulidPredicate(saleStatisticsStorePageParam)))).groupBy(new Expression[]{SaleStatisticsStoreRepoProc.QDO.itemType3, SaleStatisticsStoreRepoProc.QDO.vehicleType, SaleStatisticsStoreRepoProc.QDO.docTime});
        if (!Objects.isNull(saleStatisticsStorePageParam.getShipTotalQtyFrom())) {
            query.having((Predicate)SaleStatisticsStoreRepoProc.QDO.shipQty.sum().goe((Number)saleStatisticsStorePageParam.getShipTotalQtyFrom()));
        }
        if (!Objects.isNull(saleStatisticsStorePageParam.getShipTotalQtyTo())) {
            query.having((Predicate)SaleStatisticsStoreRepoProc.QDO.shipQty.sum().loe((Number)saleStatisticsStorePageParam.getShipTotalQtyTo()));
        }
        return query.fetch();
    }

    public StatisticsStoreSumRespVO pageSum(SaleStatisticsStoreQueryVO saleStatisticsStorePageParam) {
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(StatisticsStoreSumRespVO.class, (Expression[])new Expression[]{SaleStatisticsStoreRepoProc.QDO.storeCode.countDistinct().as("storeTotalQty"), SaleStatisticsStoreRepoProc.QDO.shipQty.sum().as("shipTotalQty")})).from((EntityPath)QDO)).where(ExpressionUtils.allOf(this.bulidPredicate(saleStatisticsStorePageParam)));
        return (StatisticsStoreSumRespVO)query.fetchFirst();
    }

    public Long del(List<Long> ids) {
        Long res = this.jpaQueryFactory.update((EntityPath)QDO).set(SaleStatisticsStoreRepoProc.QDO.deleteFlag, (Object)1).where(new Predicate[]{SaleStatisticsStoreRepoProc.QDO.id.in(ids)}).execute();
        return res;
    }

    public SaleStatisticsStoreRespVO get(Long id) {
        SaleStatisticsStoreRespVO saleStatisticsStoreVO = (SaleStatisticsStoreRespVO)((JPAQuery)this.select(SaleStatisticsStoreRespVO.class).where((Predicate)SaleStatisticsStoreRepoProc.QDO.id.eq((Object)id))).fetchOne();
        return saleStatisticsStoreVO;
    }

    public List<SaleStatisticsStoreRespVO> getList(SaleStatisticsStoreQueryVO saleStatisticsStorePageParam) {
        List res = ((JPAQuery)this.select(SaleStatisticsStoreRespVO.class).where(ExpressionUtils.allOf(this.bulidPredicate(saleStatisticsStorePageParam)))).fetch();
        return res;
    }

    public List<SaleStatisticsStoreRespVO> getByCustCode(SaleStatisticsStoreQueryVO saleStatisticsStorePageParam) {
        List res = ((JPAQuery)this.select(SaleStatisticsStoreRespVO.class).where(ExpressionUtils.allOf(this.bulidPredicate(saleStatisticsStorePageParam)))).fetch();
        return res;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{SaleStatisticsStoreRepoProc.QDO.docTime, SaleStatisticsStoreRepoProc.QDO.storeCode, SaleStatisticsStoreRepoProc.QDO.storeName, SaleStatisticsStoreRepoProc.QDO.empCode, SaleStatisticsStoreRepoProc.QDO.empName, SaleStatisticsStoreRepoProc.QDO.userId2, SaleStatisticsStoreRepoProc.QDO.storeName, SaleStatisticsStoreRepoProc.QDO.dealerCode, SaleStatisticsStoreRepoProc.QDO.dealerName, SaleStatisticsStoreRepoProc.QDO.dealerSerialNo, SaleStatisticsStoreRepoProc.QDO.storeType2, SaleStatisticsStoreRepoProc.QDO.region, SaleStatisticsStoreRepoProc.QDO.type, SaleStatisticsStoreRepoProc.QDO.salesmanPath, SaleStatisticsStoreRepoProc.QDO.vehicleType, SaleStatisticsStoreRepoProc.QDO.itemType3, SaleStatisticsStoreRepoProc.QDO.shipQty, SaleStatisticsStoreRepoProc.QDO.id, SaleStatisticsStoreRepoProc.QDO.detailAddr, SaleStatisticsStoreRepoProc.QDO.createTime, SaleStatisticsStoreRepoProc.QDO.remark, SaleStatisticsStoreRepoProc.QDO.updateRegionFailureReason, SaleStatisticsStoreRepoProc.QDO.updateSalesmanFailureReason})).from((EntityPath)QDO);
    }

    private <T> JPAQuery<T> selectTwo(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{SaleStatisticsStoreRepoProc.QDO.docTime, SaleStatisticsStoreRepoProc.QDO.storeCode, SaleStatisticsStoreRepoProc.QDO.storeName, SaleStatisticsStoreRepoProc.QDO.empCode, SaleStatisticsStoreRepoProc.QDO.empName, SaleStatisticsStoreRepoProc.QDO.userId2, SaleStatisticsStoreRepoProc.QDO.dealerCode, SaleStatisticsStoreRepoProc.QDO.storeType2, SaleStatisticsStoreRepoProc.QDO.dealerName, SaleStatisticsStoreRepoProc.QDO.dealerSerialNo, SaleStatisticsStoreRepoProc.QDO.region, SaleStatisticsStoreRepoProc.QDO.type, SaleStatisticsStoreRepoProc.QDO.salesmanPath, SaleStatisticsStoreRepoProc.QDO.vehicleType, SaleStatisticsStoreRepoProc.QDO.itemType3, SaleStatisticsStoreRepoProc.QDO.shipQty.sum().as("shipTotalQty"), SaleStatisticsStoreRepoProc.QDO.id, SaleStatisticsStoreRepoProc.QDO.createTime, SaleStatisticsStoreRepoProc.QDO.detailAddr, SaleStatisticsStoreRepoProc.QDO.remark, SaleStatisticsStoreRepoProc.QDO.updateRegionFailureReason, SaleStatisticsStoreRepoProc.QDO.updateSalesmanFailureReason})).from((EntityPath)QDO);
    }

    private List<Predicate> bulidPredicate(SaleStatisticsStoreQueryVO param) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andGoe(null != param.getDocTimeStart(), SaleStatisticsStoreRepoProc.QDO.docTime, (Comparable)LocalDateTime.of((param.getDocTimeStart() == null ? LocalDateTime.now() : param.getDocTimeStart()).toLocalDate(), LocalTime.MIN)).andLoe(null != param.getDocTimeEnd(), SaleStatisticsStoreRepoProc.QDO.docTime, (Comparable)LocalDateTime.of((param.getDocTimeEnd() == null ? LocalDateTime.now() : param.getDocTimeEnd()).toLocalDate(), ConstantsSale.LOCAL_TIME_MAX)).andLike(StringUtils.isNotBlank((CharSequence)param.getStoreCode()), (StringExpression)SaleStatisticsStoreRepoProc.QDO.storeCode, param.getStoreCode()).andLike(StringUtils.isNotBlank((CharSequence)param.getStoreName()), (StringExpression)SaleStatisticsStoreRepoProc.QDO.storeName, param.getStoreName()).andEq(StringUtils.isNotBlank((CharSequence)param.getDealerCode()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.dealerCode, (Object)param.getDealerCode()).andEq(StringUtils.isNotBlank((CharSequence)param.getDealerName()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.dealerName, (Object)param.getDealerName()).andEq(StringUtils.isNotBlank((CharSequence)param.getEmpName()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.empName, (Object)param.getEmpName()).andEq(StringUtils.isNotBlank((CharSequence)param.getEmpCode()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.empCode, (Object)param.getEmpCode()).andEq(StringUtils.isNotBlank((CharSequence)param.getDealerSerialNo()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.dealerSerialNo, (Object)param.getDealerSerialNo()).andEq(StringUtils.isNotBlank((CharSequence)param.getType()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.type, (Object)param.getType()).andEq(StringUtils.isNotBlank((CharSequence)param.getVehicleType()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.vehicleType, (Object)param.getVehicleType()).andEq(StringUtils.isNotBlank((CharSequence)param.getItemType3()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.itemType3, (Object)param.getItemType3()).andEq(StringUtils.isNotBlank((CharSequence)param.getStoreType2()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.storeType2, (Object)param.getStoreType2()).andLike(StringUtils.isNotBlank((CharSequence)param.getDetailAddr()), (StringExpression)SaleStatisticsStoreRepoProc.QDO.detailAddr, param.getDetailAddr()).andEq(null != param.getShipQty(), SaleStatisticsStoreRepoProc.QDO.shipQty, (Object)param.getShipQty()).andEq(StringUtils.isNotBlank((CharSequence)param.getRegion()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.region, (Object)param.getRegion()).andIn(!CollectionUtils.isEmpty((Collection)param.getIds()), SaleStatisticsStoreRepoProc.QDO.id, (Collection)param.getIds()).andIn(!CollectionUtils.isEmpty((Collection)param.getDealerCodeList()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.dealerCode, (Collection)param.getDealerCodeList()).build();
        predicates.add(predicate);
        if (!StringUtils.isEmpty((CharSequence)param.getDealerKeyword())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.dealerCode.like("%" + param.getDealerKeyword() + "%").or((Predicate)SaleStatisticsStoreRepoProc.QDO.dealerName.like("%" + param.getDealerKeyword() + "%")));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getKeyword())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.storeCode.like("%" + param.getKeyword() + "%").or((Predicate)SaleStatisticsStoreRepoProc.QDO.storeName.like("%" + param.getKeyword() + "%")));
        }
        if (Objects.nonNull(param.getDocMonth())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%Y-%m')", (Object[])new Object[]{SaleStatisticsStoreRepoProc.QDO.docTime}).eq((Object)param.getDocMonth());
            predicates.add((Predicate)booleanTemplate);
        }
        if (Objects.equals(param.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_YES.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.region.isNull());
        }
        if (Objects.equals(param.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_NO.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.region.isNotNull());
        }
        if (Objects.equals(param.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_YES.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.salesmanPath.isNull());
        }
        if (Objects.equals(param.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_NO.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.salesmanPath.isNotNull());
        }
        return predicates;
    }

    private List<Predicate> bulidPredicatePc(SaleStatisticsStoreQueryVO param) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andGoe(null != param.getDocTimeStart(), SaleStatisticsStoreRepoProc.QDO.docTime, (Comparable)LocalDateTime.of((param.getDocTimeStart() == null ? LocalDateTime.now() : param.getDocTimeStart()).toLocalDate(), LocalTime.MIN)).andLoe(null != param.getDocTimeEnd(), SaleStatisticsStoreRepoProc.QDO.docTime, (Comparable)LocalDateTime.of((param.getDocTimeEnd() == null ? LocalDateTime.now() : param.getDocTimeEnd()).toLocalDate(), ConstantsSale.LOCAL_TIME_MAX)).andLike(StringUtils.isNotBlank((CharSequence)param.getStoreCode()), (StringExpression)SaleStatisticsStoreRepoProc.QDO.storeCode, param.getStoreCode()).andLike(StringUtils.isNotBlank((CharSequence)param.getStoreName()), (StringExpression)SaleStatisticsStoreRepoProc.QDO.storeName, param.getStoreName()).andEq(StringUtils.isNotBlank((CharSequence)param.getDealerCode()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.dealerCode, (Object)param.getDealerCode()).andEq(StringUtils.isNotBlank((CharSequence)param.getDealerName()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.dealerName, (Object)param.getDealerName()).andEq(StringUtils.isNotBlank((CharSequence)param.getEmpName()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.empName, (Object)param.getEmpName()).andEq(StringUtils.isNotBlank((CharSequence)param.getEmpCode()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.empCode, (Object)param.getEmpCode()).andEq(StringUtils.isNotBlank((CharSequence)param.getDealerSerialNo()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.dealerSerialNo, (Object)param.getDealerSerialNo()).andEq(StringUtils.isNotBlank((CharSequence)param.getType()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.type, (Object)param.getType()).andEq(StringUtils.isNotBlank((CharSequence)param.getVehicleType()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.vehicleType, (Object)param.getVehicleType()).andEq(StringUtils.isNotBlank((CharSequence)param.getItemType3()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.itemType3, (Object)param.getItemType3()).andEq(StringUtils.isNotBlank((CharSequence)param.getStoreType2()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.storeType2, (Object)param.getStoreType2()).andLike(StringUtils.isNotBlank((CharSequence)param.getDetailAddr()), (StringExpression)SaleStatisticsStoreRepoProc.QDO.detailAddr, param.getDetailAddr()).andEq(null != param.getShipQty(), SaleStatisticsStoreRepoProc.QDO.shipQty, (Object)param.getShipQty()).andEq(StringUtils.isNotBlank((CharSequence)param.getRegion()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.region, (Object)param.getRegion()).andIn(!CollectionUtils.isEmpty((Collection)param.getIds()), SaleStatisticsStoreRepoProc.QDO.id, (Collection)param.getIds()).andIn(!CollectionUtils.isEmpty((Collection)param.getDealerCodeList()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.dealerCode, (Collection)param.getDealerCodeList()).build();
        predicates.add(predicate);
        if (!StringUtils.isEmpty((CharSequence)param.getDealerKeyword())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.dealerCode.like("%" + param.getDealerKeyword() + "%").or((Predicate)SaleStatisticsStoreRepoProc.QDO.dealerName.like("%" + param.getDealerKeyword() + "%")));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getKeyword())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.storeCode.like("%" + param.getKeyword() + "%").or((Predicate)SaleStatisticsStoreRepoProc.QDO.storeName.like("%" + param.getKeyword() + "%")));
        }
        if (Objects.nonNull(param.getDocMonth())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%Y-%m')", (Object[])new Object[]{SaleStatisticsStoreRepoProc.QDO.docTime}).eq((Object)param.getDocMonth());
            predicates.add((Predicate)booleanTemplate);
        }
        if (Objects.equals(param.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_YES.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.region.isNull());
        }
        if (Objects.equals(param.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_NO.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.region.isNotNull());
        }
        if (Objects.equals(param.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_YES.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.salesmanPath.isNull());
        }
        if (Objects.equals(param.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_NO.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.salesmanPath.isNotNull());
        }
        if (!Objects.isNull(param.getAgentEmp())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.id.in((SubQueryExpression)JPAExpressions.select(SaleStatisticsStoreRepoProc.DTL_DO.masId).from(new EntityPath[]{DTL_DO}).where(new Predicate[]{SaleStatisticsStoreRepoProc.DTL_DO.deleteFlag.eq((Object)0).and((Predicate)SaleStatisticsStoreRepoProc.DTL_DO.code.eq((Object)param.getAgentEmp()))})));
        }
        return predicates;
    }

    private List<Predicate> detailBulidPredicate(SaleStatisticsStoreQueryVO param) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andGoe(null != param.getDocTimeStart(), SaleStatisticsStoreRepoProc.QDO.docTime, (Comparable)LocalDateTime.of(param.getDocTimeStart().toLocalDate(), LocalTime.MIN)).andLoe(null != param.getDocTimeEnd(), SaleStatisticsStoreRepoProc.QDO.docTime, (Comparable)LocalDateTime.of(param.getDocTimeEnd().toLocalDate(), ConstantsSale.LOCAL_TIME_MAX)).andLike(StringUtils.isNotBlank((CharSequence)param.getStoreCode()), (StringExpression)SaleStatisticsStoreRepoProc.QDO.storeCode, param.getStoreCode()).andLike(StringUtils.isNotBlank((CharSequence)param.getStoreName()), (StringExpression)SaleStatisticsStoreRepoProc.QDO.storeName, param.getStoreName()).andEq(StringUtils.isNotBlank((CharSequence)param.getDealerCode()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.dealerCode, (Object)param.getDealerCode()).andEq(StringUtils.isNotBlank((CharSequence)param.getDealerName()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.dealerName, (Object)param.getDealerName()).andEq(StringUtils.isNotBlank((CharSequence)param.getEmpName()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.empName, (Object)param.getEmpName()).andEq(StringUtils.isNotBlank((CharSequence)param.getEmpCode()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.empCode, (Object)param.getEmpCode()).andEq(StringUtils.isNotBlank((CharSequence)param.getDealerSerialNo()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.dealerSerialNo, (Object)param.getDealerSerialNo()).andEq(StringUtils.isNotBlank((CharSequence)param.getType()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.type, (Object)param.getType()).andEq(StringUtils.isNotBlank((CharSequence)param.getVehicleType()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.vehicleType, (Object)param.getVehicleType()).andEq(StringUtils.isNotBlank((CharSequence)param.getItemType3()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.itemType3, (Object)param.getItemType3()).andEq(StringUtils.isNotBlank((CharSequence)param.getStoreType2()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.storeType2, (Object)param.getStoreType2()).andLike(StringUtils.isNotBlank((CharSequence)param.getDetailAddr()), (StringExpression)SaleStatisticsStoreRepoProc.QDO.detailAddr, param.getDetailAddr()).andEq(null != param.getShipQty(), SaleStatisticsStoreRepoProc.QDO.shipQty, (Object)param.getShipQty()).andEq(StringUtils.isNotBlank((CharSequence)param.getRegion()), (SimpleExpression)SaleStatisticsStoreRepoProc.QDO.region, (Object)param.getRegion()).andIn(!CollectionUtils.isEmpty((Collection)param.getIds()), SaleStatisticsStoreRepoProc.QDO.id, (Collection)param.getIds()).build();
        predicates.add(predicate);
        if (!StringUtils.isEmpty((CharSequence)param.getDealerKeyword())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.dealerCode.like("%" + param.getDealerKeyword() + "%").or((Predicate)SaleStatisticsStoreRepoProc.QDO.dealerName.like("%" + param.getDealerKeyword() + "%")));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getKeyword())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.storeCode.like("%" + param.getKeyword() + "%").or((Predicate)SaleStatisticsStoreRepoProc.QDO.storeName.like("%" + param.getKeyword() + "%")));
        }
        if (StringUtils.isEmpty((CharSequence)param.getAgentEmp())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.salesmanPath.isNull());
        }
        if (StringUtils.isEmpty((CharSequence)param.getRegion())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.region.isNull());
        } else {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.region.eq((Object)param.getRegion()));
        }
        if (Objects.nonNull(param.getDocMonth())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%Y-%m')", (Object[])new Object[]{SaleStatisticsStoreRepoProc.QDO.docTime}).eq((Object)param.getDocMonth());
            predicates.add((Predicate)booleanTemplate);
        }
        if (Objects.equals(param.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_YES.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.region.isNull());
        }
        if (Objects.equals(param.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_NO.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.region.isNotNull());
        }
        if (Objects.equals(param.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_YES.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.salesmanPath.isNull());
        }
        if (Objects.equals(param.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_NO.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.salesmanPath.isNotNull());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getAgentEmp())) {
            predicates.add((Predicate)SaleStatisticsStoreRepoProc.QDO.id.in((SubQueryExpression)JPAExpressions.select(SaleStatisticsStoreRepoProc.DTL_DO.masId).from(new EntityPath[]{DTL_DO}).where(new Predicate[]{SaleStatisticsStoreRepoProc.DTL_DO.code.eq((Object)param.getAgentEmp())})));
        }
        return predicates;
    }

    public List<SaleStatisticsStoreRespVO> storeQuery(SaleStatisticsStoreQueryVO paramVO) {
        JPAQuery query = (JPAQuery)((JPAQuery)this.selectTwo(SaleStatisticsStoreRespVO.class).where(ExpressionUtils.allOf(this.bulidPredicate(paramVO)))).groupBy(new Expression[]{SaleStatisticsStoreRepoProc.QDO.region, SaleStatisticsStoreRepoProc.QDO.storeCode, SaleStatisticsStoreRepoProc.QDO.dealerCode, SaleStatisticsStoreRepoProc.QDO.salesmanPath, SaleStatisticsStoreRepoProc.QDO.vehicleType, SaleStatisticsStoreRepoProc.QDO.docTime});
        if (!Objects.isNull(paramVO.getShipTotalQtyFrom())) {
            query.having((Predicate)SaleStatisticsStoreRepoProc.QDO.shipQty.sum().goe((Number)paramVO.getShipTotalQtyFrom()));
        }
        if (!Objects.isNull(paramVO.getShipTotalQtyTo())) {
            query.having((Predicate)SaleStatisticsStoreRepoProc.QDO.shipQty.sum().loe((Number)paramVO.getShipTotalQtyTo()));
        }
        return query.fetch();
    }

    public Predicate querySumDetailWhere(SaleStatisticsStoreQueryVO param) {
        BooleanExpression predicate = Expressions.ONE.eq((Expression)Expressions.ONE);
        if (!StringUtils.isEmpty((CharSequence)param.getDealerCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SaleStatisticsStoreRepoProc.QDO.dealerCode.eq((Object)param.getDealerCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getStoreCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SaleStatisticsStoreRepoProc.QDO.storeCode.eq((Object)param.getStoreCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getSalesmanPath())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SaleStatisticsStoreRepoProc.QDO.salesmanPath.eq((Object)param.getSalesmanPath()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getRegion())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SaleStatisticsStoreRepoProc.QDO.region.eq((Object)param.getRegion()));
        }
        if (Objects.nonNull(param.getDocTime())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SaleStatisticsStoreRepoProc.QDO.docTime.eq((Object)param.getDocTime()));
        }
        if (Objects.nonNull(param.getDocMonth())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%Y-%m')", (Object[])new Object[]{SaleStatisticsStoreRepoProc.QDO.docTime}).eq((Object)param.getDocMonth());
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)booleanTemplate);
        }
        return predicate;
    }

    public List<Long> findIdsByCustCode(String custCode, Long minId, int limit) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(SaleStatisticsStoreRepoProc.QDO.id).from((EntityPath)QDO)).where((Predicate)SaleStatisticsStoreRepoProc.QDO.dealerCode.eq((Object)custCode))).orderBy(SaleStatisticsStoreRepoProc.QDO.id.asc())).limit((long)limit);
        if (minId != null) {
            jpaQuery.where((Predicate)SaleStatisticsStoreRepoProc.QDO.id.gt((Number)minId));
        }
        return jpaQuery.fetch();
    }
}

