/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.rmi.ystsystem;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeePageQueryDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RmiEmployeeRpcService {
    private static final Logger log = LoggerFactory.getLogger(RmiEmployeeRpcService.class);
    @Autowired
    private EmployeeRpcService employeeRpcService;

    public SysEmployeeBasicDTO findEmployeeById(Long id) {
        log.info("\u8c03\u7528system\u57df:\u6839\u636e\u5458\u5de5ID\u83b7\u53d6\u5458\u5de5\u4fe1\u606f,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)id);
        try {
            if (Objects.isNull(id)) {
                return null;
            }
            ApiResult apiResult = this.employeeRpcService.getById(id);
            log.info("\u8c03\u7528system\u57df:\u6839\u636e\u5458\u5de5ID\u83b7\u53d6\u5458\u5de5\u4fe1\u606f,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)apiResult);
            if (apiResult.isSuccess()) {
                return (SysEmployeeBasicDTO)apiResult.getData();
            }
            throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528system\u57df:\u6839\u636e\u5458\u5de5ID\u83b7\u53d6\u5458\u5de5\u4fe1\u606f,error\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("\u8c03\u7528system\u57df:" + e.getMessage());
        }
    }

    public List<SysEmployeeBasicDTO> findEmployeeByIds(Set<Long> ids) {
        log.info("\u8c03\u7528system\u57df:\u6839\u636e\u5458\u5de5ID\u6279\u91cf\u83b7\u53d6\u5458\u5de5\u4fe1\u606f,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), ids);
        try {
            if (CollectionUtils.isEmpty(ids)) {
                return Collections.emptyList();
            }
            EmployeeQueryDTO queryDTO = new EmployeeQueryDTO();
            queryDTO.setIds(ids);
            ApiResult apiResult = this.employeeRpcService.queryList(queryDTO);
            log.info("\u8c03\u7528system\u57df:\u6839\u636e\u5458\u5de5ID\u6279\u91cf\u83b7\u53d6\u5458\u5de5\u4fe1\u606f,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)apiResult);
            if (apiResult.isSuccess()) {
                return (List)apiResult.getData();
            }
            throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528system\u57df:\u6839\u636e\u5458\u5de5ID\u6279\u91cf\u83b7\u53d6\u5458\u5de5\u4fe1\u606f,error\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("\u8c03\u7528system\u57df:" + e.getMessage());
        }
    }

    public SysEmployeeBasicDTO findEmployeeByCode(String code) {
        log.info("\u8c03\u7528system\u57df:\u6839\u636e\u5458\u5de5\u7f16\u7801\u83b7\u53d6\u5458\u5de5\u4fe1\u606f,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)code);
        try {
            if (StringUtils.isBlank((CharSequence)code)) {
                return null;
            }
            ApiResult apiResult = this.employeeRpcService.getByCode(code);
            log.info("\u8c03\u7528system\u57df:\u6839\u636e\u5458\u5de5\u7f16\u7801\u83b7\u53d6\u5458\u5de5\u4fe1\u606f,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)apiResult);
            if (apiResult.isSuccess()) {
                return (SysEmployeeBasicDTO)apiResult.getData();
            }
            throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528system\u57df:\u6839\u636e\u5458\u5de5\u7f16\u7801\u83b7\u53d6\u5458\u5de5\u4fe1\u606f,error\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("\u8c03\u7528system\u57df:" + e.getMessage());
        }
    }

    public List<SysEmployeeBasicDTO> findEmployeeByCodes(Set<String> codes) {
        log.info("\u8c03\u7528system\u57df:\u6839\u636e\u5458\u5de5\u7f16\u7801\u6279\u91cf\u83b7\u53d6\u5458\u5de5\u4fe1\u606f,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), codes);
        try {
            if (CollectionUtils.isEmpty(codes)) {
                return Collections.emptyList();
            }
            EmployeeQueryDTO queryDTO = new EmployeeQueryDTO();
            queryDTO.setCodes(codes);
            ApiResult apiResult = this.employeeRpcService.queryList(queryDTO);
            log.info("\u8c03\u7528system\u57df:\u6839\u636e\u5458\u5de5\u7f16\u7801\u6279\u91cf\u83b7\u53d6\u5458\u5de5\u4fe1\u606f,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)apiResult);
            if (apiResult.isSuccess()) {
                return (List)apiResult.getData();
            }
            throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528system\u57df:\u6839\u636e\u5458\u5de5\u7f16\u7801\u6279\u91cf\u83b7\u53d6\u5458\u5de5\u4fe1\u606f,error\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("\u8c03\u7528system\u57df:" + e.getMessage());
        }
    }

    public SysEmployeeBasicDTO findEmployeeByUserId(Long userId) {
        log.info("\u8c03\u7528system\u57df:\u6839\u636e\u7528\u6237ID\u83b7\u53d6\u6240\u5c5e\u5458\u5de5,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)userId);
        try {
            if (Objects.isNull(userId)) {
                return null;
            }
            ApiResult apiResult = this.employeeRpcService.getByUserId(userId);
            log.info("\u8c03\u7528system\u57df:\u6839\u636e\u7528\u6237ID\u83b7\u53d6\u6240\u5c5e\u5458\u5de5,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)apiResult);
            if (apiResult.isSuccess()) {
                return (SysEmployeeBasicDTO)apiResult.getData();
            }
            throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528system\u57df:\u6839\u636e\u7528\u6237ID\u83b7\u53d6\u6240\u5c5e\u5458\u5de5,error\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("\u8c03\u7528system\u57df:" + e.getMessage());
        }
    }

    public List<EmployeeUnderlingDTO> getUnderlingByCode(String code, Boolean cascade, Boolean enable) {
        log.info("\u8c03\u7528system\u57df:\u6839\u636e\u5458\u5de5\u7f16\u53f7\u83b7\u53d6\u4e0b\u5c5e\u5458\u5de5,\u65f6\u95f4\uff1a{},\u5458\u5de5\u7f16\u53f7\uff1a{},\u662f\u5426\u7ea7\u8054\u83b7\u53d6\u6240\u6709\u4e0b\u5c5e\u5458\u5de5\uff1a{}", new Object[]{LocalDateTime.now(), code, cascade});
        try {
            ApiResult apiResult = this.employeeRpcService.getUnderlingByCode(code, cascade, enable);
            log.info("\u8c03\u7528system\u57df:\u6839\u636e\u5458\u5de5\u7f16\u53f7\u83b7\u53d6\u4e0b\u5c5e\u5458\u5de5,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)apiResult);
            if (apiResult.isSuccess()) {
                return (List)apiResult.getData();
            }
            throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528system\u57df:\u6839\u636e\u5458\u5de5\u7f16\u53f7\u83b7\u53d6\u4e0b\u5c5e\u5458\u5de5,error\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("\u8c03\u7528system\u57df:" + e.getMessage());
        }
    }

    public List<SysEmployeeBasicDTO> queryList(EmployeeQueryDTO queryDTO) {
        log.info("\u8c03\u7528system\u57df:\u67e5\u8be2\u5458\u5de5\u5217\u8868,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)queryDTO);
        try {
            ApiResult apiResult = this.employeeRpcService.queryList(queryDTO);
            log.info("\u8c03\u7528system\u57df:\u67e5\u8be2\u5458\u5de5\u5217\u8868,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)apiResult);
            if (apiResult.isSuccess()) {
                return (List)apiResult.getData();
            }
            throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528system\u57df:\u67e5\u8be2\u5458\u5de5\u5217\u8868,error\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("\u8c03\u7528system\u57df:" + e.getMessage());
        }
    }

    public SysEmployeeBasicDTO findEmployeeByUsername(String username) {
        log.info("\u8c03\u7528system\u57df:\u6839\u636e\u8d26\u53f7\u83b7\u53d6\u5458\u5de5\u4fe1\u606f,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)username);
        try {
            if (StringUtils.isBlank((CharSequence)username)) {
                return null;
            }
            ApiResult apiResult = this.employeeRpcService.getByUsername(username);
            log.info("\u8c03\u7528system\u57df:\u6839\u636e\u8d26\u53f7\u83b7\u53d6\u5458\u5de5\u4fe1\u606f,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)apiResult);
            if (apiResult.isSuccess()) {
                return (SysEmployeeBasicDTO)apiResult.getData();
            }
            throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528system\u57df:\u6839\u636e\u8d26\u53f7\u83b7\u53d6\u5458\u5de5\u4fe1\u606f,error\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("\u8c03\u7528system\u57df:" + e.getMessage());
        }
    }

    public List<EmployeePageRespDTO> findEmployeeByFullName(String fullName) {
        log.info("\u8c03\u7528system\u57df:\u6839\u636e\u5458\u5de5\u5168\u540d\u83b7\u53d6\u5458\u5de5\u4fe1\u606f,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)fullName);
        try {
            if (StringUtils.isBlank((CharSequence)fullName)) {
                return Collections.emptyList();
            }
            EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
            employeePageQueryDTO.setType(UdcEnum.CUST_TYPE_SALESMAN.getValueCode());
            employeePageQueryDTO.setSize(Integer.valueOf(1000));
            employeePageQueryDTO.setKeyword(fullName);
            ApiResult apiResult = this.employeeRpcService.queryByPage(employeePageQueryDTO);
            log.info("\u8c03\u7528system\u57df:\u6839\u636e\u5458\u5de5\u5168\u540d\u83b7\u53d6\u5458\u5de5\u4fe1\u606f,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)apiResult);
            if (apiResult.isSuccess()) {
                PagingVO pagingVO = (PagingVO)apiResult.getData();
                return pagingVO.getRecords();
            }
            throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528system\u57df:\u6839\u636e\u5458\u5de5\u5168\u540d\u83b7\u53d6\u5458\u5de5\u4fe1\u606f,error\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("\u8c03\u7528system\u57df:" + e.getMessage());
        }
    }
}

