/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.rmi.ystsystem;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.provider.dto.SysUserRpcDTO;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcDtoParam;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RmiSysUserService {
    private static final Logger log = LoggerFactory.getLogger(RmiSysUserService.class);
    @Autowired
    private SysUserRpcService sysUserRpcService;
    @Autowired
    private UserRpcService userRpcService;

    public Long updatePwd(Long userId, String pwd) {
        log.info("userId:---" + userId + "pwd:---" + pwd);
        try {
            ApiResult id = this.userRpcService.updatePwd(userId, pwd);
            if (id.isSuccess()) {
                return (Long)id.getData();
            }
            throw new com.elitescloud.boot.exception.BusinessException("\u4fee\u6539\u5bc6\u7801\u5931\u8d25");
        }
        catch (Exception e) {
            throw new com.elitescloud.boot.exception.BusinessException("\u4fee\u6539\u5bc6\u7801\u5931\u8d25" + e, (Throwable)e);
        }
    }

    public Long createUser(UserCreateDTO userCreateDTO) {
        log.info("\u521b\u5efa\u7528\u6237\u4fe1\u606f" + JSON.toJSONString((Object)userCreateDTO));
        if (Objects.isNull(userCreateDTO)) {
            throw new BusinessException("\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        Assert.notNull((Object)userCreateDTO.getUsername(), (String)"\u8d26\u53f7\u4e3a\u7a7a", (Object[])new Object[0]);
        try {
            ApiResult res = this.userRpcService.upsert(userCreateDTO);
            log.info("\u8fd4\u56de\u7684\u7528\u6237\u4fe1\u606f" + JSON.toJSONString((Object)res));
            if (res.isSuccess()) {
                return (Long)res.getData();
            }
            return null;
        }
        catch (Exception e) {
            throw new BusinessException("\u521b\u5efa\u7528\u6237\u4fe1\u606f\u5931\u8d25" + e, (Throwable)e);
        }
    }

    public SysUserDTO currentUser() {
        try {
            return this.sysUserRpcService.current();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new com.elitescloud.boot.exception.BusinessException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25" + e, (Throwable)e);
        }
    }

    @Deprecated
    public List<SysUserVO> getUsers(List<Long> userIds) {
        org.springframework.util.Assert.notNull(userIds, (String)"\u7528\u6237\u96c6\u5408\u4e3a\u7a7a");
        List sysUserVOS = this.sysUserRpcService.getByIds(userIds);
        if (sysUserVOS == null) {
            log.info("\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f\uff1a{}", userIds);
            return Collections.emptyList();
        }
        return sysUserVOS;
    }

    public List<SysUserRpcDTO> findUserRpcDtoByParam(SysUserRpcDtoParam param) {
        org.springframework.util.Assert.notNull((Object)param, (String)"\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u53c2\u6570\u4e3a\u7a7a");
        List users = this.sysUserRpcService.findUserRpcDtoByParam(param);
        if (CollUtil.isEmpty((Collection)users)) {
            log.info("\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)param);
            return Collections.emptyList();
        }
        return users;
    }
}

