/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitesland.yst.production.sale.api.service.CustBelongOuService;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustBelongOuVO;
import com.elitesland.yst.production.sale.convert.CustBelongOuConvert;
import com.elitesland.yst.production.sale.entity.CustBelongOuDO;
import com.elitesland.yst.production.sale.entity.QCustBelongOuDO;
import com.elitesland.yst.production.sale.repo.CustBelongOuRepo;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysOrgService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserRpcService;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustBelongOuServiceImpl
implements CustBelongOuService {
    private static final Logger log = LogManager.getLogger(CustBelongOuServiceImpl.class);
    @Autowired
    private CustBelongOuRepo custBelongOuRepo;
    @Autowired
    private RmiSysUserRpcService rmiSysUserRpcService;
    @Autowired
    private RmiOrgOuService rmiOrgOuService;
    @Autowired
    private RmiSysOrgService rmiSysOrgService;

    public List<CustBelongOuVO> getByCustCode(String custCode) {
        ArrayList<CustBelongOuVO> res = new ArrayList<CustBelongOuVO>();
        QCustBelongOuDO qCustBelongOuDO = QCustBelongOuDO.custBelongOuDO;
        BooleanExpression e = qCustBelongOuDO.custCode.eq((Object)custCode).and((Predicate)qCustBelongOuDO.deleteFlag.eq((Object)0));
        Iterable iterables = this.custBelongOuRepo.findAll((Predicate)e);
        Map<String, String> channelTypeUdc = this.rmiSysUserRpcService.sysUdcGetCodeMap("yst-supp", "CHANNEL_TYPE");
        Map<String, String> paymentTermUdc = this.rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "PAYMENT_TERM");
        Map<String, String> ouTypeInnerUdc = this.rmiSysUserRpcService.sysUdcGetCodeMap("yst-supp", "OU_TYPE_INNER");
        if (!IterableUtils.isEmpty((Iterable)iterables)) {
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            List<Long> ouIds = list.stream().map(CustBelongOuDO::getOuId).collect(Collectors.toList());
            List buIds = list.stream().map(CustBelongOuDO::getBuId).collect(Collectors.toList());
            ouIds.removeAll(Collections.singletonList(null));
            buIds.removeAll(Collections.singletonList(null));
            Map<Object, Object> ouMap = new HashMap();
            Map<Object, Object> buMap = new HashMap();
            if (!CollectionUtils.isEmpty(ouIds)) {
                List<OrgOuRpcDTO> ouInfos = this.rmiOrgOuService.findOuDtoList(ouIds, null);
                ouMap = ouInfos.stream().collect(Collectors.toMap(OrgOuRpcDTO::getId, t -> t, (t1, t2) -> t1));
            }
            if (!CollectionUtils.isEmpty(buIds)) {
                SysOrgQueryDTO sysOrgQueryDTO = new SysOrgQueryDTO();
                HashSet hashSet = new HashSet(buIds);
                sysOrgQueryDTO.setIds(hashSet);
                List<SysOrgBasicDTO> buInfos = this.rmiSysOrgService.findOrgByParam(sysOrgQueryDTO);
                buMap = buInfos.stream().collect(Collectors.toMap(SysOrgBasicDTO::getId, t -> t, (t1, t2) -> t2));
            }
            HashMap finalOuMap = ouMap;
            HashMap finalBuMap = buMap;
            list.forEach(l -> {
                CustBelongOuVO v = CustBelongOuConvert.INSTANCE.doToVo((CustBelongOuDO)((Object)l));
                if (StringUtils.isNotBlank((CharSequence)v.getStatus()) && "0".equals(v.getStatus())) {
                    v.setStatusName("\u542f\u7528");
                } else {
                    v.setStatusName("\u7981\u7528");
                }
                if (!MapUtils.isEmpty((Map)finalOuMap) && null != v.getOuId() && !ObjectUtils.isEmpty(finalOuMap.get(v.getOuId()))) {
                    OrgOuRpcDTO orgOuRpcDTO = (OrgOuRpcDTO)finalOuMap.get(v.getOuId());
                    v.setOuName(orgOuRpcDTO.getOuName());
                    v.setOuType(orgOuRpcDTO.getOuType());
                    v.setOuCode(orgOuRpcDTO.getOuCode());
                    if (!MapUtils.isEmpty((Map)ouTypeInnerUdc) && !StringUtils.isEmpty((CharSequence)orgOuRpcDTO.getOuType())) {
                        v.setOuTypeName((String)ouTypeInnerUdc.get(orgOuRpcDTO.getOuType()));
                    }
                }
                if (!MapUtils.isEmpty((Map)finalBuMap) && null != l.getBuId() && !ObjectUtils.isEmpty(finalBuMap.get(v.getBuId()))) {
                    v.setBuName(((SysOrgBasicDTO)finalBuMap.get(v.getBuId())).getName());
                    v.setBuCode(((SysOrgBasicDTO)finalBuMap.get(v.getBuId())).getCode());
                }
                if (!MapUtils.isEmpty((Map)channelTypeUdc) && StringUtils.isNotBlank((CharSequence)l.getChannelType())) {
                    v.setChannelTypeName((String)channelTypeUdc.get(v.getChannelType()));
                }
                if (!MapUtils.isEmpty((Map)paymentTermUdc) && StringUtils.isNotBlank((CharSequence)v.getPaymentTerm())) {
                    v.setPaymentTermName((String)paymentTermUdc.get(v.getPaymentTerm()));
                }
                res.add(v);
            });
        }
        if (CollectionUtils.isNotEmpty(res)) {
            // empty if block
        }
        return res;
    }
}

