/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.ReUtil;
import com.elitescloud.boot.auth.cas.model.AuthUserDTO;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.param.SysSendVerifyCodeVO;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.core.support.verifycode.common.VerifyCodeManager;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.CustAccountService;
import com.elitesland.yst.production.sale.api.service.DeCustAccountService;
import com.elitesland.yst.production.sale.api.service.common.DeAccountRoleService;
import com.elitesland.yst.production.sale.api.vo.param.com.DeAccountRoleParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustAccountParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustAccountQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustUpdateVO;
import com.elitesland.yst.production.sale.api.vo.resp.com.DeAccountRoleVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.RemarkCustPwdVO;
import com.elitesland.yst.production.sale.api.vo.save.CustAccountUpdateVO;
import com.elitesland.yst.production.sale.config.cas.CasUserClientHelper;
import com.elitesland.yst.production.sale.convert.CustAccountConvert;
import com.elitesland.yst.production.sale.entity.CustAccountDO;
import com.elitesland.yst.production.sale.repo.CustAccountRepo;
import com.elitesland.yst.production.sale.repo.CustAccountRepoProc;
import com.elitesland.yst.production.sale.repo.common.DeAccountRoleRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysRoleService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service(value="lmCustAccountService")
public class DeCustAccountServiceImpl
implements DeCustAccountService {
    private static final Logger log = LoggerFactory.getLogger(DeCustAccountServiceImpl.class);
    private final CustAccountRepo custAccountRepo;
    private final CasUserClientHelper casUserClientHelper;
    private final CustAccountRepoProc custAccountRepoProc;
    private final DeAccountRoleService lmAcountRoleService;
    private final DeAccountRoleRepoProc deAccountRoleRepoProc;
    private final RmiSysRoleService rmiSysRoleService;
    private final CustAccountService custAccountService;
    private final RedisUtils redisClient;
    private final TenantDataIsolateProvider tenantDataIsolateProvider;
    private final TenantClientProvider tenantClientProvider;
    private final VerifyCodeManager verifyCodeManager;
    private final SeqNumProvider sysNumberRuleService;
    private static final String BUSINESS_TYPE_RETRIEVE_PWD = "yst_sale_retrieve_pwd";
    private final JdbcTemplate jdbcTemplate;
    @Autowired
    private SysUserRpcService sysUserRpcService;
    public static final String REG_MOBILE = "^(12[1-3]\\d{8})|[1][3-9]\\d{9}$|^([5|6|7|9])\\d{7}$|^[0][9]\\d{8}$|^[6]\\d{7}$";

    @Transactional(rollbackFor={Exception.class})
    public Long createUser(CrmCustAccountParam param) {
        CustAccountDO custAccountDO = this.excuteAccountInfo(param);
        CustAccountVO custAccountVO = new CustAccountVO();
        if (Boolean.FALSE.equals(param.getCreateFlag())) {
            List custAccounts = new ArrayList();
            ArrayList<String> dealerTypes = new ArrayList<String>();
            if (StringUtil.isNotBlank((CharSequence)param.getSource())) {
                if ("CUST".equals(param.getSource())) {
                    dealerTypes.add("ONE");
                    dealerTypes.add("TWO");
                    custAccounts = this.custAccountService.getByCustCodesAndUserName(param.getCustCode(), param.getOldUserName(), dealerTypes);
                }
            } else {
                dealerTypes.add("STORE");
                custAccounts = this.custAccountService.getByUserNameAndSource(Collections.singletonList(param.getUserName()), dealerTypes, param.getBusinessTypeCust());
            }
            if (CollectionUtils.isEmpty(custAccounts)) {
                throw new BusinessException("\u672a\u627e\u5230\u8be5\u8d26\u6237\u4fe1\u606f");
            }
            custAccountVO = (CustAccountVO)custAccounts.get(0);
            custAccountDO.setUserName(custAccountVO.getUserName());
            custAccountDO.setMobile(param.getMobile());
            custAccountDO.setId(custAccountVO.getId());
            custAccountDO.setUserId(custAccountVO.getUserId());
            custAccountDO.setIsModifyPwd(custAccountVO.getIsModifyPwd());
            custAccountDO.setBusinessTypeCust(param.getBusinessTypeCust());
            custAccountDO.setPwd(null);
            this.checkHandleSonAccount(custAccountVO, custAccountDO);
        } else {
            CustAccountVO accountMobile = this.custAccountRepoProc.getAccountByMobile(custAccountDO.getMobile());
            if (!ObjectUtils.isEmpty((Object)accountMobile)) {
                custAccountDO.setIsModifyPwd(accountMobile.getIsModifyPwd());
                custAccountDO.setPwd(null);
            }
            custAccountDO = (CustAccountDO)this.custAccountRepo.save(custAccountDO);
        }
        Map<String, AuthUserDTO> userDTOMap = this.checkAndPackUserInfo(param.getCustCode(), custAccountDO, custAccountVO, param.getBusinessTypeCust());
        Long userId = this.casUserClientHelper.onUpsert(userDTOMap.get(custAccountDO.getCustCode()));
        CustAccountVO account = this.custAccountRepoProc.getAccountByMobile(param.getMobile());
        if (!ObjectUtils.isEmpty((Object)account)) {
            custAccountDO.setIsModifyPwd(account.getIsModifyPwd());
        }
        this.custAccountRepo.save(custAccountDO);
        return userId;
    }

    private void checkHandleSonAccount(CustAccountVO custAccountVO, CustAccountDO custAccountDO) {
        if (!(ObjectUtils.isEmpty((Object)custAccountVO.getDealerType()) || ObjectUtils.isEmpty((Object)custAccountVO.getBusinessType()) || custAccountVO.getBusinessType().equals(custAccountDO.getBusinessType()) && custAccountVO.getBusinessType().equals(custAccountDO.getBusinessType()))) {
            this.sonAccountRoleHandle(custAccountVO.getCustCode());
        }
    }

    private void sonAccountRoleHandle(String custCode) {
        CustAccountQueryParam param1 = new CustAccountQueryParam();
        param1.setCustCode(custCode);
        List<CustAccountVO> tradeConfigPage = this.custAccountRepoProc.getAccountPage(param1);
        if (ObjectUtils.isEmpty(tradeConfigPage)) {
            return;
        }
        tradeConfigPage.forEach(k -> {
            k.setRoleName(null);
            k.setRoleId(null);
            k.setRoleCode(null);
        });
        List accountDOS = tradeConfigPage.stream().map(CustAccountConvert.INSTANCE::voToDO).collect(Collectors.toList());
        this.custAccountRepo.saveAll(accountDOS);
    }

    private CustAccountDO excuteAccountInfo(CrmCustAccountParam param) {
        CustAccountDO custAccountDO = new CustAccountDO();
        custAccountDO.setCustCode(param.getCustCode());
        if (StringUtil.isNotBlank((CharSequence)param.getUserName())) {
            custAccountDO.setUserName(param.getUserName());
        } else {
            custAccountDO.setUserName(param.getMobile());
        }
        if (!ObjectUtils.isEmpty((Object)param.getUserName())) {
            custAccountDO.setUserName(param.getUserName());
        }
        custAccountDO.setMobile(param.getMobile());
        custAccountDO.setPwd("123456");
        custAccountDO.setIsOpenAccount(Boolean.FALSE);
        custAccountDO.setDealerType(param.getDealerType());
        custAccountDO.setSubAcFlag(param.getSubAcFlag());
        custAccountDO.setEnable(param.getEnable());
        custAccountDO.setBusinessType(param.getBusinessType());
        custAccountDO.setNickName(param.getCustName());
        custAccountDO.setBusinessTypeCust(param.getBusinessTypeCust());
        if (!ObjectUtils.isEmpty((Object)param.getBusinessType())) {
            DeAccountRoleParam param1 = new DeAccountRoleParam();
            param1.setDealerType(param.getDealerType());
            param1.setBusinessType(param.getBusinessType());
            List<DeAccountRoleVO> serviceRole = this.deAccountRoleRepoProc.getRole(param1);
            if (!ObjectUtils.isEmpty(serviceRole)) {
                custAccountDO.setRoleCode(serviceRole.get(0).getRoleCode());
                custAccountDO.setRoleId(serviceRole.get(0).getRoleId());
            }
        }
        return custAccountDO;
    }

    public PagingVO<CustAccountVO> searchCustAccount(CustAccountQueryParam param) {
        SysUserDTO sysUser = this.getCurrentUser();
        CustAccountVO currentAccount = this.custAccountRepoProc.getAccountByUserId(sysUser.getId());
        param.setCustCode(currentAccount.getCustCode());
        long count = this.custAccountRepoProc.getAccountPageCount(param);
        if (count > 0L) {
            List<CustAccountVO> tradeConfigPage = this.custAccountRepoProc.getAccountPage(param);
            tradeConfigPage.forEach(t -> t.setCreateAccountTime(t.getCreateTime()));
            this.translate(tradeConfigPage);
            return new PagingVO(count, tradeConfigPage);
        }
        return new PagingVO();
    }

    @Transactional(rollbackFor={Exception.class})
    public Long createSonUser(CustUpdateVO param) {
        Boolean exists = this.custAccountRepoProc.exists1(param.getMobile(), "", "CUST", param.getBusinessTypeCust());
        if (exists.booleanValue()) {
            throw new BusinessException("\u4e1a\u52a1\u7c7b\u578b:" + param.getBusinessTypeCust() + "\u5bf9\u5e94\u7684\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\uff01");
        }
        CustAccountConvert custAccountConvert = CustAccountConvert.INSTANCE;
        SysUserDTO currentUser = this.getCurrentUser();
        CustAccountDO byUserName = this.custAccountRepoProc.getByUserId(currentUser.getId());
        CustAccountVO custAccountVO = new CustAccountVO();
        if ("STORE".equals(byUserName.getDealerType())) {
            String docNo = this.sysNumberRuleService.generateCode("yst-sale", "STORE_EMP", Collections.singletonList(byUserName.getCustCode()));
            custAccountVO.setUserName(docNo);
        } else {
            this.checkUserMobile(param.getMobile(), param.getId(), "CUST");
            log.info("\u8ba4\u8bc1\u670d\u52a1\u901a\u8fc7\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u53c2\u6570\uff1a{}", (Object)param.getMobile());
            Result<AuthUserDTO> result = this.casUserClientHelper.getAuthByMobile(param.getMobile());
            log.info("\u8ba4\u8bc1\u670d\u52a1\u901a\u8fc7\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u8fd4\u56de\uff1a{}", result);
            if (result.getSuccess().booleanValue() && !ObjectUtils.isEmpty((Object)result.getData())) {
                AuthUserDTO authUserDTO = (AuthUserDTO)result.getData();
                custAccountVO.setUserName(authUserDTO.getUsername());
                custAccountVO.setUserId(authUserDTO.getId());
            } else {
                custAccountVO.setUserName(param.getMobile() + "_" + RandomUtil.randomString((int)6));
            }
        }
        custAccountVO.setCustCode(byUserName.getCustCode());
        custAccountVO.setMobile(param.getMobile());
        custAccountVO.setNickName(param.getNickName());
        custAccountVO.setDealerType(byUserName.getDealerType());
        custAccountVO.setEnable(Boolean.TRUE);
        custAccountVO.setSubAcFlag(Boolean.TRUE);
        custAccountVO.setRoleId(param.getRoleId());
        custAccountVO.setRoleCode(param.getRoleCode());
        custAccountVO.setPwd("123456");
        custAccountVO.setBusinessTypeCust(param.getBusinessTypeCust());
        CustAccountDO custAccountDO = custAccountConvert.voToDO(custAccountVO);
        CustAccountDO save = (CustAccountDO)this.custAccountRepo.save(custAccountDO);
        AuthUserDTO authUserDTO = new AuthUserDTO();
        if (!"STORE".equals(byUserName.getDealerType())) {
            authUserDTO.setMobile(custAccountVO.getMobile());
        }
        authUserDTO.setId(custAccountVO.getUserId());
        authUserDTO.setUsername(custAccountVO.getUserName());
        authUserDTO.setPassword("123456");
        authUserDTO.setIdentityType(param.getBusinessTypeCust());
        this.casUserClientHelper.onUpsert(authUserDTO);
        return save.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateSonAccount(CustUpdateVO param) {
        Boolean exists = this.custAccountRepoProc.existsCustAccount(param.getMobile(), param.getId(), "CUST");
        if (exists.booleanValue()) {
            throw new BusinessException("\u6b64\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\uff01");
        }
        CustAccountConvert custAccountConvert = CustAccountConvert.INSTANCE;
        Optional accountRepoById = this.custAccountRepo.findById(param.getId());
        AuthUserDTO authUserDTO = new AuthUserDTO();
        if (accountRepoById.isEmpty()) {
            throw new BusinessException("\u672a\u627e\u5230\u5f53\u524d\u7528\u6237");
        }
        CustAccountDO byUserName = (CustAccountDO)accountRepoById.get();
        CustAccountVO custAccountVO = custAccountConvert.doToVO((CustAccountDO)accountRepoById.get());
        if ("STORE".equals(custAccountVO.getDealerType())) {
            authUserDTO.setUsername(byUserName.getUserName());
        } else {
            this.checkUserName(param.getUserName(), param.getMobile(), param.getId(), "CUST", param.getBusinessTypeCust());
            custAccountVO.setUserName(param.getUserName());
            authUserDTO.setMobile(param.getMobile());
        }
        custAccountVO.setNickName(param.getNickName());
        custAccountVO.setMobile(param.getMobile());
        custAccountVO.setRoleCode(param.getRoleCode());
        custAccountVO.setRoleId(param.getRoleId());
        custAccountVO.setDealerType(byUserName.getDealerType());
        custAccountVO.setBusinessTypeCust(param.getBusinessTypeCust());
        CustAccountDO custAccountDO = custAccountConvert.voToDO(custAccountVO);
        this.custAccountRepo.save(custAccountDO);
        authUserDTO.setId(custAccountVO.getUserId());
        authUserDTO.setFirstName(custAccountVO.getNickName());
        authUserDTO.setUsername(custAccountVO.getUserName());
        authUserDTO.setUserType(param.getDealerType());
        authUserDTO.setIdentityType(custAccountVO.getBusinessTypeCust());
        this.casUserClientHelper.onUpsert(authUserDTO);
        return custAccountDO.getId();
    }

    private void getRoleInfo(CustAccountVO custAccountVO) {
        if (!ObjectUtils.isEmpty((Object)custAccountVO.getBusinessType())) {
            DeAccountRoleParam param1 = new DeAccountRoleParam();
            param1.setDealerType(custAccountVO.getDealerType());
            param1.setBusinessType(custAccountVO.getBusinessType());
            List serviceRole = this.lmAcountRoleService.getRole(param1);
            if (!ObjectUtils.isEmpty((Object)serviceRole)) {
                custAccountVO.setRoleCode(((DeAccountRoleVO)serviceRole.get(0)).getRoleCode());
                custAccountVO.setRoleId(((DeAccountRoleVO)serviceRole.get(0)).getRoleId());
            } else {
                throw new BusinessException("\u672a\u627e\u5230\u6743\u9650\u89d2\u8272\u4fe1\u606f!!!");
            }
        }
    }

    public CustAccountVO getCustAccountByUserId(Long userId) {
        CustAccountDO allByUserId = this.custAccountRepo.findAllByUserId(userId);
        CustAccountConvert custAccountConvert = CustAccountConvert.INSTANCE;
        return custAccountConvert.doToVO(allByUserId);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long onEnable(Long userId, Boolean enable) {
        CustAccountConvert custAccountConvert = CustAccountConvert.INSTANCE;
        CustAccountVO custAccountVO = this.getCustAccountByUserId(userId);
        custAccountVO.setEnable(enable);
        this.casUserClientHelper.onEnabled(userId, enable);
        CustAccountDO custAccountDO = custAccountConvert.voToDO(custAccountVO);
        CustAccountDO save = (CustAccountDO)this.custAccountRepo.save(custAccountDO);
        return save.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public Long remakePwd(CustAccountUpdateVO custAccountUpdate) {
        List<CustAccountDO> tenantInfos = this.getTenantInfo2(custAccountUpdate.getUserName());
        custAccountUpdate.setMobile(tenantInfos.get(0).getMobile());
        this.checkPwd(custAccountUpdate);
        this.tenantDataIsolateProvider.byTenantDirectly(() -> {
            ArrayList userIds = new ArrayList();
            tenantInfos.forEach(a -> {
                Long userId = null;
                try {
                    userId = this.casUserClientHelper.onUpdatePassword(a.getUserId(), custAccountUpdate.getNewPwd());
                }
                catch (Exception e) {
                    log.error("\u4fee\u6539\u5bc6\u7801 error:", (Throwable)e);
                    throw new BusinessException("\u8c03\u7528\u4fee\u6539\u5bc6\u7801\u670d\u52a1\u5f02\u5e38" + e, (Throwable)e);
                }
                custAccountUpdate.setNewPwd(custAccountUpdate.getNewPwd());
                this.custAccountService.updateAccountPwd(a.getUserId(), custAccountUpdate);
            });
            return userIds;
        }, this.tenantClientProvider.getTenant(tenantInfos.get(0).getTenantId()));
        return null;
    }

    private CustAccountDO getTenantInfo(String username, String identityType) {
        List custAccountDOS = new ArrayList();
        boolean correctMobile = ReUtil.isMatch((String)REG_MOBILE, (CharSequence)username);
        custAccountDOS = correctMobile ? this.jdbcTemplate.query("select * from cust_account where delete_flag = 0 and business_type_cust = " + identityType + " dealer_type <> 'STORE' and mobile = " + username, (RowMapper)new BeanPropertyRowMapper(CustAccountDO.class)) : this.jdbcTemplate.query("select * from cust_account where delete_flag = 0 and dealer_type = 'STORE' and user_name = " + username, (RowMapper)new BeanPropertyRowMapper(CustAccountDO.class));
        if (ObjectUtils.isEmpty(custAccountDOS)) {
            throw new BusinessException(username + "\u8d26\u6237\u4e0d\u5b58\u5728\u8bf7\u68c0\u67e5!!!");
        }
        return (CustAccountDO)custAccountDOS.get(0);
    }

    private List<CustAccountDO> getTenantInfo2(String username) {
        List custAccountDOS = new ArrayList();
        boolean correctMobile = ReUtil.isMatch((String)REG_MOBILE, (CharSequence)username);
        custAccountDOS = correctMobile ? this.jdbcTemplate.query("select * from cust_account where delete_flag = 0 and  dealer_type <> 'STORE' and mobile = " + username, (RowMapper)new BeanPropertyRowMapper(CustAccountDO.class)) : this.jdbcTemplate.query("select * from cust_account where delete_flag = 0 and dealer_type = 'STORE' and user_name = " + username, (RowMapper)new BeanPropertyRowMapper(CustAccountDO.class));
        if (ObjectUtils.isEmpty(custAccountDOS)) {
            throw new BusinessException(username + "\u8d26\u6237\u4e0d\u5b58\u5728\u8bf7\u68c0\u67e5!!!");
        }
        return custAccountDOS;
    }

    private void checkPwd(CustAccountUpdateVO custAccountUpdate) {
        String verify = this.verifyCodeManager.verify(BUSINESS_TYPE_RETRIEVE_PWD, custAccountUpdate.getMobile(), custAccountUpdate.getKaptcha());
        if (!ObjectUtils.isEmpty((Object)verify)) {
            throw new BusinessException(verify);
        }
        if (ObjectUtils.isEmpty((Object)custAccountUpdate)) {
            throw new BusinessException("\u5bc6\u7801\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (!custAccountUpdate.getNewPwd().equals(custAccountUpdate.getConfirmPwd())) {
            throw new BusinessException("\u5bc6\u7801\u4e0d\u4e00\u81f4\uff01");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Object delSonAccount(List<Long> accountIds) {
        List allById = this.custAccountRepo.findAllById(accountIds);
        allById.forEach(k -> this.casUserClientHelper.onDelete(k.getUserId()));
        return this.custAccountRepoProc.delSonAccount(accountIds);
    }

    public ApiResult<String> sendSms(String username) {
        CustAccountDO accountDO = this.getTenantInfo(username, "");
        String mobile = accountDO.getMobile();
        if (ObjectUtils.isEmpty((Object)mobile)) {
            throw new BusinessException(username + "\u7684\u8d26\u6237\u672a\u7ef4\u62a4\u624b\u673a\u53f7,\u8bf7\u5148\u7ef4\u62a4\u624b\u673a\u53f7");
        }
        SysSendVerifyCodeVO sysSendVerifyCodeVO = new SysSendVerifyCodeVO();
        sysSendVerifyCodeVO.setAccount(mobile);
        sysSendVerifyCodeVO.setAccountType("mobile");
        sysSendVerifyCodeVO.setPeriod(Long.valueOf(600L));
        this.verifyCodeManager.send(BUSINESS_TYPE_RETRIEVE_PWD, sysSendVerifyCodeVO);
        return ApiResult.ok((Object)mobile);
    }

    public ApiResult<List<RemarkCustPwdVO>> sendSms2(String phone) {
        List<CustAccountDO> accountDO = this.getTenantInfo2(phone);
        String mobile = accountDO.get(0).getMobile();
        if (ObjectUtils.isEmpty((Object)mobile)) {
            throw new BusinessException(phone + "\u7684\u8d26\u6237\u672a\u7ef4\u62a4\u624b\u673a\u53f7,\u8bf7\u5148\u7ef4\u62a4\u624b\u673a\u53f7");
        }
        SysSendVerifyCodeVO sysSendVerifyCodeVO = new SysSendVerifyCodeVO();
        sysSendVerifyCodeVO.setAccount(mobile);
        sysSendVerifyCodeVO.setAccountType("mobile");
        sysSendVerifyCodeVO.setPeriod(Long.valueOf(600L));
        this.verifyCodeManager.send(BUSINESS_TYPE_RETRIEVE_PWD, sysSendVerifyCodeVO);
        ArrayList list = new ArrayList();
        accountDO.forEach(a -> {
            RemarkCustPwdVO remarkCustPwdVO = new RemarkCustPwdVO();
            remarkCustPwdVO.setUserId(a.getUserId());
            remarkCustPwdVO.setMobile(mobile);
            remarkCustPwdVO.setUserName(a.getUserName());
            list.add(remarkCustPwdVO);
        });
        return ApiResult.ok(list);
    }

    private String encipherPhone(String phone) {
        String k = "****";
        StringBuilder sb = new StringBuilder(phone);
        sb.replace(3, sb.length() - 4, k);
        return sb.toString();
    }

    public Boolean checkMobileSmsKaptcha(String key, String kaptcha) {
        Object s = this.redisClient.get(key);
        return s != null && s.toString().equals(kaptcha);
    }

    public static String craterKey(String type, String mobile) {
        return type + ":" + mobile;
    }

    private String formatContent(String str, String kaptcha) {
        return MessageFormat.format(str, kaptcha);
    }

    public String getKaptcha(int length) {
        StringBuilder str = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            int randomInt = random.nextInt(10);
            str.append(randomInt);
        }
        return str.toString();
    }

    private void translate(List<CustAccountVO> custAccountVOS) {
        List rolesIds = custAccountVOS.stream().map(CustAccountVO::getRoleId).distinct().collect(Collectors.toList());
        DeAccountRoleParam param = new DeAccountRoleParam();
        param.setRoleIds(rolesIds);
        List<DeAccountRoleVO> repoProcRole = this.deAccountRoleRepoProc.getRole(param);
        custAccountVOS.forEach(k -> repoProcRole.stream().filter(n -> n.getRoleId().equals(k.getRoleId())).findFirst().ifPresent(ro -> k.setRoleName(ro.getRoleName())));
    }

    private SysUserDTO getCurrentUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (Objects.isNull(userDetails) || Objects.isNull(userDetails.getUser())) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        SysUserDTO sysUser = userDetails.getUser();
        if (ObjectUtils.isEmpty((Object)sysUser)) {
            throw new BusinessException("\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        return sysUser;
    }

    private Map<String, AuthUserDTO> checkAndPackUserInfo(String custCode, CustAccountDO accountDO, CustAccountVO custAccountVO, String businessTypeCust) {
        HashMap<String, AuthUserDTO> res = new HashMap<String, AuthUserDTO>();
        this.checkUserName(accountDO.getUserName(), accountDO.getMobile(), accountDO.getId(), accountDO.getDealerType(), businessTypeCust);
        AuthUserDTO authUser = this.excuteUserInfo(accountDO, custAccountVO, businessTypeCust);
        res.put(custCode, authUser);
        return res;
    }

    public void checkUserName(String userName, String mobile, Long id, String source, String businessTypeCust) {
        if (StringUtil.isBlank((CharSequence)source)) {
            throw new BusinessException("\u6765\u6e90\u4e3a\u7a7a");
        }
        Boolean exists = Boolean.FALSE;
        exists = !source.equals("STORE") ? this.custAccountRepoProc.existsMobile2(mobile, id, source, businessTypeCust) : this.custAccountRepoProc.exists(userName, id, source);
        if (exists.booleanValue()) {
            throw new BusinessException("\u6b64\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\uff01");
        }
    }

    public void checkUserMobile(String mobile, Long id, String source) {
        if (StringUtil.isBlank((CharSequence)source)) {
            throw new BusinessException("\u6765\u6e90\u4e3a\u7a7a");
        }
        Boolean exists = this.custAccountRepoProc.existsMobile(mobile, id, source);
        if (exists.booleanValue()) {
            throw new BusinessException("\u6b64\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\uff01");
        }
    }

    public AuthUserDTO excuteUserInfo(CustAccountDO custAccountDO, CustAccountVO custAccountVO, String businessTypeCust) {
        AuthUserDTO authUser = new AuthUserDTO();
        if (ObjectUtils.isEmpty((Object)custAccountVO.getUserName())) {
            authUser.setUsername(custAccountDO.getUserName());
        } else {
            authUser.setUsername(custAccountVO.getUserName());
        }
        authUser.setIdentityType(businessTypeCust);
        authUser.setPassword(custAccountDO.getPwd());
        if (!custAccountDO.getDealerType().equals("STORE")) {
            authUser.setMobile(custAccountDO.getMobile());
        }
        authUser.setIdentityType(businessTypeCust);
        authUser.setId(custAccountDO.getUserId());
        authUser.setFirstName(custAccountDO.getUserName());
        authUser.setEnabled(Boolean.valueOf(true));
        authUser.setUserType(custAccountDO.getDealerType());
        return authUser;
    }

    public Boolean isModifyPwd(String userName) {
        CustAccountDO custAccount = this.custAccountRepoProc.getByMobileDo(userName);
        return custAccount.getIsModifyPwd();
    }

    public Boolean isModifyPwdByUserId(Long userId) {
        CustAccountVO custAccount = this.custAccountRepoProc.getAccountByUserId(userId);
        return custAccount.getIsModifyPwd();
    }

    public ApiResult<String> modifyPwdStatus(Long userId) {
        this.jdbcTemplate.update("update cust_account set is_modify_pwd = 1 where user_id = " + userId);
        return ApiResult.ok((Object)userId.toString());
    }

    public DeCustAccountServiceImpl(CustAccountRepo custAccountRepo, CasUserClientHelper casUserClientHelper, CustAccountRepoProc custAccountRepoProc, DeAccountRoleService lmAcountRoleService, DeAccountRoleRepoProc deAccountRoleRepoProc, RmiSysRoleService rmiSysRoleService, CustAccountService custAccountService, RedisUtils redisClient, TenantDataIsolateProvider tenantDataIsolateProvider, TenantClientProvider tenantClientProvider, VerifyCodeManager verifyCodeManager, SeqNumProvider sysNumberRuleService, JdbcTemplate jdbcTemplate) {
        this.custAccountRepo = custAccountRepo;
        this.casUserClientHelper = casUserClientHelper;
        this.custAccountRepoProc = custAccountRepoProc;
        this.lmAcountRoleService = lmAcountRoleService;
        this.deAccountRoleRepoProc = deAccountRoleRepoProc;
        this.rmiSysRoleService = rmiSysRoleService;
        this.custAccountService = custAccountService;
        this.redisClient = redisClient;
        this.tenantDataIsolateProvider = tenantDataIsolateProvider;
        this.tenantClientProvider = tenantClientProvider;
        this.verifyCodeManager = verifyCodeManager;
        this.sysNumberRuleService = sysNumberRuleService;
        this.jdbcTemplate = jdbcTemplate;
    }
}

