/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.service.SalProjService;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalProjPagingParam;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalProjQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalProjSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalProjDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalProjPageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalProjSimpleRespVO;
import com.elitesland.yst.production.sale.api.vo.save.SalProjImportSaveVO;
import com.elitesland.yst.production.sale.convert.SalProjConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.QSalProjDO;
import com.elitesland.yst.production.sale.entity.SalProjDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.CrmScustRepoProc;
import com.elitesland.yst.production.sale.repo.SalProjRepo;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgBuService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.support.provider.org.dto.OrgBuRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SalProjServiceImpl
extends BaseServiceImpl
implements SalProjService {
    private static final Logger log = LoggerFactory.getLogger(SalProjServiceImpl.class);
    private final QSalProjDO qSalProjDO = QSalProjDO.salProjDO;
    private final SalProjRepo salProjRepo;
    private final ComSaleFileInfoService comSaleFileInfoService;
    private final RmiOrgOuService rmiOrgOuService;
    private final RmiSysNextNumberService nextNumberService;
    private final RmiOrgBuService rmiOrgBuService;
    private final CrmCustRepoProc crmCustRepoProc;
    private final CrmScustRepoProc crmScustRepoProc;

    @SysCodeProc
    public PagingVO<SalProjPageRespVO> query(SalProjPagingParam pageParam) {
        Predicate predicate = this.buildPageSearchCondition(pageParam);
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)this.qSalProjDO).where(predicate);
        long total = jpaQuery.fetchCount();
        if (total == 0L) {
            return PagingVO.builder().build();
        }
        PageRequest pageRequest = this.wrapperPageRequest(pageParam.getPageRequest(), null);
        this.appendPageAndSort(jpaQuery, pageRequest, this.qSalProjDO);
        List queryResult = jpaQuery.fetch();
        List<SalProjPageRespVO> pageResult = queryResult.stream().map(SalProjConvert.INSTANCE::doToPageRespVo).collect(Collectors.toList());
        List<Long> ouIds = queryResult.stream().map(SalProjDO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<OrgOuRpcDTO> ouRpcResult = this.rmiOrgOuService.findOuDtoList(ouIds, null);
        List<Long> buIds = queryResult.stream().map(SalProjDO::getBuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<OrgBuRpcDTO> buRpcResult = this.rmiOrgBuService.findBuDtoList(buIds, null);
        pageResult.forEach(r -> {
            ouRpcResult.stream().filter(ou -> Objects.nonNull(r.getOuId()) && r.getOuId().equals(ou.getId())).findFirst().ifPresent(o -> r.setOuName(o.getOuName()));
            buRpcResult.stream().filter(bu -> Objects.nonNull(r.getBuId()) && r.getBuId().equals(bu.getId())).findFirst().ifPresent(b -> r.setBuName(b.getBuName()));
        });
        return PagingVO.builder().total(total).records(pageResult).build();
    }

    @Transactional(rollbackFor={Exception.class})
    public JSONObject save(SalProjSaveParam param) {
        SalProjDO salProjDO;
        SalProjDO checkProjName = this.salProjRepo.findByProjName(param.getProjName());
        if (Objects.nonNull(checkProjName) && (Objects.isNull(param.getId()) || Objects.nonNull(param.getId()) && !param.getId().equals(checkProjName.getId()))) {
            throw new BusinessException("\u9879\u76ee\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u5728\u67e5\u8be2\u754c\u9762\u67e5\u8be2\u6b64\u9879\u76ee");
        }
        if (Objects.isNull(param.getId())) {
            String projNo = this.nextNumberService.generateCode("yst-sale", "SAL_PROJ_NO", new ArrayList<String>());
            param.setProjNo(projNo);
        } else {
            salProjDO = (SalProjDO)this.salProjRepo.findById(param.getId()).orElseThrow(new BusinessException("\u9879\u76ee\u4e0d\u5b58\u5728"));
            param.setProjNo(salProjDO.getProjNo());
        }
        salProjDO = SalProjConvert.INSTANCE.paramToDo(param);
        salProjDO.setDeleteFlag(0);
        salProjDO.setSecBuId(param.getBuId());
        salProjDO.setSecOuId(param.getOuId());
        this.salProjRepo.save(salProjDO);
        this.comSaleFileInfoService.comSaleFileHardSave("SAL_PROJ", salProjDO.getId(), param.getAttachFiles());
        JSONObject result = new JSONObject();
        result.put("id", (Object)salProjDO.getId());
        result.put("projNo", (Object)salProjDO.getProjNo());
        return result;
    }

    @SysCodeProc
    public SalProjDetailRespVO queryOneDetail(Long id) {
        SalProjDO salProjDO = (SalProjDO)this.salProjRepo.findById(id).orElseThrow(new BusinessException("\u9879\u76ee\u4e0d\u5b58\u5728"));
        SalProjDetailRespVO salProjDetailRespVO = SalProjConvert.INSTANCE.doToDetailRespVo(salProjDO);
        Long ouId = salProjDetailRespVO.getOuId();
        List<OrgOuRpcDTO> ouRpcResult = this.rmiOrgOuService.findOuDtoList(Lists.newArrayList((Object[])new Long[]{ouId}), null);
        ouRpcResult.stream().filter(ou -> Objects.nonNull(ou) && ouId.equals(ou.getId())).findFirst().ifPresent(o -> salProjDetailRespVO.setOuName(o.getOuName()));
        Long buId = salProjDetailRespVO.getBuId();
        List<OrgBuRpcDTO> buRpcResult = this.rmiOrgBuService.findBuDtoList(Lists.newArrayList((Object[])new Long[]{buId}), null);
        buRpcResult.stream().filter(bu -> Objects.nonNull(bu) && buId.equals(bu.getId())).findFirst().ifPresent(o -> salProjDetailRespVO.setBuName(o.getBuName()));
        List attachFiles = this.comSaleFileInfoService.findFileByBusinessId("SAL_PROJ", id);
        salProjDetailRespVO.setAttachFiles(attachFiles);
        return salProjDetailRespVO;
    }

    public void delSalProj(List<Long> ids) {
        if (CollUtil.isNotEmpty(ids)) {
            // empty if block
        }
    }

    public List<SalProjSimpleRespVO> queryByParam(SalProjQueryParam param) {
        BooleanExpression predicate = this.qSalProjDO.isNotNull();
        if (Objects.nonNull(param)) {
            if (Objects.nonNull(param.getId())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalProjDO.id.eq((Object)param.getId()));
            }
            if (StrUtil.isNotBlank((CharSequence)param.getProjNo())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalProjDO.projNo.like("%" + param.getProjNo().trim() + "%"));
            }
            if (StrUtil.isNotBlank((CharSequence)param.getProjName())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalProjDO.projName.like("%" + param.getProjName().trim() + "%"));
            }
            if (StrUtil.isNotBlank((CharSequence)param.getProjType())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalProjDO.projType.eq((Object)param.getProjType()));
            }
            if (Objects.nonNull(param.getCustId())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalProjDO.custId.eq((Object)param.getCustId()));
            }
            if (CollUtil.isNotEmpty((Collection)param.getIds())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalProjDO.id.in((Collection)param.getIds()));
            }
            if (CollUtil.isNotEmpty((Collection)param.getProjNos())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalProjDO.projNo.in((Collection)param.getProjNos()));
            }
            if (Objects.nonNull(param.getOuId())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalProjDO.ouId.eq((Object)param.getOuId()));
            }
            if (StrUtil.isNotBlank((CharSequence)param.getProjStatus())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalProjDO.projStatus.eq((Object)param.getProjStatus()));
            }
        } else {
            return new ArrayList<SalProjSimpleRespVO>(0);
        }
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)this.qSalProjDO).where((Predicate)predicate);
        List queryResult = jpaQuery.fetch();
        return queryResult.stream().map(SalProjConvert.INSTANCE::doToSimpleVo).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> projImportData(List<SalProjImportSaveVO> parseData) {
        this.importDataHandle(parseData);
        List salProjDOS = parseData.stream().map(SalProjConvert.INSTANCE::importToDo).collect(Collectors.toList());
        this.salProjRepo.saveAll(salProjDOS);
        return ApiResult.ok();
    }

    private void importDataHandle(List<SalProjImportSaveVO> parseData) {
    }

    private Predicate buildPageSearchCondition(SalProjPagingParam pageParam) {
        BooleanExpression predicate = this.qSalProjDO.isNotNull();
        if (Objects.nonNull(pageParam)) {
            if (Objects.nonNull(pageParam.getOuId())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalProjDO.ouId.eq((Object)pageParam.getOuId()));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getProjName())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalProjDO.projName.like("%" + pageParam.getProjName().trim() + "%"));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getRegion())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalProjDO.region.eq((Object)pageParam.getRegion()));
            }
            if (Objects.nonNull(pageParam.getCustId())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalProjDO.custId.eq((Object)pageParam.getCustId()));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getCustName())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalProjDO.custName.like("%" + pageParam.getCustName().trim() + "%"));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getCustType2())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalProjDO.custType2.eq((Object)pageParam.getCustType2()));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getProjNo())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalProjDO.projNo.like(pageParam.getProjNo() + "%"));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getCustCode())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalProjDO.custCode.eq((Object)pageParam.getCustCode()));
            }
        }
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.qSalProjDO.getMetadata()));
        return predicate;
    }

    public SalProjServiceImpl(SalProjRepo salProjRepo, ComSaleFileInfoService comSaleFileInfoService, RmiOrgOuService rmiOrgOuService, RmiSysNextNumberService nextNumberService, RmiOrgBuService rmiOrgBuService, CrmCustRepoProc crmCustRepoProc, CrmScustRepoProc crmScustRepoProc) {
        this.salProjRepo = salProjRepo;
        this.comSaleFileInfoService = comSaleFileInfoService;
        this.rmiOrgOuService = rmiOrgOuService;
        this.nextNumberService = nextNumberService;
        this.rmiOrgBuService = rmiOrgBuService;
        this.crmCustRepoProc = crmCustRepoProc;
        this.crmScustRepoProc = crmScustRepoProc;
    }
}

