/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.IterUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.yst.production.order.param.SalDoSignUserInfoDto;
import com.elitesland.yst.production.order.param.SalSoSignReqDto;
import com.elitesland.yst.production.sale.api.service.shop.HotSelingService;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.BipItemDO;
import com.elitesland.yst.production.sale.entity.BipMessageDO;
import com.elitesland.yst.production.sale.entity.BipOrderDDO;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.entity.QBipItemDO;
import com.elitesland.yst.production.sale.entity.QBipOrderDDO;
import com.elitesland.yst.production.sale.entity.QBipOrderDO;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepo;
import com.elitesland.yst.production.sale.repo.shop.BipMessageRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderDRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepoProc;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiDoRpcService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSettingService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class HotSellingServiceImpl
implements HotSelingService {
    private static final Logger log = LoggerFactory.getLogger(HotSellingServiceImpl.class);
    @Autowired
    private BipOrderRepo bipOrderRepo;
    @Autowired
    private BipOrderDRepo bipOrderDRepo;
    @Autowired
    private BipItemRepo bipItemRepo;
    @Autowired
    private BipOrderRepoProc bipOrderRepoProc;
    @Autowired
    private RmiSettingService rmiSettingService;
    @Autowired
    private BipCustUserBindRepoProc bipCustUserBindRepoProc;
    @Autowired
    private RmiDoRpcService rmiDoRpcService;
    @Autowired
    private BipMessageRepo bipMessageRepo;
    private static final String SETTING_CODE = "ORDER_AUTO_SIGN_DAY";

    @Transactional(rollbackFor={Exception.class})
    public void update90HotSelling() {
        log.info("\u70ed\u9500\u5546\u54c1-------------------");
        List<BipItemDO> itemDoList = this.getItem();
        if (null != itemDoList && !itemDoList.isEmpty()) {
            itemDoList.stream().forEach(item -> {
                item.setNumSale90(0L);
                this.bipItemRepo.save(item);
            });
        }
        List<BipOrderDO> allOrders = this.getPaySuccessOrder();
        log.info("\u67e5\u8be290\u5929\u652f\u4ed8\u6210\u529f\u7684\u8ba2\u5355-------:" + allOrders.size());
        if (null != allOrders && !allOrders.isEmpty()) {
            allOrders.stream().forEach(order -> {
                List<BipOrderDDO> orderds = this.getOrderDetail(order.getId());
                log.info("\u70ed\u9500orders------------:" + JSON.toJSONString(orderds));
                if (null != orderds && !orderds.isEmpty()) {
                    orderds.stream().forEach(orderd -> {
                        BipItemDO item;
                        log.info("\u70ed\u9500orderd------------:" + JSON.toJSONString((Object)orderd));
                        if (null != orderd.getOuId() && null != orderd.getItemId() && null != (item = this.getItemById(orderd.getItemId(), orderd.getOuId())) && null != orderd.getBuyQty()) {
                            log.info("\u70ed\u9500\u5546\u54c1\u589e\u52a0\u6570\u91cf---:" + JSON.toJSONString((Object)item));
                            item.setNumSale90(item.getNumSale90() + orderd.getBuyQty());
                            log.info("\u70ed\u9500\u5546\u54c1\u589e\u52a0\u4e4b\u540e---:" + JSON.toJSONString((Object)item));
                            this.bipItemRepo.save(item);
                            log.info("\u70ed\u9500\u5546\u54c1\u4fdd\u5b58\u6210\u529f");
                        }
                    });
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void auOrderSignPush() {
        SysSettingVO settingByCode = this.rmiSettingService.findSettingByCode(SETTING_CODE);
        String settingVal = settingByCode.getSettingVal();
        List<String> aoOrders = this.bipOrderRepo.findAoOrders(Integer.parseInt(settingVal), UdcEnum.SAL_SO_STATUS_SHIP.getValueCode(), UdcEnum.SAL_SO_TYPE2_B.getValueCode(), UdcEnum.COM_DOC_CLS_SO.getValueCode(), UdcEnum.SAL_SO_TYPE_SOB1.getValueCode(), UdcEnum.SAL_SO_TYPE_SOB2.getValueCode());
        log.info("\u81ea\u52a8\u7b7e\u6536\u8ba2\u5355\u53f7\uff1a{}", (Object)JSON.toJSONString(aoOrders));
        List<BipOrderDO> bipOrderDOList = this.bipOrderRepo.findAllByDocNoIn(aoOrders);
        bipOrderDOList.forEach(bip -> {
            SalSoSignReqDto salSoSignReqDto = new SalSoSignReqDto();
            salSoSignReqDto.setDocNo(bip.getDocNo());
            SalDoSignUserInfoDto salDoSignUserInfoDto = new SalDoSignUserInfoDto();
            salDoSignUserInfoDto.setConfirmUserId(bip.getAdressId());
            salDoSignUserInfoDto.setConfirmUserName(bip.getContPerson());
            salSoSignReqDto.setSalDoSignUserInfoDto(salDoSignUserInfoDto);
            if (ObjectUtils.isEmpty((Object)bip.getAdressId()) || !ObjectUtils.isEmpty((Object)bip.getContPerson())) {
                // empty if block
            }
        });
        List bipOrderDOS = bipOrderDOList.stream().filter(b -> b.getAutoSignFlag().equals(Boolean.TRUE)).collect(Collectors.toList());
        List<BipOrderDO> bipOrderDOS1 = bipOrderDOS.stream().filter(b -> !ObjectUtils.isEmpty((Object)b.getAdressId()) && !ObjectUtils.isEmpty((Object)b.getContPerson())).collect(Collectors.toList());
        bipOrderDOS1.forEach(i -> i.setStatus("signed"));
        this.bipOrderRepo.saveAll(bipOrderDOS1);
        List bipMessageDOS = bipOrderDOS1.stream().map(mes -> {
            BipMessageDO bipMessageDO = new BipMessageDO();
            bipMessageDO.setTitle("\u3010\u7b7e\u6536\u901a\u77e5\u3011");
            bipMessageDO.setContext("\u60a8\u6709\u8ba2\u5355\u5df2\u81ea\u52a8\u7b7e\u6536\u4e86");
            bipMessageDO.setToCustId(mes.getCustAccountId());
            bipMessageDO.setStatus(UdcEnum.MESSAGE_STATUS_NOTREAD.getValueCode());
            return bipMessageDO;
        }).collect(Collectors.toList());
        this.bipMessageRepo.saveAll(bipMessageDOS);
    }

    public BipItemDO getItemById(Long itemId, Long ouId) {
        QBipItemDO qBipItemDO = QBipItemDO.bipItemDO;
        BooleanExpression expression = qBipItemDO.id.eq((Object)itemId).and((Predicate)qBipItemDO.ouId.eq((Object)ouId));
        Optional optional = this.bipItemRepo.findOne((Predicate)expression);
        if (optional.isEmpty()) {
            return null;
        }
        return (BipItemDO)optional.get();
    }

    public List<BipItemDO> getItem() {
        QBipItemDO qBipItemDO = QBipItemDO.bipItemDO;
        BooleanExpression expression = qBipItemDO.numSale90.gt((Number)0L).and((Predicate)qBipItemDO.deleteFlag.eq((Object)0));
        Iterable iterables = this.bipItemRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            return Lists.newArrayList((Iterable)iterables);
        }
        return null;
    }

    public List<BipOrderDDO> getOrderDetail(Long orderId) {
        QBipOrderDDO qBipOrderDDo = QBipOrderDDO.bipOrderDDO;
        BooleanExpression expression = qBipOrderDDo.orderId.eq((Object)orderId).and((Predicate)qBipOrderDDo.itemType.eq((Object)UdcEnum.ITM_ITM_TYPE_10.getValueCode()));
        Iterable iterables = this.bipOrderDRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            return Lists.newArrayList((Iterable)iterables);
        }
        return null;
    }

    public List<BipOrderDO> getPaySuccessOrder() {
        LocalDateTime date90After = LocalDateTime.now().minusDays(90L);
        QBipOrderDO qBipOrderDo = QBipOrderDO.bipOrderDO;
        BooleanExpression expression = qBipOrderDo.payStatus.eq((Object)"ps").and((Predicate)qBipOrderDo.payTime.between((Comparable)date90After, (Comparable)LocalDateTime.now()));
        Iterable iterables = this.bipOrderRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            return Lists.newArrayList((Iterable)iterables);
        }
        return null;
    }
}

