package com.elitesland.yst.production.sale.controller.menu;

import com.elitesland.yst.production.sale.api.service.BusFitstMenuConfDService;
import com.elitesland.yst.production.sale.api.vo.param.menu.BusFirstMenuConfDPagingParam;
import com.elitesland.yst.production.sale.api.vo.param.menu.BusFirstMenuConfDSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.menu.BusFirstMenuConfDVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 小程序首页配置详情
 */
@RestController
@RequestMapping(value = "/menu/confdetail", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "小程序首页配置详情 PC端")
@RequiredArgsConstructor
public class BusFirstMenuConfDController {

    private final BusFitstMenuConfDService busFitstMenuConfDService;


    @PostMapping(value = "/findPagingResult")
    @ApiOperation(value = "小程序首页配置商品详情列表")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<BusFirstMenuConfDVO>> findPagingResult(@RequestBody BusFirstMenuConfDPagingParam param){
        PagingVO<BusFirstMenuConfDVO> list = busFitstMenuConfDService.findPagingResult(param);
        return ApiResult.ok(list);
    }

    @PostMapping(value = "/saveMenuConfDetail")
    @ApiOperation(value = "添加菜单详情")
    @ApiOperationSupport(order = 2)
    public ApiResult<Object> saveMenuConfDetail(@RequestBody List<BusFirstMenuConfDSaveParam> list){
        return busFitstMenuConfDService.saveMenuConfDetail(list);
    }

    @PostMapping(value = "/delMenuConfDetail")
    @ApiOperation(value = "删除菜单详情")
    @ApiOperationSupport(order = 3)
    public ApiResult<Object> delMenuConfDetail(@RequestBody List<Long> ids){
        return busFitstMenuConfDService.delMenuConfDetail(ids);
    }


}
