package com.elitesland.yst.production.sale.controller.sal;


import com.elitesland.yst.production.sale.api.service.SalReceiptService;
import com.elitesland.yst.production.sale.api.vo.param.pri.RmiReSoDParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalInvApplyCheckParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalReceiptPageParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalReceiptSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiOrgBankAccRpcVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiReSoDVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalReceiptRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalReceiptdRespVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgAddrService;

import com.elitesland.yst.production.support.provider.org.param.OrgBankAccRpcDtoParam;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import com.elitescloud.cloudt.common.base.PagingVO;
import java.util.List;
import com.elitescloud.cloudt.common.base.ApiResult;

/**
 * 销售收款单
 * @auther JinXK
 * @date 2021/6/11 15:45
 */
@RestController
@RequestMapping(value = "/sal/receipt", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "销售收款单")
@Slf4j
public class SalReceiptController extends BaseController {

    @Autowired
    private SalReceiptService salReceiptService;

    @Autowired
    private RmiOrgAddrService rmiOrgAddrService;

    @PostMapping(value = "/query")
    @ApiOperation(value = "销售收款、退款单分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<SalReceiptRespVO>> query(@RequestBody SalReceiptPageParam pagingParam) {
        PagingVO<SalReceiptRespVO> result = salReceiptService.query(pagingParam);
        return ApiResult.ok(result);
    }

    @PostMapping(value = "/findBankAcc")
    @ApiOperation(value = "获取地址薄-银行信息列表")
    @ApiOperationSupport(order = 7)
    public ApiResult<Object> findBankAccRpcDtoByParam(@RequestBody OrgBankAccRpcDtoParam param){
        List<RmiOrgBankAccRpcVO> list = rmiOrgAddrService.findBankAccRpcDtoByParam(param);
        return ApiResult.ok(list);
    }

    @PostMapping(value = "/save")
    @ApiOperation(value = "收款单保存or提交")
    @ApiOperationSupport(order = 3)
    public ApiResult<Object> save(@RequestBody SalReceiptSaveParam param) {
        return salReceiptService.saveOrSubmit(param);
    }

    @GetMapping(value = "/{id}")
    @ApiOperation(value = "销售收款、退款单详情查询")
    @ApiOperationSupport(order = 2)
    public ApiResult<SalReceiptRespVO> getById(@PathVariable Long id) {
        SalReceiptRespVO result = salReceiptService.getById(id);
        return ApiResult.ok(result);
    }
}
