package com.elitesland.yst.production.sale.controller.search.store;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsStoreRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerSumRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsStoreSumRespVO;
import com.elitesland.yst.production.sale.search.service.StatisticsDealerSearchService;
import com.elitesland.yst.production.sale.search.store.bean.StatisticsStoreSearchBean;
import com.elitesland.yst.production.sale.search.store.service.StatisticsStoreSearchService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author wz
 * @Date 2023/07/07
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping("/statistics/store/app/search")
@RequiredArgsConstructor
@Api(value = "销售业绩统计-门店-APP端-beanSearch", tags = {"销售业绩统计-门店-APP端-beanSearch"})
public class StatisticsStoreAppSearchController {
    private final StatisticsStoreSearchService statisticsStoreSearchService;

    @PostMapping("/page")
    @ApiOperation("门店销售业绩分页查询")
    public ApiResult<PagingVO<SaleStatisticsStoreRespVO>> appPage(@RequestBody SaleStatisticsStoreQueryVO pageParam) {
        PagingVO<SaleStatisticsStoreRespVO> page = statisticsStoreSearchService.appPage(pageParam);
        return ApiResult.ok(page);
    }

    @PostMapping("/pageSum")
    @ApiOperation("门店销售业绩统计汇总")
    ApiResult<StatisticsStoreSumRespVO> appPageSum(@RequestBody SaleStatisticsStoreQueryVO pageParam) {
        return ApiResult.ok(statisticsStoreSearchService.appPageSum(pageParam));
    }

    @PostMapping("/details")
    @ApiOperation("门店销售业绩详情-头部信息和车型分页明细数据")
    public ApiResult<PagingVO<SaleStatisticsStoreRespVO>> appDetails(@RequestBody SaleStatisticsStoreQueryVO pageParam) {
        PagingVO<SaleStatisticsStoreRespVO> pagingVO = statisticsStoreSearchService.appDetails(pageParam);
        return ApiResult.ok(pagingVO).build();
    }
}
