package com.elitesland.yst.production.sale.controller.shop;

import com.elitesland.yst.production.sale.api.service.shop.BipMessageService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipMessageQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipMessageVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipFirstMessage;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipMessageSaveVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.val;

/**
 * <p>
 * 消息接口
 * </p>
 *
 * @author Shadow
 * @since 2021-08-24 09:17:30
 */
@RestController
@RequestMapping("/bip/message")
@Api(value = "消息", tags = {"消息"})
@RequiredArgsConstructor
public class BipMessageController {

    private final BipMessageService bipMessageService;

    /**
     * 分页查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条数据
     */
    @PostMapping("/search")
    @ApiOperation("分页查询")
    public ApiResult<PagingVO<BipMessageVO>> search(@RequestBody BipMessageQueryParamVO param) {
        val ret = bipMessageService.search(param);
        return ApiResult.ok(ret);
    }

    /**
     * 新增数据
     *
     * @param param 新增数据
     * @return 新增数据情况
     */
    @PostMapping("/createOne")
    @ApiOperation("新增数据")
    public ApiResult<Object> createOne(@RequestBody BipMessageSaveVO param) {
        return ApiResult.ok(bipMessageService.createOne(param));
    }

    /**
     * 修改数据
     *
     * @param param 修改对象
     * @return 修改数据详情
     */
    @PutMapping("/update")
    @ApiOperation("修改数据")
    public ApiResult<Object> update(@RequestBody BipMessageSaveVO param) {
        bipMessageService.update(param);
        return ApiResult.ok();
    }

    /**
     * 根据主键删除数据
     *
     * @param id 主键
     * @return 删除情况
     */
    @DeleteMapping("/deleteOne/{id}")
    @ApiOperation("根据主键删除数据")
    public ApiResult<Object> deleteOne(@PathVariable Long id) {
        bipMessageService.deleteOne(id);
        return ApiResult.ok();
    }

    @GetMapping("/first")
    @ApiOperation("获取用户最近一条消息")
    public ApiResult<BipFirstMessage> firstMessage(){
        return ApiResult.ok(bipMessageService.firstMessage());
    }

    @PostMapping("/allRead")
    @ApiOperation("清除全部未读")
    public ApiResult<String> allRead(){
        return bipMessageService.allRead();
    }

}


