package com.elitesland.yst.production.sale.controller.shop;

import com.alibaba.fastjson.JSONObject;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipOrderParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipOrderUserParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipOrderRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipAppOrderPayVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipAppOrderSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderSaveVO;
import com.elitesland.yst.production.sale.service.shop.BipOrderBackToOmsServiceimpl;
import com.elitesland.yst.production.sale.service.shop.BipOrderToOmsServiceimpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/20/10:03
 * @Description:
 */
@RestController
@RequestMapping(value = "/bip/order")
@Api(value = "订单主表",tags = "订单主表")
@Slf4j
public class BipOrderController {

    @Autowired
    private BipOrderService bipOrderService;
    @Autowired
    private BipOrderToOmsServiceimpl bipOrderToOmsServiceimpl;
    @Autowired
    private BipOrderBackToOmsServiceimpl bipOrderBackToOmsServiceimpl;

    @PostMapping("/page/search")
    @ApiOperation("分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<BipOrderRespVO>> findPageOrder(@RequestBody BipOrderParmVO bipOrderParmVO){
        return ApiResult.ok(bipOrderService.findPageOrder(bipOrderParmVO)) ;
    }


    @PostMapping("/save")
    @ApiOperation("订单保存")
    @ApiOperationSupport(order = 2)
    public ApiResult saveOrder(@RequestBody BipAppOrderSaveVO bipAppOrderSaveVO){
        Map hashMap=bipOrderService.saveOrder(bipAppOrderSaveVO);
        return ApiResult.ok(hashMap);
    }


    @GetMapping("/find")
    @ApiOperation("订单查询--根据id")
    @ApiOperationSupport(order = 3)
    public ApiResult<BipOrderRespVO> findOrderById(Long id ){
        BipOrderRespVO bipOrderRespVO=bipOrderService.findOrderById(id);
        return ApiResult.ok(bipOrderRespVO);
    }



    @PostMapping("/update")
    @ApiOperation("订单更新")
    @ApiOperationSupport(order = 4)
    public ApiResult updateOrder(@RequestBody BipOrderSaveVO bipOrderSaveVOS){
        bipOrderService.updateOrder(bipOrderSaveVOS);
        return ApiResult.ok() ;
    }



    @PostMapping("/delete/id")
    @ApiOperation("订单删除--通过id，支持批量")
    @ApiOperationSupport(order = 5)
    public ApiResult deleteOrderByIds(@RequestBody List<Long> ids){
        bipOrderService.deleteOrderByIds(ids);
        return ApiResult.ok() ;
    }

    @GetMapping ("/delete/{id}")
    @ApiOperation("订单删除--通过id，单个删除")
    @ApiOperationSupport(order = 5)
    public ApiResult deleteOrderById(@PathVariable Long id){
        List<Long> ids=new ArrayList<>();
        ids.add(id);
        bipOrderService.deleteOrderByIds(ids);
        return ApiResult.ok() ;
    }


    @PostMapping("/delete")
    @ApiOperation("订单删除")
    @ApiOperationSupport(order = 6)
    public ApiResult deleteOrder(@RequestBody List<BipOrderSaveVO> bipOrderSaveVOS){
        bipOrderService.deleteOrder(bipOrderSaveVOS);
        return ApiResult.ok() ;
    }

    @GetMapping ("/update/sign/{id}")
    @ApiOperation("订单签收")
    @ApiOperationSupport(order = 7)
    public ApiResult siginOrder(@PathVariable Long id){
        return bipOrderService.updateOrderSignStatus(id);
    }


    @PostMapping  ("/find/user")
    @ApiOperation("我的订单")
    @ApiOperationSupport(order = 8)
    public ApiResult<PagingVO<BipOrderRespVO>> findUserOrder(@RequestBody BipOrderUserParmVO bipOrderUserParmVO){
        PagingVO<BipOrderRespVO> pagingVO=bipOrderService.findUserOrder(bipOrderUserParmVO);
        return ApiResult.ok(pagingVO) ;
    }





    // PC端订单详情
    @GetMapping("/find/detail/{id}")
    @ApiOperation("订单详情查询")
    @ApiOperationSupport(order = 9)
    public ApiResult<BipOrderRespVO> findOrderDetailById(@PathVariable Long id ){
        BipOrderRespVO bipOrderRespVO=bipOrderService.findPolymerizeOrder(id);
        return ApiResult.ok(bipOrderRespVO);
    }


    @PostMapping("/cancle")
    @ApiOperation("订单取消")
    @ApiOperationSupport(order = 10)
    public ApiResult cancleOrder(@RequestBody BipOrderSaveVO bipOrderSaveVOS){
        bipOrderService.cancleOrder(bipOrderSaveVOS);
        return ApiResult.ok() ;
    }


    @GetMapping("/sendToOms/{id}/{syncOms}")
    @ApiOperation("同步订单到oms")
    @ApiOperationSupport(order = 11)
    public ApiResult sendToOms(@PathVariable Long id,@PathVariable Boolean syncOms){
        if(!syncOms){
            bipOrderToOmsServiceimpl.sendToOms(id);
        }
        return ApiResult.ok() ;
    }



    @PostMapping("/test/{id}")
    @ApiOperation("订单接入测试")
    @ApiOperationSupport(order = 11)
    public ApiResult test(@PathVariable Long id){
        bipOrderToOmsServiceimpl.sendToOms(id);
        return ApiResult.ok() ;
    }


    @PostMapping("/test/back")
    @ApiOperation("退货单接入测试")
    @ApiOperationSupport(order = 12)
    public ApiResult testBack(@RequestBody List<Long> ids){
        bipOrderBackToOmsServiceimpl.sendToOms(ids);
        return ApiResult.ok() ;
    }


    @PostMapping("/test/pay")
    @ApiOperation("支付接入测试")
    @ApiOperationSupport(order = 13)
    public ApiResult testPay(){
        BipAppOrderSaveVO bipAppOrderSaveVO=new BipAppOrderSaveVO();
        Map map=bipOrderService.saveOrder(bipAppOrderSaveVO);
        return ApiResult.ok(map) ;
    }


    @GetMapping  ("/find/user/{id}")
    @ApiOperation("订单详情")
    @ApiOperationSupport(order = 14)
    public ApiResult<BipOrderRespVO> findUserOrderDetail(@PathVariable Long id){
        BipOrderRespVO bipOrderRespVO=bipOrderService.findUserOrderDetail(id);
        return ApiResult.ok(bipOrderRespVO) ;
    }


    @PostMapping  ("/order/pay")
    @ApiOperation("订单详情")
    @ApiOperationSupport(order = 15)
    public ApiResult<Map> findUserOrderDetail(@RequestBody BipAppOrderPayVO bipAppOrderPayVO){
        Map map=bipOrderService.orderPay(bipAppOrderPayVO);
        return ApiResult.ok(map) ;
    }


    @GetMapping  ("/order/count/{userId}")
    @ApiOperation("订单详情")
    @ApiOperationSupport(order = 15)
    public ApiResult<JSONObject> findUserOrderCount(@PathVariable Long userId){
        JSONObject js = bipOrderService.findUserOrderCount(userId);
        return ApiResult.ok(js) ;
    }

}
