package com.elitesland.yst.production.sale.controller.statistics.pc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.SaleStatisticsService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsStoreRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsStoreSumRespVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author joker XingShixiang
 * @since 2021-09-01 14:43:56
 */
@RestController
@RequestMapping("/pc/statistics")
@Api(value = "销售业绩统计-门店", tags = {"销售业绩统计-门店"})
@RequiredArgsConstructor
@Slf4j
public class StatisticsFrontController {

    private final SaleStatisticsService saleStatisticsService;


    @PostMapping("/page")
    @ApiOperation("销售业绩统计-分页")
    ApiResult<PagingVO<SaleStatisticsStoreRespVO>> page(@RequestBody SaleStatisticsStoreQueryVO paramVO) {
        return ApiResult.ok(saleStatisticsService.pcPage(paramVO));
    }


    @PostMapping("/storeQuery")
    @ApiOperation("销售业绩统计-查询已发生交易的门店编码")
    ApiResult<List<String>> storeQuery(@RequestBody SaleStatisticsStoreQueryVO paramVO) {
        return ApiResult.ok(saleStatisticsService.storeQuery(paramVO));
    }


    @PostMapping("/pageSum")
    @ApiOperation("销售业绩统计-pc汇总")
    ApiResult<StatisticsStoreSumRespVO> pageSum(@RequestBody SaleStatisticsStoreQueryVO paramVO) {
        return ApiResult.ok(saleStatisticsService.querySum(paramVO));
    }


    @PostMapping("/updateRegion")
    @ApiOperation("销售业绩统计-更新区域")
    ApiResult<Object> updateRegion(@RequestBody List<Long> ids) {
        return ApiResult.ok(saleStatisticsService.updateRegion(ids));
    }

    @PostMapping("/updateSalesman")
    @ApiOperation("销售业绩统计-更新业务员路径")
    ApiResult<Object> updateSalesman(@RequestBody List<Long> ids) {
        return ApiResult.ok(saleStatisticsService.updateSalesman(ids));
    }



}


