package com.elitesland.yst.production.sale.controller.taskInfo;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.TaskInfoDtlService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.TaskInfoDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskExecuteRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoDtlRespVO;
import com.elitesland.yst.production.sale.api.vo.save.TaskInfoDtlSaveVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/13
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping(value = "/taskInfo/dtl", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "业务员任务明细", tags = {"业务员任务明细"})
@RequiredArgsConstructor
public class TaskInfoDtlController {

    private final TaskInfoDtlService taskInfoDtlService;

    @GetMapping("/execute/check/{id}")
    @ApiOperation("根据任务明细ID开始执行前置校验")
    public ApiResult<TaskExecuteRespVO> taskDtlExecuteCheck(@PathVariable Long id) {
        TaskExecuteRespVO taskExecuteRespVO = taskInfoDtlService.taskDtlExecuteCheck(id, true);
        return ApiResult.ok(taskExecuteRespVO);
    }

    @PostMapping("/close/check")
    @ApiOperation("根据任务明细ID批量关闭前置校验")
    public ApiResult<Boolean> closeCheckTaskBatch(@RequestBody List<Long> ids) {
        Boolean flag = taskInfoDtlService.closeCheckTaskBatch(ids);
        return ApiResult.ok(flag);
    }

    @PutMapping("/close")
    @ApiOperation("根据任务明细ID批量关闭")
    public ApiResult<List<Long>> closeTaskBatch(@RequestBody List<Long> ids) {
        taskInfoDtlService.closeTaskBatch(ids);
        return ApiResult.ok(ids);
    }

    @PostMapping("/del")
    @ApiOperation("根据任务明细ID批量关闭")
    public ApiResult<List<Long>> del(@RequestBody List<Long> ids) {
        taskInfoDtlService.del(ids);
        return ApiResult.ok(ids);
    }

    @PostMapping("/page")
    @ApiOperation("任务明细分页查询")
    public ApiResult<PagingVO<TaskInfoDtlRespVO>> page(@RequestBody TaskInfoDtlQueryVO pageParam) {
        PagingVO<TaskInfoDtlRespVO> page = taskInfoDtlService.page(pageParam);
        return ApiResult.ok(page);
    }

    @PostMapping(value = "/update/executeUser")
    @ApiOperation(value = "根据任务明细ID批量分配执行人")
    public ApiResult<List<Long>> updateExecuteUserBatch(@RequestBody @Validated TaskInfoDtlSaveVO saveVO) {
        List<Long> ids = taskInfoDtlService.updateExecuteUserBatch(saveVO);
        return ApiResult.ok(ids);
    }


    @PostMapping("/import")
    @ApiOperation("导入任务明细")
    @ApiImplicitParams(@ApiImplicitParam(name = "file", value = "导入数据的文件", required = true))
    public ApiResult<List<TaskInfoDtlRespVO>> importTaskInfoDtl(MultipartFile file) {
        List<TaskInfoDtlRespVO> dtlRespVOList = taskInfoDtlService.importTaskInfoDtl(file);
        return ApiResult.ok(dtlRespVOList);
    }


    @PostMapping("/importTaskDtl")
    @ApiOperation("导入任务明细")
    public ApiResult<Object> importTaskDtl(MultipartFile file,Long masId) {
        return taskInfoDtlService.importTaskDtl(file,masId);
    }

}
