package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/04/14:13
 * @Description:商品图库
 */

@Entity
@Table(name = "bip_item_pic", indexes = {
        @Index(name = "idx_bip_item_pic_item_id", columnList = "bip_item_id")
})
@org.hibernate.annotations.Table(appliesTo = "bip_item_pic", comment = "商品图片")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class BipItemPicDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 2890848781241765854L;

    @Column(name = "bip_item_id", columnDefinition = "bigint(20) not null comment '商品Id'")
    private Long bipItemId;

    @Column(name = "file_code", columnDefinition = "varchar(20) not null comment '文件的标识'")
    private String fileCode;

    @Column(name = "url", columnDefinition = "varchar(2048) not null comment '图片的可访问链接'")
    private String url;

    @Column(name = "pic", columnDefinition = "tinyint(1) default 0 comment '是否是图片'")
    private Boolean pic;

    @Column(name = "mime_type", columnDefinition = "varchar(128) not null comment '文件的mimeType'")
    private String mimeType;

    @Column(name = "file_size", columnDefinition = "bigint(20) default 0 comment '文件大小'")
    private Long fileSize;

    @Column(name = "file_name", columnDefinition = "varchar(256) default '' comment '文件名称'")
    private String fileName;

    @Column(name = "main", columnDefinition = "tinyint(1) default 0 comment '是否是主图'")
    private Boolean main;

    @Column(name = "sort_no", columnDefinition = "int(10) default 0 comment '顺序'")
    private Integer sortNo;
}
