package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

/**
 * 消息
 */
@Entity
@Table(name = "bip_message")
@org.hibernate.annotations.Table(appliesTo = "bip_message", comment = "消息")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "MESSAGE", description = "消息")
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class BipMessageDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 6738822276624372029L;

    @Column(name="ou_id" , columnDefinition = "bigint(20) comment 'ou_Id'")
    private Long ouId;

    @Column(name="ou_code" , columnDefinition = "varchar(40) comment 'ou code'")
    private String ouCode;

    @Column(name="ou_name" , columnDefinition = "varchar(40) comment 'ou name'")
    private String ouName;

    @Column(name="title" , columnDefinition = "varchar(40) comment '消息标题'")
    private String title;

    @Column(name="context" , columnDefinition = "varchar(100) comment '消息内容'")
    private String context;

    @Column(name="status" , columnDefinition = "varchar(40) comment '消息状态 '")
    private String status;

    @Column(name="to_cust_id" , columnDefinition = "bigint(20) comment '用户Id'")
    private Long toCustId;

    @ApiModelProperty("业务关联ID")
    @Column(name = "business_id", columnDefinition = "bigint(20)  comment '业务关联ID'")
    private Long businessId;

    @ApiModelProperty("业务类型")
    @Column(name = "business_type", columnDefinition = "varchar(20)  comment '业务类型'")
    private String businessType;

}

