package com.elitesland.yst.production.sale.entity;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.hibernate.annotations.Where;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-11
 * @desc : 执行记录模板明细表
 */
@Entity
@Table(name="exect_record_temp_dtl")
@org.hibernate.annotations.Table(appliesTo = "exect_record_temp_dtl", comment = "执行记录模板明细表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class ExectRecordTempDtlDO extends BaseModel {

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '关联id'")
    private Long masId;

    @Column(name = "name", columnDefinition = "varchar(255) comment '名称'")
    private String name;

    @Column(name = "type", columnDefinition = "varchar(255) comment '类型(文本/单选/多选/下拉/图片)'")
    private String type;

    @Column(name = "content", columnDefinition = "varchar(255) comment '内容'")
    private String content;

    @Column(name = "required_flag", columnDefinition = "tinyint(1) comment '是否必填'")
    private Boolean requiredFlag;

    @Column(name = "sort", columnDefinition = "int(11) comment '排序'")
    private Integer sort;


}