package com.elitesland.yst.production.sale.entity;


import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Created with IntelliJ IDEA.
 *
 * @Description:首单特惠商品
 */

@Entity
@Table(name = "first_special_item", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "first_special_item", comment = "首单特惠商品")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class FirstSpecialItemDO  extends BaseModel implements Serializable {

    @Column(name = "special_id", columnDefinition = "bigInt(20) not null  comment '主表ID'")
    private Long specialId;

    @Column(name = "ou_id", columnDefinition = "bigInt(20) not null  comment '公司id'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(32)   comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(32)    comment '公司名称'")
    private String ouName;

    @Column(name = "sku_id", columnDefinition = "bigInt(20) not null  comment 'skuid'")
    private Long skuId;

    @Column(name = "sku_name", columnDefinition = "varchar(32)    comment 'skuName'")
    private String skuName;

    @Column(name = "sku_code", columnDefinition = "varchar(256)  comment 'skuCode'")
    private String skuCode;

    @Column(name = "base_price", columnDefinition = "decimal(20,4)    comment '基础价格'")
    private BigDecimal basePrice;

    @Column(name = "preferential_price", columnDefinition = "decimal(20,4)    comment '特惠价格'")
    private BigDecimal preferentialPrice;


}
