package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 折扣满减赠详情实体类
 * </p>
 *
 * @author ssy
 * @since 2021/8/23
 */
@Entity
@Table(name = "mkt_discount_gift_d")
@org.hibernate.annotations.Table(appliesTo = "mkt_discount_gift_d", comment = "折扣满减赠明细表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class MktDiscountGiftDDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -4537876816096441285L;

    @Column(name = "mkt_discount_gift_id", columnDefinition = "bigInt(20)   comment '折扣满赠送id'")
    private Long mktDiscountGiftId;

    @Column(name = "item_id", columnDefinition = "bigInt(20)   comment '商品id'")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(40)   comment '商品code'")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(255)   comment '商品名称'")
    private String itemName;

    @Column(name = "item_attr", columnDefinition = "varchar(255)   comment '商品规格'")
    private String itemAttr;

    @Column(name = "uom", columnDefinition = "varchar(40)   comment '计量单位'")
    private String uom;

    @Column(name = "limit_amt", columnDefinition = "decimal(20,2)   comment '满赠达标金额'")
    private BigDecimal limitAmt;

    @Column(name = "limit_num", columnDefinition = "bigInt(20)   comment '满赠达标数量'")
    private Long limitNum;

    @Column(name = "discount_gift_code", columnDefinition = "varchar(40)  comment '折扣编码'")
    private String discountGiftCode;
}
