package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author Danny.Wang
 * @title SalesmanRegion
 * @Date2023/4/11 14:00
 */

@Entity
@Table(name = "salesman_region")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "salesman_region", comment = "业务员关联区域表")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Data
@Accessors(chain = true)
@ApiModel(value = "salesman_region", description = "业务员关联区域表")
public class SalesmanRegionDO extends BaseModel implements Serializable {

    @ApiModelProperty("业务员主表id")
    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '业务员主表id'")
    private Long masId;

    @ApiModelProperty("区域id")
    @Column(name = "region_id", columnDefinition = "bigint(20) comment '区域id'")
    private Long regionId;

    @ApiModelProperty("区域code")
    @Column(name = "region_code", columnDefinition = "varchar(20) comment '区域code'")
    private String regionCode;

    @ApiModelProperty("区域名称")
    @Column(name = "region_name", columnDefinition = "varchar(20) comment '区域名称'")
    private String regionName;

}
