package com.elitesland.yst.production.sale.ext.cpcn.resp;

import lombok.Data;

/**
 * @author yifansir(jin yan qiang)
 * @date 2021/8/4
 */
@Data
public class CPCN4658Req {
    /**
     * 机构编号
     */
    private String institutionID;
    /**
     * 原业务流水号
     */
    private String sourceTxSN;
    /**
     * 原业务交易编码
     */
    private String sourceTxCode;
    /**
     * 交易金额(单位:元)
     */
    private String amount;
    /**
     * 交易状态:
     * 30=成功
     * 40=失败
     */
    private String status;
    /**
     * 用户ID
     */
    private String userID;
    /**
     * 支付方式:
     * 10=快捷支付
     * 20=网银支付
     * 40=聚合支付
     * 50=转账充值
     * 80=跳转支付
     */
    private String paymentWay;
    /**
     * 实际支付方式
     */
    private String actualPaymentWay;
    /**
     * 实际支付类型
     */
    private String actualPaymentType;
    /**
     * 响应时间
     */
    private String responseTime;
    /**
     * 响应码
     */
    private String responseCode;
    /**
     * 响应消息
     */
    private String responseMessage;
    /**
     * 绑定银行卡流水号
     */
    private String bindingTxSN;
    /**
     * 提现方式
     */
    private String withdrawalType;
    /**
     * 备注
     */
    private String remark;
    /**
     * 银行卡类型
     */
    private String cardType;
    /**
     * 付款人账户号码
     */
    private String payerBankAccountNumber;
    /**
     * 付款人账户名称
     */
    private String payerBankAccountName;
    /**
     * 收款人账户号码
     */
    private String payeeBankAccountNumber;
    /**
     * 收款人账户名称
     */
    private String payeeBankAccountName;
}
