package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.SalAcceptanceDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-21 17:06
 */
public interface SalAcceptanceRepo extends JpaRepository<SalAcceptanceDO, Long>, QuerydslPredicateExecutor<SalAcceptanceDO> {

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update SalAcceptanceDO set procInstId = ?2 where id = ?1")
    void updateProcInstId(Long id,Long procInstId);
}
