package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionRuleCreateParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionRuleParam;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalCommissionRuleVO;
import com.elitesland.yst.production.sale.entity.QSalCommissionRuleDO;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.util.StringUtils;

import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import lombok.val;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Shadow
 * @since 2021-11-22 19:19:55
 */
@Component
@RequiredArgsConstructor
public class SalCommissionRuleRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    /**
     * 查询字段
     */
    public JPAQuery<SalCommissionRuleVO> select(SalCommissionRuleParam param) {
        QSalCommissionRuleDO jpaQDo = QSalCommissionRuleDO.salCommissionRuleDO;
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        JPAQuery<SalCommissionRuleVO> jpaQuery = jpaQueryFactory.select(Projections.bean(SalCommissionRuleVO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.ouCode,
                jpaQDo.ouName,
                jpaQDo.itemCateCode,
                jpaQDo.itemId,
                jpaQDo.itemCode,
                jpaQDo.itemName,
                jpaQDo.commissionRule,
                jpaQDo.percentage,
                jpaQDo.pieceWage,
                jpaQDo.tenantId,
                jpaQDo.remark,
                jpaQDo.createUserId,
                jpaQDo.creator,
                jpaQDo.createTime,
                jpaQDo.modifyUserId,
                jpaQDo.updater,
                jpaQDo.modifyTime,
                jpaQDo.deleteFlag,
                jpaQDo.auditDataVersion,
                jpaQDo.secBuId,
                jpaQDo.secUserId,
                jpaQDo.secOuId
        )).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     */
    public Predicate where(Long id) {
        val jpaQDo = QSalCommissionRuleDO.salCommissionRuleDO;
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        ExpressionUtils.and(predicate, jpaQDo.id.eq(id));
        return predicate;
    }

    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(SalCommissionRuleParam param) {
        val jpaQDo = QSalCommissionRuleDO.salCommissionRuleDO;
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (param.getIds()!=null&&param.getIds().size()>0) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.in(param.getIds()));
        }
        if (!StringUtils.isEmpty(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.eq(param.getOuId()));
        }
        if (!StringUtils.isEmpty(param.getOuCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouCode.eq(param.getOuCode()));
        }
        if (!StringUtils.isEmpty(param.getOuName())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouName.eq(param.getOuName()));
        }
        if (!StringUtils.isEmpty(param.getItemCateCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemCateCode.eq(param.getItemCateCode()));
        }
        if (!StringUtils.isEmpty(param.getItemId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemId.eq(param.getItemId()));
        }
        if (!StringUtils.isEmpty(param.getItemCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemCode.eq(param.getItemCode()));
        }
        if (!StringUtils.isEmpty(param.getItemName())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemName.eq(param.getItemName()));
        }
        if (!StringUtils.isEmpty(param.getCommissionRule())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.commissionRule.eq(param.getCommissionRule()));
        }
        if (!StringUtils.isEmpty(param.getPercentage())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.percentage.eq(param.getPercentage()));
        }
        if (!StringUtils.isEmpty(param.getPieceWage())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.pieceWage.eq(param.getPieceWage()));
        }
        return predicate;
    }

    /**
     * 校验唯一性
     * @param param 参数
     * @return true：已重复
     */
    public List<SalCommissionRuleVO> checkUnique(SalCommissionRuleCreateParam param){
        SalCommissionRuleParam qParam = new SalCommissionRuleParam();
        qParam.setOuId(param.getOuId());
        qParam.setItemCode(param.getItemCode());
        qParam.setItemCateCode(param.getItemCateCode());

        return select(qParam).fetch();
    }

    public List<SalCommissionRuleVO> findUnique(String ouCode, String itemCode, String itemCateCode){
        SalCommissionRuleParam qParam = new SalCommissionRuleParam();
        qParam.setOuCode(ouCode);
        qParam.setItemCode(itemCode);
        qParam.setItemCateCode(itemCateCode);

        return select(qParam).fetch();
    }
}

