package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.entity.BipCompanyManageDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/9/27 10:06
 */
public interface BipCompanyManageRepo extends JpaRepository<BipCompanyManageDO, Long>, QuerydslPredicateExecutor<BipCompanyManageDO> {


    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update bip_company_manage set view_ou_status = ?1 where id in ?2", nativeQuery = true)
    void updateCompanyStatus(Boolean viewStatus, List<Long> ids);

    List<BipCompanyManageDO> findAllByOuIdIn(List<Long> ids);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update bip_company_manage set delete_flag = ?1 where id in ?2", nativeQuery = true)
    void updateCompanyDeleteFlag(Long deFlag,List<Long> ids);

}
