package com.elitesland.yst.production.sale.repo.shop;


import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouponVO;
import com.elitesland.yst.production.sale.entity.*;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import jodd.util.StringUtil;
import org.springframework.util.StringUtils;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import lombok.val;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author Shadow
 * @since 2021-08-11 09:22:51
 */
@Component
@RequiredArgsConstructor
public class BipCouponRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QBipCouponDO qBipCouponDO = QBipCouponDO.bipCouponDO;

    private final QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;

    /**
     * 查询字段
     */
    public JPAQuery<BipCouponVO> select(BipCouponQueryParamVO param) {
        QBipCouponDO jpaQDo = QBipCouponDO.bipCouponDO;
        Predicate predicate = jpaQDo.isNotNull();
        JPAQuery<BipCouponVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BipCouponVO.class,
                jpaQDo.id,
                jpaQDo.couponCode,
                jpaQDo.type,
                jpaQDo.ouId,
                jpaQDo.ouCode,
                jpaQDo.ouName,
                jpaQDo.totalNum,
                jpaQDo.custLevel,
                jpaQDo.limitAmt,
                jpaQDo.freeAmt,
                jpaQDo.state,
                jpaQDo.notifyDays,
                jpaQDo.notifyTime,
                jpaQDo.matchType,
                jpaQDo.matchIds,
                jpaQDo.detailInfo,
                jpaQDo.specialAreaShow,
                jpaQDo.specialAreaStime,
                jpaQDo.specialAreaEtime,
                jpaQDo.indexPageShow,
                jpaQDo.newCustShow,
                jpaQDo.newCustStime,
                jpaQDo.newCustEtime,
                jpaQDo.validStime,
                jpaQDo.validEtime,
                jpaQDo.tenantId,
                jpaQDo.remark,
                jpaQDo.createUserId,
                jpaQDo.creator,
                jpaQDo.createTime,
                jpaQDo.modifyUserId,
                jpaQDo.updater,
                jpaQDo.modifyTime,
                jpaQDo.deleteFlag,
                jpaQDo.auditDataVersion,
                jpaQDo.secBuId,
                jpaQDo.secUserId,
                jpaQDo.secOuId
        )).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     */
    public Predicate where(Long id) {
        val jpaQDo = QBipCouponDO.bipCouponDO;
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        ExpressionUtils.and(predicate, jpaQDo.id.eq(id));
        return predicate;
    }

    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(BipCouponQueryParamVO param) {
        val jpaQDo = QBipCouponDO.bipCouponDO;
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (!StringUtils.isEmpty(param.getCouponCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.couponCode.eq(param.getCouponCode()));
        }
        if (!StringUtils.isEmpty(param.getType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.type.eq(param.getType()));
        }
        if (!StringUtils.isEmpty(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.eq(param.getOuId()));
        }
        if (!StringUtils.isEmpty(param.getOuCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouCode.eq(param.getOuCode()));
        }
        if (!StringUtils.isEmpty(param.getOuName())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouName.eq(param.getOuName()));
        }
        if (!StringUtils.isEmpty(param.getCustLevel())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.custLevel.eq(param.getCustLevel()));
        }
        if (!StringUtils.isEmpty(param.getLimitAmt())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.limitAmt.eq(param.getLimitAmt()));
        }
        if (!StringUtils.isEmpty(param.getFreeAmt())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.freeAmt.eq(param.getFreeAmt()));
        }
        if (!StringUtils.isEmpty(param.getState())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.state.eq(param.getState()));
        }
        if (!StringUtils.isEmpty(param.getNotifyDays())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.notifyDays.eq(param.getNotifyDays()));
        }
        if (!StringUtils.isEmpty(param.getNotifyTime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.notifyTime.eq(param.getNotifyTime()));
        }
        if (!StringUtils.isEmpty(param.getMatchType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.matchType.eq(param.getMatchType()));
        }
        if (!StringUtils.isEmpty(param.getMatchIds())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.matchIds.eq(param.getMatchIds()));
        }
        if (!StringUtils.isEmpty(param.getDetailInfo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.detailInfo.eq(param.getDetailInfo()));
        }
        if (!StringUtils.isEmpty(param.getSpecialAreaShow())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.specialAreaShow.eq(param.getSpecialAreaShow()));
        }
        if (!StringUtils.isEmpty(param.getSpecialAreaStime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.specialAreaStime.eq(param.getSpecialAreaStime()));
        }
        if (!StringUtils.isEmpty(param.getSpecialAreaEtime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.specialAreaEtime.eq(param.getSpecialAreaEtime()));
        }
        if (!StringUtils.isEmpty(param.getIndexPageShow())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.indexPageShow.eq(param.getIndexPageShow()));
        }
        if (!StringUtils.isEmpty(param.getNewCustShow())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.newCustShow.eq(param.getNewCustShow()));
        }
        if (!StringUtils.isEmpty(param.getNewCustStime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.newCustStime.eq(param.getNewCustStime()));
        }
        if (!StringUtils.isEmpty(param.getNewCustEtime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.newCustEtime.eq(param.getNewCustEtime()));
        }

        predicate = ExpressionUtils.and(predicate, jpaQDo.validStime.before(LocalDateTime.now()));
        predicate = ExpressionUtils.and(predicate, jpaQDo.receiveValidStime.before(LocalDateTime.now()));
        predicate = ExpressionUtils.and(predicate, jpaQDo.validEtime.after(LocalDateTime.now()));
        predicate = ExpressionUtils.and(predicate, jpaQDo.receiveValidEtime.after(LocalDateTime.now()));
        predicate = ExpressionUtils.and(predicate, jpaQDo.totalNum.gt(0));

        return predicate;
    }


    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate whereAll(BipCouponQueryParamVO param) {
        val jpaQDo = QBipCouponDO.bipCouponDO;
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (!StringUtils.isEmpty(param.getCouponCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.couponCode.eq(param.getCouponCode()));
        }
        if (!StringUtils.isEmpty(param.getType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.type.eq(param.getType()));
        }
        if (!StringUtils.isEmpty(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.eq(param.getOuId()));
        }
        if (!StringUtils.isEmpty(param.getOuCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouCode.eq(param.getOuCode()));
        }
        if (!StringUtils.isEmpty(param.getOuName())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouName.eq(param.getOuName()));
        }
        if (!StringUtils.isEmpty(param.getTotalNum())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.totalNum.eq(param.getTotalNum()));
        }
        if (!StringUtils.isEmpty(param.getCustLevel())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.custLevel.eq(param.getCustLevel()));
        }
        if (!StringUtils.isEmpty(param.getLimitAmt())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.limitAmt.eq(param.getLimitAmt()));
        }
        if (!StringUtils.isEmpty(param.getFreeAmt())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.freeAmt.eq(param.getFreeAmt()));
        }
        if (!StringUtils.isEmpty(param.getState())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.state.eq(param.getState()));
        }
        if (!StringUtils.isEmpty(param.getNotifyDays())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.notifyDays.eq(param.getNotifyDays()));
        }
        if (!StringUtils.isEmpty(param.getNotifyTime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.notifyTime.eq(param.getNotifyTime()));
        }
        if (!StringUtils.isEmpty(param.getMatchType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.matchType.eq(param.getMatchType()));
        }
        if (!StringUtils.isEmpty(param.getMatchIds())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.matchIds.eq(param.getMatchIds()));
        }
        if (!StringUtils.isEmpty(param.getDetailInfo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.detailInfo.eq(param.getDetailInfo()));
        }
        if (!StringUtils.isEmpty(param.getSpecialAreaShow())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.specialAreaShow.eq(param.getSpecialAreaShow()));
        }
        if (!StringUtils.isEmpty(param.getSpecialAreaStime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.specialAreaStime.eq(param.getSpecialAreaStime()));
        }
        if (!StringUtils.isEmpty(param.getSpecialAreaEtime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.specialAreaEtime.eq(param.getSpecialAreaEtime()));
        }
        if (!StringUtils.isEmpty(param.getIndexPageShow())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.indexPageShow.eq(param.getIndexPageShow()));
        }
        if (!StringUtils.isEmpty(param.getNewCustShow())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.newCustShow.eq(param.getNewCustShow()));
        }
        if (!StringUtils.isEmpty(param.getNewCustStime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.newCustStime.eq(param.getNewCustStime()));
        }
        if (!StringUtils.isEmpty(param.getNewCustEtime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.newCustEtime.eq(param.getNewCustEtime()));
        }
        if (!StringUtils.isEmpty(param.getValidStime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.validStime.eq(param.getValidStime())
                    .or(jpaQDo.validStime.after(param.getValidStime())));
        }
        if(!StringUtils.isEmpty(param.getValidEtime())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.validEtime.eq(param.getValidEtime())
                    .or(jpaQDo.validEtime.before(param.getValidEtime())));
        }
        predicate = ExpressionUtils.and(predicate,DataAuthJpaUtil.dataAuthJpaPredicate(jpaQDo.getMetadata()));
        return predicate;
    }

}

