package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.api.vo.param.shop.MktGiftQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktGiftRespVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.entity.MktGiftDO;
import com.elitesland.yst.production.sale.entity.QMktGiftDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 赠品 proc
 * </p>
 *
 * @author ssy
 * @since 2021/8/23
 */
@Repository
public class MktGiftRepoProc {

    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    private final QMktGiftDO qMktGiftDO = QMktGiftDO.mktGiftDO;

    /**
     * 查询主表
     *
     * @param queryParam 查询条件,可为空
     * @return jpaQuery
     */
    public JPAQuery<MktGiftRespVO> select(MktGiftQueryVO queryParam) {
        JPAQuery<MktGiftRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(MktGiftRespVO.class,
                qMktGiftDO.id, qMktGiftDO.itemId, qMktGiftDO.itemCode, qMktGiftDO.itemName,
                qMktGiftDO.validStime, qMktGiftDO.validEtime, qMktGiftDO.stockNum, qMktGiftDO.discountGiftItemId,
                qMktGiftDO.discountGiftCode
        ))
                .from(qMktGiftDO)
                .where(qMktGiftDO.deleteFlag.eq(ConstantsSale.COMMON_DELETE_NO))
                // .where(DataAuthJpaUtil.dataAuthJpaPredicate(qMktGiftDO.getMetadata())) //数据权限
                ;
        if (queryParam != null) {
            jpaQuery.where(buildCondition(queryParam));
        }
        return jpaQuery;
    }

    /**
     * 查询条件
     *
     * @param queryParam 查询条件
     * @return predicate
     */
    private Predicate buildCondition(MktGiftQueryVO queryParam) {
        Predicate predicate = qMktGiftDO.isNotNull();
        if (!StringUtils.isEmpty(queryParam.getDiscountGiftCode())) {
            predicate = ExpressionUtils.and(predicate, qMktGiftDO.discountGiftItemId.eq(queryParam.getDiscountGiftItemId()));
        }
        if (queryParam.getDiscountGiftItemId() != null) {
            predicate = ExpressionUtils.and(predicate, qMktGiftDO.discountGiftItemId.eq(queryParam.getDiscountGiftItemId()));
        }
        if (queryParam.getItemId() != null) {
            predicate = ExpressionUtils.and(predicate, qMktGiftDO.itemId.eq(queryParam.getItemId()));
        }
        if (!StringUtils.isEmpty(queryParam.getItemCode())) {
            predicate = ExpressionUtils.and(predicate, qMktGiftDO.itemCode.like("%" + queryParam.getItemCode() + "%"));
        }
        if (!StringUtils.isEmpty(queryParam.getItemName())) {
            predicate = ExpressionUtils.and(predicate, qMktGiftDO.itemName.like("%" + queryParam.getItemName() + "%"));
        }
        if (!StringUtils.isEmpty(queryParam.getValidStime())) {
            predicate = ExpressionUtils.and(predicate, qMktGiftDO.validStime.eq(queryParam.getValidStime())
                    .or(qMktGiftDO.validStime.after(queryParam.getValidStime())));
        }
        if (!StringUtils.isEmpty(queryParam.getValidEtime())) {
            predicate = ExpressionUtils.and(predicate, qMktGiftDO.validEtime.eq(queryParam.getValidEtime())
                    .or(qMktGiftDO.validEtime.before(queryParam.getValidEtime())));
        }
        return predicate;
    }

//    /**
//     * 校验  有效的时间区间内，是否存在相同的商品
//     *
//     * @param masId      可为null
//     * @param validStime 生效日期
//     * @param validEtime 失效日期
//     * @param itemIds    商品集合
//     * @return 重复的商品编码
//     */
//    public List<String> checkItemExitsInValidDate(Long masId, LocalDateTime validStime, LocalDateTime validEtime, List<Long> itemIds) {
//        JPAQuery<String> jpaQuery = jpaQueryFactory.select(qMktGiftDO.itemCode).distinct()
//                .from(qMktGiftDO)
//                .where(qMktGiftDO.deleteFlag.eq(ConstantsSale.COMMON_DELETE_NO))
//                .where(qMktGiftDO.itemId.in(itemIds))
//                .where(qMktGiftDO.validStime.between(validStime, validEtime)
//                        .or(qMktGiftDO.validEtime.between(validStime, validEtime))
//                        .or(qMktGiftDO.validStime.before(validStime).and(qMktGiftDO.validEtime.after(validEtime)))
//                );
//        if (masId != null) {
//            jpaQuery.where(qMktGiftDO.id.ne(masId));
//        }
//        return jpaQuery.fetch();
//    }

    public MktGiftDO findByCode(String code){
        return jpaQueryFactory.select(qMktGiftDO).from(qMktGiftDO).where(qMktGiftDO.itemCode.eq(code)).limit(1).fetchOne();
    }

    public List<MktGiftDO> findByCodes(List<String> codes){
        return jpaQueryFactory.select(qMktGiftDO).from(qMktGiftDO).where(qMktGiftDO.itemCode.in(codes)).fetch();
    }

    public List<MktGiftDO> findByMktCodes(List<String> codes){
        if (codes==null || codes.size()==0){
            return new ArrayList<>();
        }

        return jpaQueryFactory.select(qMktGiftDO)
                .from(qMktGiftDO)

                .fetch();
    }

    public List<String> findDiscountCode(String giftCode){

        if (giftCode==null){
            return new ArrayList<>();
        }

        return jpaQueryFactory.select(qMktGiftDO.discountGiftCode)
                .from(qMktGiftDO)
                .where(qMktGiftDO.itemCode.like("%"+giftCode+"%"))
                .fetch();
    }
}
