package com.elitesland.yst.production.sale.rmi.ystsupport;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.org.dto.OrgBuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgBuRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.service.OrgBuRpcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/3 10:27
 */
@Slf4j
@Component
public class RmiOrgBuService {

    @Autowired
    private OrgBuRpcService orgBuRpcService;

    public List<OrgBuRpcDTO> findBuDtoByParam(OrgBuRpcDtoParam param){
        try {
            List<OrgBuRpcDTO> orgBuRpcDTOS = orgBuRpcService.findBuDtoByParam(param);
            return CollUtil.isNotEmpty(orgBuRpcDTOS) ? orgBuRpcDTOS : new ArrayList<>(0);
        } catch (Exception e) {
            log.error("远程调用支撑域bu经销商相关服务异常:{}", e.getMessage());
            throw new BusinessException("远程调用支撑域bu经销商查询相关服务异常"+e,e);
        }
    }

    public List<OrgBuRpcDTO> findBuDtoList(List<Long> buIds, List<String> buCodes) {
        var orgBuRpcDtoParam = new OrgBuRpcDtoParam();
        orgBuRpcDtoParam.setBuIds(buIds);
        orgBuRpcDtoParam.setBuCodes(buCodes);
        return this.findBuDtoByParam(orgBuRpcDtoParam);
    }
}
