package com.elitesland.yst.production.sale.rmi.ystsupport;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
//import com.elitesland.yst.production.support.consumer.pri.dto.PriMainPriceRpcDTO;
//import com.elitesland.yst.production.support.consumer.pri.param.PriMainPriceRpcDtoParam;
//import com.elitesland.yst.production.support.consumer.pri.service.PriMainPriceRpcService;
import com.elitesland.yst.production.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.yst.production.support.provider.price.dto.PriMainPriceRpcDTO;
import com.elitesland.yst.production.support.provider.price.param.PriMainPriceRpcDtoParam;
import com.elitesland.yst.production.support.provider.price.service.PriMainPriceRpcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-13 16:09:59
 */
@Component
@Slf4j
public class RmiPriMainPriceService {

    @Autowired
    private PriMainPriceRpcService priMainPriceRpcService;

    public List<PriMainPriceRpcDTO> findMainPriceDtoList(List<Long> ids, List<String> codes) {
        if (CollUtil.isEmpty(ids) && CollUtil.isEmpty(codes)) {
            return new ArrayList<>(0);
        }
        PriMainPriceRpcDtoParam priMainPriceRpcDtoParam = new PriMainPriceRpcDtoParam();
        priMainPriceRpcDtoParam.setItemIds(ids);
        priMainPriceRpcDtoParam.setItemCodes(codes);
        return this.findMainPriceRpcDtoByParam(priMainPriceRpcDtoParam);
    }

    public List<PriMainPriceRpcDTO> findMainPriceRpcDtoByParam(PriMainPriceRpcDtoParam param) {
        try {
            return priMainPriceRpcService.findMainPriceRpcDtoByParam(param);
        }catch (Exception e) {
            log.error("远程调用支撑域商品主价格相关服务异常:{}", e.getMessage());
            throw new BusinessException("远程调用支撑域商品主价格相关服务异常"+e,e);
        }
    }

}
