package com.elitesland.yst.production.sale.service;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.sale.api.service.SalCommissionRuleService;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionBatchParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionRuleCreateParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionRuleImportVO;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionRuleParam;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalCommissionRuleVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.SalCommissionRuleConvert;
import com.elitesland.yst.production.sale.entity.QSalCommissionRuleDO;
import com.elitesland.yst.production.sale.entity.SalCommissionRuleDO;
import com.elitesland.yst.production.sale.repo.SalCommissionRuleRepo;
import com.elitesland.yst.production.sale.repo.SalCommissionRuleRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 提成规则实现类
 * </p>
 *
 * @author Shadow
 * @since 2021-11-22 19:19:53
 */
@Service
@RequiredArgsConstructor
public class SalCommissionRuleServiceImpl implements SalCommissionRuleService {

//    private final RmiItemService rmiItemService;
    private final RmiOrgOuService rmiOrgOuService;
    private final SalCommissionRuleRepo salCommissionRuleRepo;
    private final SalCommissionRuleRepoProc salCommissionRuleRepoProc;

    private final String RETURN = UdcEnum.SAL_COMMISSION_RULE_RETURN.getValueCode();
    private final String PROFIT = UdcEnum.SAL_COMMISSION_RULE_PROFIT.getValueCode();
    private final String PIECE = UdcEnum.SAL_COMMISSION_RULE_PIECE.getValueCode();

    private final Map<String, String> ruleMap = new HashMap<>();{
        ruleMap.put(RETURN, UdcEnum.SAL_COMMISSION_RULE_RETURN.getValueCodeName());
        ruleMap.put(PROFIT, UdcEnum.SAL_COMMISSION_RULE_PROFIT.getValueCodeName());
        ruleMap.put(PIECE, UdcEnum.SAL_COMMISSION_RULE_PIECE.getValueCodeName());
    }

    private final Map<String, String> ruleNameMap = new HashMap<>();{
        ruleNameMap.put(UdcEnum.SAL_COMMISSION_RULE_RETURN.getValueCodeName(), RETURN);
        ruleNameMap.put(UdcEnum.SAL_COMMISSION_RULE_PROFIT.getValueCodeName(), PROFIT);
        ruleNameMap.put(UdcEnum.SAL_COMMISSION_RULE_PIECE.getValueCodeName(), PIECE);
    }

    @Override
    public ApiResult<SalCommissionRuleVO> findIdOne(Long id) {
//        Optional<SalCommissionRuleVO> ruleVO = salCommissionRuleRepo.findById(id).map(SalCommissionRuleConvert.INSTANCE::doToVO);
//        if (ruleVO.isPresent()) {
//            SalCommissionRuleVO vo = ruleVO.get();
//
//            // 设置规则名称
//            vo.setCommissionRuleName(ruleMap.get(vo.getCommissionRule()));
//
//            if (StringUtils.isNotBlank(vo.getItemCateCode())) {
//                ItmItemCateCodeParam param = new ItmItemCateCodeParam();
//                param.setItemCateCodes(Collections.singletonList(vo.getItemCateCode()));
//                Map<String, ItmCateCodeAndNameRpcDTO> itemCateCodeMap = rmiItemService.findCateCodeReItemCateCode(param).getCateMap();
//
//                ItmCateCodeAndNameRpcDTO codeAndNameRpcDTO = itemCateCodeMap.get(vo.getItemCateCode());
//
//                // 设置品类名称
//                if (codeAndNameRpcDTO != null) {
//                    List<SalCommissionRuleVO.Category> categories = new ArrayList<>();
//                    List<String> codeList = codeAndNameRpcDTO.getCateCodeList();
//                    List<String> nameList = codeAndNameRpcDTO.getCateNameList();
//                    for (int i = 0; i < codeList.size(); i++) {
//                        SalCommissionRuleVO.Category category = new SalCommissionRuleVO.Category();
//                        category.setCode(codeList.get(i));
//                        category.setName(nameList.get(i));
//                        categories.add(category);
//                    }
//                    vo.setCategories(categories);
//                    vo.setCateCodeName(String.join("/", nameList));
//                }
//
//            }

//            return ApiResult.ok(vo);
//
//        }
//
//        return ApiResult.fail(ApiCode.NOT_FOUND);
    return ApiResult.ok();
    }

    @Override
    public PagingVO<SalCommissionRuleVO> search(SalCommissionRuleParam param) {
//
//        val ret = salCommissionRuleRepo.findAll(salCommissionRuleRepoProc.where(param), param.getPageRequest());
//        val vos = ret.getContent().stream().map(SalCommissionRuleConvert.INSTANCE::doToVO).collect(Collectors.toList());
//
//        // 过滤出品类code
//        Map<String, ItmCateCodeAndNameRpcDTO> cateMap = null;
//        List<String> codeListParam = vos.stream()
//                .map(SalCommissionRuleVO::getItemCateCode)
//                .distinct()
//                .filter(StringUtils::isNotBlank)
//                .collect(Collectors.toList());
//
//        // 获取品类名称
//        if (codeListParam.size() > 0) {
//            ItmItemCateCodeParam codeParam = new ItmItemCateCodeParam();
//            codeParam.setItemCateCodes(codeListParam);
//            cateMap = rmiItemService.findCateCodeReItemCateCode(codeParam).getCateMap();
//        }
//
//        for (SalCommissionRuleVO vo : vos) {
//            // 设置品类名称
//            if (cateMap != null) {
//                ItmCateCodeAndNameRpcDTO codeAndNameRpcDTO = cateMap.get(vo.getItemCateCode());
//                if (codeAndNameRpcDTO != null) {
//                    List<SalCommissionRuleVO.Category> categories = new ArrayList<>();
//                    List<String> codeList = codeAndNameRpcDTO.getCateCodeList();
//                    List<String> nameList = codeAndNameRpcDTO.getCateNameList();
//                    for (int i = 0; i < codeList.size(); i++) {
//                        SalCommissionRuleVO.Category category = new SalCommissionRuleVO.Category();
//                        category.setCode(codeList.get(i));
//                        category.setName(nameList.get(i));
//                        categories.add(category);
//                    }
//                    vo.setCategories(categories);
//                    vo.setCateCodeName(String.join("/", nameList));
//                }
//            }
//            // 为导出设置创建日期
//            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
//            vo.setCreateDate(vo.getCreateTime().toLocalDate().format(formatter));
//
//            // 设置规则名称
//            vo.setCommissionRuleName(ruleMap.get(vo.getCommissionRule()));
//        }
//
//        return PagingVO.<SalCommissionRuleVO>builder()
//                .total(ret.getTotalElements())
//                .records(vos)
//                .build();
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long createOne(SalCommissionRuleCreateParam param) {

        // 校验创建参数是否正确
        if (StringUtils.isEmpty(param.getItemCode()) && StringUtils.isEmpty(param.getItemCateCode())) {
            throw new BusinessException("请输入商品信息！");
        }

        if ((!StringUtils.isEmpty(param.getItemCode())) && (!StringUtils.isEmpty(param.getItemCateCode()))) {
            throw new BusinessException("商品编码和商品品类不能同时选择！");
        }

        if (StringUtils.isEmpty(param.getCommissionRule())) {
            throw new BusinessException("提成规则不能为空！");
        }

        // 校验规则信息
        if (PIECE.equals(param.getCommissionRule())) {
            Assert.notNull(param.getPieceWage(), "选择计件规则时，计件提成必填！");
            Assert.isNull(param.getPercentage(), "选择计件规则时，不能填写提成百分比！");
            Assert.isTrue(BigDecimal.ZERO.compareTo(param.getPieceWage()) < 0, "选择机件规则时，计件提成必须大于0！");
        } else if (RETURN.equals(param.getCommissionRule())
                || PROFIT.equals(param.getCommissionRule())) {
            Assert.notNull(param.getPercentage(), "选择回款或毛利规则时，提成百分比必填！");
            Assert.isNull(param.getPieceWage(), "选择回款或毛利规则时，不能填写计件提成！");
            Assert.isTrue(BigDecimal.ZERO.compareTo(param.getPercentage()) < 0, "选择回款或毛利规则时，提成百分比必填，计件提成必须大于0！");
        } else {
            throw new BusinessException("提成规则传参错误！");
        }

        // 存在时，不能添加
        List<SalCommissionRuleVO> unique = salCommissionRuleRepoProc.checkUnique(param);
        if (unique != null && unique.size() > 0) {
            SalCommissionRuleVO data = findIdOne(unique.get(0).getId()).getData();
            String error;
            if (StringUtils.isNotBlank(data.getCateCodeName())) {
                error = "商品品类：" + data.getCateCodeName();
            } else {
                error = "商品编码：" + data.getItemCode();
            }
            throw new BusinessException(error + "记录已存在！不能添加！");
        }

        SalCommissionRuleDO salCommissionRuleDO = SalCommissionRuleConvert.INSTANCE.creatParamToDo(param);
        return salCommissionRuleRepo.save(salCommissionRuleDO).getId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createBatch(SalCommissionBatchParam param) {
        // 校验公司信息
        Assert.notNull(param.getOuId(), "公司ID不能为空");
        Assert.notBlank(param.getOuCode(), "公司编码不能为空");
        Assert.notBlank(param.getOuName(), "公司名称不能为空");

        // 校验是否带有批量创建的参数
        Assert.notNull(param.getCommissionList(), "数据列表不能为空");
        Assert.isTrue(param.getCommissionList().size() > 0, "数据列表不能为空");

        List<SalCommissionRuleCreateParam> list = param.getCommissionList();

        for (SalCommissionRuleCreateParam createParam : list) {
            // 设置公司信息
            createParam.setOuId(param.getOuId());
            createParam.setOuCode(param.getOuCode());
            createParam.setOuName(param.getOuName());

            createOne(createParam);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SalCommissionBatchParam param) {
        // 校验公司信息
        Assert.notNull(param.getOuId(), "公司ID不能为空");
        Assert.notBlank(param.getOuCode(), "公司编码不能为空");
        Assert.notBlank(param.getOuName(), "公司名称不能为空");

        // 校验是否带有批量创建的参数
        Assert.notNull(param.getCommissionList(), "数据列表不能为空");
        Assert.isTrue(param.getCommissionList().size() > 0, "数据列表不能为空");

        List<SalCommissionRuleCreateParam> list = param.getCommissionList();
        // 更新的数据
        List<SalCommissionRuleCreateParam> update = list.stream().filter(r -> Objects.nonNull(r.getId())).collect(Collectors.toList());
        // 创建的数据
        List<SalCommissionRuleCreateParam> create = list.stream().filter(r -> !Objects.nonNull(r.getId())).collect(Collectors.toList());

        for (SalCommissionRuleCreateParam uParam : update) {
            // 设置公司信息
            uParam.setOuId(param.getOuId());
            uParam.setOuCode(param.getOuCode());
            uParam.setOuName(param.getOuName());

            SalCommissionRuleDO objDo = SalCommissionRuleConvert.INSTANCE.creatParamToDo(uParam);

            // 校验信息
            checkData(objDo);

            salCommissionRuleRepo.save(objDo);
        }

        // 批量创建数据
        if (create.size() > 0) {
            param.setCommissionList(create);
            createBatch(param);
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDeleteFlag(Long id) {
        val jpaQDo = QSalCommissionRuleDO.salCommissionRuleDO;
        Predicate predicate = jpaQDo.isNotNull();
        predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(id));
        Optional<SalCommissionRuleDO> optionalItem = salCommissionRuleRepo.findOne(predicate);
        if (optionalItem.isPresent()) {
            SalCommissionRuleDO do1 = optionalItem.get();
            do1.setDeleteFlag(1);
            salCommissionRuleRepo.save(do1);
        } else {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + id);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void importData(List<SalCommissionRuleImportVO> importData) {
//
//        List<String> codeList = importData.stream()
//                .map(SalCommissionRuleImportVO::getOuCode)
//                .distinct()
//                .filter(Objects::nonNull)
//                .collect(Collectors.toList());
//
//        // 获取导入数据的公司
//        Map<String, OrgOuRpcDTO> ouMap = new HashMap<>();
//        if (codeList.size() > 0) {
//            OrgOuRpcDtoParam ouRpcDtoParam = new OrgOuRpcDtoParam();
//            ouRpcDtoParam.setOuCodes(codeList);
//            ouMap = rmiOrgOuService.findOuDtoListByParam(ouRpcDtoParam)
//                    .stream()
//                    .collect(Collectors.toMap(OrgOuRpcDTO::getOuCode, ou -> ou, (o1, o2) -> o1));
//        }
//
//        // 获取导入数据的商品信息
//        List<String> itemCodeList = importData.stream().map(SalCommissionRuleImportVO::getItemCode).collect(Collectors.toList());
//        Map<String, ItmItemRpcDTO> itmMap = new HashMap<>();
//        if (itemCodeList.size() > 0) {
//            ItmItemRpcDtoParam itemRpcDtoParam = new ItmItemRpcDtoParam();
//            itemRpcDtoParam.setItemCodes(itemCodeList);
//            itmMap = rmiItemService.findItemListByParam(itemRpcDtoParam)
//                    .stream()
//                    .collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, i -> i, (i1, i2) -> i1));
//        }
//
//        // 获取品类code
//        List<String> bigCateName = importData.stream().map(SalCommissionRuleImportVO::getCate1).collect(Collectors.toList());
//        Map<String, Map<String, Map<String, String>>> cateName = new HashMap<>();
//        if (bigCateName.size()>0){
//            ItmItemCateNameParam param = new ItmItemCateNameParam();
//            param.setBigItemCateNames(bigCateName);
//            cateName = rmiItemService.getItemCateInfoByBigCateName(param);
//        }
//
//        // 导入数据类转换
//        List<SalCommissionRuleDO> dos = new ArrayList<>();
//        for (var vo : importData) {
//
//            SalCommissionRuleDO ruleDO = SalCommissionRuleConvert.INSTANCE.ivoToDO(vo);
//
//            // 规则转换
//            Assert.notBlank(vo.getCommissionRule(),"公司名称为【" + vo.getOuName() + "】的提成规则不能为空！");
//            String ruleCode = ruleNameMap.get(vo.getCommissionRule());
//            Assert.notBlank(ruleCode,"公司名称为【" + vo.getOuName() + "】的提成规则【"+ vo.getCommissionRule() +"】设置错误！");
//            ruleDO.setCommissionRule(ruleCode);
//            vo.setCommissionRule(ruleCode);
//
//            // 校验基本信息
//            checkImportData(vo);
//
//            // 设置公司信息
//            OrgOuRpcDTO ouRpcDTO = ouMap.get(vo.getOuCode());
//            Assert.notNull(ouRpcDTO,"公司名称为【" + vo.getOuName() + "】，不存在该公司编码【"+vo.getOuCode()+"】输入错误！");
//            ruleDO.setOuId(ouRpcDTO.getId());
//            ruleDO.setOuName(ouRpcDTO.getOuName());
//
//            // 设置品类code
//            if (StringUtils.isNotBlank(vo.getCate1())){
//                Map<String, Map<String, String>> middleName = cateName.get(vo.getCate1());
//                Assert.notNull(middleName,"公司名称为【" + vo.getOuName() + "】的数据，大类名称【"+vo.getCate1()+"】输入错误，未在支撑域找到该类名称！");
//                Map<String, String> smallName = middleName.get(vo.getCate2());
//                Assert.notNull(smallName,"公司名称为【" + vo.getOuName() + "】的数据，中类名称【"+vo.getCate2()+"】输入错误，未在支撑域找到该类名称！");
//                String cateCode = smallName.get(vo.getCate3());
//                Assert.notNull(cateCode,"公司名称为【" + vo.getOuName() + "】的数据，小类名称【"+vo.getCate3()+"】输入错误，未在支撑域找到该类名称！");
//                ruleDO.setItemCateCode(cateCode);
//            }
//
//            // 校验数据库中是否已存在，存在则更新
//            List<SalCommissionRuleVO> unique = salCommissionRuleRepoProc.findUnique(ruleDO.getOuCode(), ruleDO.getItemCode(), ruleDO.getItemCateCode());
//            if (unique != null && unique.size() > 0) {
//                SalCommissionRuleVO ruleVO = unique.get(0);
//                ruleDO.setId(ruleVO.getId());
//            }
//
//            // 设置商品信息
//            if (!StringUtils.isEmpty(ruleDO.getItemCode())) {
//                ItmItemRpcDTO itmItemRpcDTO = itmMap.get(ruleDO.getItemCode());
//                Assert.notNull(itmItemRpcDTO, "公司名称为【" + vo.getOuName() + "】的数据，商品编码【" + vo.getItemCode() + "】有误！");
//                ruleDO.setItemId(itmItemRpcDTO.getId());
//                ruleDO.setItemName(itmItemRpcDTO.getItemName());
//            }
//
//            dos.add(ruleDO);
//        }
//
//        salCommissionRuleRepo.saveAll(dos);

    }

    /**
     * 检验信息是否正确
     *
     * @param param 类参数
     */
    private void checkData(SalCommissionRuleDO param) {
        if (StringUtils.isEmpty(param.getItemCode()) && StringUtils.isEmpty(param.getItemCateCode())) {
            throw new BusinessException("请输入商品信息！");
        }

        if ((!StringUtils.isEmpty(param.getItemCode())) && (!StringUtils.isEmpty(param.getItemCateCode()))) {
            throw new BusinessException("商品编码和商品品类不能同时选择！");
        }

        if (StringUtils.isEmpty(param.getCommissionRule())) {
            throw new BusinessException("提成规则不能为空！");
        }

        if (PIECE.equals(param.getCommissionRule())) {
            Assert.notNull(param.getPieceWage(), "选择计件规则时，计件提成必填！");
            Assert.isNull(param.getPercentage(), "选择计件规则时，不能填写提成百分比！");
            Assert.isTrue(BigDecimal.ZERO.compareTo(param.getPieceWage()) < 0, "选择机件规则时，计件提成必须大于0！");
        } else if (RETURN.equals(param.getCommissionRule())
                || PROFIT.equals(param.getCommissionRule())) {
            Assert.notNull(param.getPercentage(), "选择回款或毛利规则时，提成百分比必填！");
            Assert.isNull(param.getPieceWage(), "选择回款或毛利规则时，不能填写计件提成！");
            Assert.isTrue(BigDecimal.ZERO.compareTo(param.getPercentage()) < 0, "选择回款或毛利规则时，提成百分比必填，计件提成必须大于0！");
        } else {
            throw new BusinessException("提成规则传参错误！");
        }
    }


    private void checkImportData(SalCommissionRuleImportVO param) {


        String matchCateName = "";

        if (StringUtils.isNotBlank(param.getCate1())){
            matchCateName = param.getCate1() + param.getCate2() + param.getCate3();
        }

        String metaError = "公司名称为【" + param.getOuName() + "】";
        if (StringUtils.isEmpty(param.getItemCode()) && StringUtils.isEmpty(matchCateName)) {
            throw new BusinessException(metaError+"的商品信息为空！");
        }

        if (StringUtils.isBlank(param.getOuCode())){
            throw new BusinessException(metaError+"的公司编码为空！");
        }

        if ((!StringUtils.isEmpty(param.getItemCode())) && (!StringUtils.isEmpty(matchCateName))) {
            throw new BusinessException(metaError+"的商品编码和商品品类不能同时选择！");
        }

        if (PIECE.equals(param.getCommissionRule())) {
            Assert.notNull(param.getPieceWage(), metaError+"选择计件规则时，计件提成必填！");
            Assert.isNull(param.getPercentage(), metaError+"选择计件规则时，不能填写提成百分比！");
            Assert.isTrue(BigDecimal.ZERO.compareTo(param.getPieceWage()) < 0, "选择机件规则时，计件提成必须大于0！");
        } else if (RETURN.equals(param.getCommissionRule())
                || PROFIT.equals(param.getCommissionRule())) {
            Assert.notNull(param.getPercentage(), metaError+"选择回款或毛利规则时，提成百分比必填！");
            Assert.isNull(param.getPieceWage(), metaError+"选择回款或毛利规则时，不能填写计件提成！");
            Assert.isTrue(BigDecimal.ZERO.compareTo(param.getPercentage()) < 0, metaError+"选择回款或毛利规则时，提成百分比必填，计件提成必须大于0！");
        } else {
            throw new BusinessException(metaError+"提成规则输入错误！");
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<Long> list) {
        list.forEach(this::updateDeleteFlag);
    }

}


