package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.lang.Assert;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCompanyManageParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCompanyManageSwitchParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCompanyManageRespVO;
import com.elitesland.yst.production.sale.convert.shop.BipCompanyManageConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.BipCompanyManageDO;
import com.elitesland.yst.production.sale.entity.QBipCompanyManageDO;
import com.elitesland.yst.production.sale.repo.shop.BipCompanyManageRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCompanyManageRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.text.Collator;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/9/27 09:52
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class BipCompanyManageServiceImpl extends BaseServiceImpl implements BipCompanyManageService {

    private final QBipCompanyManageDO qBipCompanyManageDO = QBipCompanyManageDO.bipCompanyManageDO;

    private final BipCompanyManageRepo bipCompanyManageRepo;

    private final BipCompanyManageRepoProc bipCompanyManageRepoProc;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteCompanyManage(List<Long> ids) {
        bipCompanyManageRepo.updateCompanyDeleteFlag(1L,ids);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long createCompanyManage(BipCompanyManageRespVO bipCompanyManageRespVO) {
        if (ObjectUtils.isEmpty(bipCompanyManageRespVO)) {
            return null;
        }
        // ouId校验
        Boolean exists = bipCompanyManageRepoProc.exists(bipCompanyManageRespVO.getOuId(), bipCompanyManageRespVO.getId());
        Assert.isFalse(exists,"公司id为【"+bipCompanyManageRespVO.getOuId()+"】的数据已经在数据库中存在,请检查.");
        Boolean exists1 = bipCompanyManageRepoProc.exists(bipCompanyManageRespVO.getViewOuName(), bipCompanyManageRespVO.getId());
        Assert.isFalse(exists1,"公司id为【"+bipCompanyManageRespVO.getOuId()+"】的数据商城显示名称已经在数据库中存在,请检查.");
        Assert.notNull(bipCompanyManageRespVO.getServiceTel(),"公司为【"+bipCompanyManageRespVO.getOuName()+"】的数据未填写客服电话,请检查.");
        if (ObjectUtils.isEmpty(bipCompanyManageRespVO.getCustServiceSource()) || bipCompanyManageRespVO.getCustServiceSource().contains("|")){
            throw new BusinessException("客服来源必填,且不能包含非法字符【|】");
        }
        BipCompanyManageConvert bipCompanyManageConvert = BipCompanyManageConvert.INSTANCE;
        BipCompanyManageDO bipCompanyManageDO = bipCompanyManageConvert.respVoToDo(bipCompanyManageRespVO);
        BipCompanyManageDO companyManageDO = bipCompanyManageRepo.save(bipCompanyManageDO);
        return companyManageDO.getId();
    }

    @Override
    public PagingVO<BipCompanyManageRespVO> search(BipCompanyManageParamVO searchParam) {

        var jpaQuery = this.select(searchParam);
        long total = jpaQuery.fetchCount();
        if (total == 0) {
            return PagingVO.<BipCompanyManageRespVO>builder().build();
        }
        // 添加分页和排序
        PageRequest pageRequest = wrapperPageRequest(searchParam.getPageRequest(), null);
        appendPageAndSort(jpaQuery, pageRequest, qBipCompanyManageDO);
        List<BipCompanyManageRespVO> respVOS = jpaQuery.fetch();

        // 补充数据
        return PagingVO.<BipCompanyManageRespVO>builder()
                .total(total)
                .records(respVOS).build();
    }

    @Override
    public BipCompanyManageRespVO findCompanyManageById(Long id) {
        BipCompanyManageConvert bipCompanyManageConvert = BipCompanyManageConvert.INSTANCE;
        Optional<BipCompanyManageDO> companyManageDOOptional = bipCompanyManageRepo.findById(id);
        if (companyManageDOOptional.isPresent()) {
            BipCompanyManageDO bipCompanyManageDO = companyManageDOOptional.get();
            return bipCompanyManageConvert.doToRespVO(bipCompanyManageDO);
        } else {
            throw new BusinessException("该公司不存在于商城公司表");
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void approveCompanyManage(BipCompanyManageSwitchParamVO bipCompanyManageSwitchParamVO) {
        if (ObjectUtils.isEmpty(bipCompanyManageSwitchParamVO)) {
            throw new BusinessException("没有选择操作的公司");
        }
        bipCompanyManageRepo.updateCompanyStatus(bipCompanyManageSwitchParamVO.getViewOuStatus(), bipCompanyManageSwitchParamVO.getIds());
    }

    public static Map<String,Object> px(List<BipCompanyManageRespVO> list){
        Comparator com = Collator.getInstance(Locale.CHINA);
        // 按字母排序
        List<BipCompanyManageRespVO> list1 = list.stream().sorted((x, y) -> com.compare(x.getViewOuName(), y.getViewOuName())).collect(Collectors.toList());
        // 输出26个字母
        Map<String,Object> map = new TreeMap<String, Object>();
        for (int i = 1; i <= 26; i++) {
            String word = String.valueOf((char) (96 + i));
            // 循环找出 首字母一样的数据
            List<BipCompanyManageRespVO> letter = new ArrayList<>();
            for (BipCompanyManageRespVO respVO: list1) {
                String zm = PinyinUtil.getFirstLetter(respVO.getViewOuName(),"").substring(0, 1);
                if (word.equals(zm)){
                    letter.add(respVO);
                }
            }
            map.put(word.toUpperCase(),letter);
        }
        return map;
    }

    @Override
    public Map<String, Object> searchForWx(BipCompanyManageParamVO searchParam) {
        var jpaQuery = this.select(searchParam);
        long total = jpaQuery.fetchCount();
        if (total == 0) {
            return new HashMap<>();
        }
        // 添加分页和排序
        List<BipCompanyManageRespVO> bipCompanyManageRespVOS = jpaQuery.fetch();
        Map<String, Object> map = px(bipCompanyManageRespVOS);
        // 补充数据
        return map;
    }

    @Override
    public List<BipCompanyManageRespVO> findCompanyManageByOuIds(List<Long> ouIds) {
        if (CollectionUtils.isEmpty(ouIds)){
            return new ArrayList<>();
        }
        JPAQuery<BipCompanyManageRespVO> jpaQuery = this.selectByOuIds(ouIds);
        return jpaQuery.fetch();
    }

    @Override
    public Long searchFirst() {
        return jpaQueryFactory.select(qBipCompanyManageDO.ouId)
                .from(qBipCompanyManageDO)
                .where(qBipCompanyManageDO.viewOuStatus.eq(true))
                .limit(1)
                .fetchOne();
    }

    /**
     * 查询数据
     *
     * @param searchParam searchParam
     * @return
     */
    public JPAQuery<BipCompanyManageRespVO> select(BipCompanyManageParamVO searchParam) {

        val jpaQuery = jpaQueryFactory.select(Projections.bean(BipCompanyManageRespVO.class,
                qBipCompanyManageDO.id,
                qBipCompanyManageDO.ouId,
                qBipCompanyManageDO.ouCode,
                qBipCompanyManageDO.ouName,
                qBipCompanyManageDO.buId,
                qBipCompanyManageDO.buName,
                qBipCompanyManageDO.buCode,
                qBipCompanyManageDO.viewOuName,
                qBipCompanyManageDO.viewOuStatus,
                qBipCompanyManageDO.custServiceSource,
                qBipCompanyManageDO.serviceTel,
                qBipCompanyManageDO.custServiceSource.as("source")
        )).from(qBipCompanyManageDO);
        if (searchParam != null) {
            jpaQuery.where(where(searchParam));
        }
        return jpaQuery;
    }

    /**
     * 查询数据
     *
     * @param ids ids
     * @return
     */
    public JPAQuery<BipCompanyManageRespVO> selectByOuIds(List<Long> ids) {

        val jpaQuery = jpaQueryFactory.select(Projections.bean(BipCompanyManageRespVO.class,
                qBipCompanyManageDO.id,
                qBipCompanyManageDO.ouId,
                qBipCompanyManageDO.ouCode,
                qBipCompanyManageDO.ouName,
                qBipCompanyManageDO.buId,
                qBipCompanyManageDO.buName,
                qBipCompanyManageDO.buCode,
                qBipCompanyManageDO.viewOuName,
                qBipCompanyManageDO.viewOuStatus,
                qBipCompanyManageDO.custServiceSource,
                qBipCompanyManageDO.serviceTel
        )).from(qBipCompanyManageDO);
        if (!CollectionUtils.isEmpty(ids)) {
            jpaQuery.where(qBipCompanyManageDO.ouId.in(ids));
        }
        return jpaQuery;
    }

    /**
     * 条件查询
     *
     * @param searchParam 查询条件
     */
    public Predicate where(BipCompanyManageParamVO searchParam) {


        Predicate predicate = qBipCompanyManageDO.isNotNull();

        //押金单单号
        if (!StringUtils.isEmpty(searchParam.getOuId())) {
            predicate = ExpressionUtils.and(predicate, qBipCompanyManageDO.ouId.eq(searchParam.getOuId()));
        }
        if (!StringUtils.isEmpty(searchParam.getOuCode())) {
            predicate = ExpressionUtils.and(predicate, qBipCompanyManageDO.ouCode.like("%" + searchParam.getOuCode() + "%"));
        }
        if (!StringUtils.isEmpty(searchParam.getOuName())) {
            predicate = ExpressionUtils.and(predicate, qBipCompanyManageDO.ouName.like("%" + searchParam.getOuName() + "%"));
        }
        if (!StringUtils.isEmpty(searchParam.getViewOuName())) {
            predicate = ExpressionUtils.and(predicate, qBipCompanyManageDO.viewOuName.like("%" + searchParam.getViewOuName() + "%"));
        }
        if (!StringUtils.isEmpty(searchParam.getViewOuStatus())) {
            predicate = ExpressionUtils.and(predicate, qBipCompanyManageDO.viewOuStatus.eq(searchParam.getViewOuStatus()));
        }


        return predicate;
    }
}
