/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.event.listener;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.service.shop.BipItemMngService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderDService;
import com.elitesland.yst.production.sale.event.ItemSaleChangeEvent;
import java.time.LocalDateTime;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ItemSaleNumListener
implements ApplicationListener<ItemSaleChangeEvent> {
    private static final Logger log = LoggerFactory.getLogger(ItemSaleNumListener.class);
    private final BipOrderDService orderDService;
    private final BipItemMngService itemMngService;

    public ItemSaleNumListener(BipOrderDService orderDService, BipItemMngService itemMngService) {
        this.orderDService = orderDService;
        this.itemMngService = itemMngService;
    }

    public void onApplicationEvent(ItemSaleChangeEvent event) {
        if (event.getBipItemId() == null) {
            log.error("\u76d1\u542c\u5230\u5546\u54c1\u9500\u91cf\u53d8\u66f4\u4e8b\u4ef6\uff0c\u4f46\u5546\u54c1ID\u4e3a\u7a7a");
            return;
        }
        log.debug("\u76d1\u542c\u5230\u5546\u54c1\u3010{}\u3011\u7684\u9500\u91cf\u53d8\u66f4", (Object)event.getBipItemId());
        CompletableFuture.runAsync(() -> this.updateItemSaleNum(event.getBipItemId())).exceptionally(e -> {
            log.error("\u66f4\u65b0\u5546\u54c1\u3010" + event.getBipItemId() + "\u3011\u9500\u91cf\u53d1\u751f\u5f02\u5e38", e);
            return null;
        });
    }

    private void updateItemSaleNum(Long bipItemId) {
        ApiResult saleResult = this.orderDService.countItemSaleNum(bipItemId, null, null);
        Assert.isTrue((boolean)saleResult.isSuccess(), (String)saleResult.getMsg(), (Object[])new Object[0]);
        ApiResult sale90Result = this.orderDService.countItemSaleNum(bipItemId, LocalDateTime.now().minusDays(90L), null);
        Assert.isTrue((boolean)sale90Result.isSuccess(), (String)sale90Result.getMsg(), (Object[])new Object[0]);
        this.itemMngService.updateSale(bipItemId, (Long)ObjectUtil.defaultIfNull((Object)((Long)saleResult.getData()), (Object)0L), (Long)ObjectUtil.defaultIfNull((Object)((Long)sale90Result.getData()), (Object)0L));
    }
}

