/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustAccountQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.entity.CustAccountDO;
import com.elitesland.yst.production.sale.entity.QCustAccountDO;
import com.elitesland.yst.production.sale.repo.CustAccountRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CustAccountRepoProc {
    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    @Autowired
    private CustAccountRepo custAccountRepo;
    private final QCustAccountDO qCustAccountDO = QCustAccountDO.custAccountDO;
    private final QBean<CustAccountVO> custAccountVOQBean;

    public CustAccountRepoProc() {
        this.custAccountVOQBean = Projections.fields(CustAccountVO.class, (Expression[])new Expression[]{this.qCustAccountDO.id, this.qCustAccountDO.custCode, this.qCustAccountDO.isOpenAccount, this.qCustAccountDO.createAccountTime, this.qCustAccountDO.balance, this.qCustAccountDO.mobile, this.qCustAccountDO.userName, this.qCustAccountDO.nickName, this.qCustAccountDO.pwd, this.qCustAccountDO.roleId, this.qCustAccountDO.userId, this.qCustAccountDO.roleCode, this.qCustAccountDO.tenantId, this.qCustAccountDO.updatePwdTime, this.qCustAccountDO.dealerType, this.qCustAccountDO.businessType, this.qCustAccountDO.subAcFlag, this.qCustAccountDO.accountType, this.qCustAccountDO.enable, this.qCustAccountDO.isModifyPwd, this.qCustAccountDO.createTime, this.qCustAccountDO.businessTypeCust});
    }

    public CustAccountDO getByCustCode(String custCode) {
        BooleanExpression e = this.qCustAccountDO.custCode.eq((Object)custCode).and((Predicate)this.qCustAccountDO.deleteFlag.eq((Object)0));
        Optional optional = this.custAccountRepo.findOne((Predicate)e);
        if (optional.isPresent()) {
            return (CustAccountDO)optional.get();
        }
        return new CustAccountDO();
    }

    public CustAccountDO getByUserName(String userName) {
        BooleanExpression e = this.qCustAccountDO.userName.eq((Object)userName).and((Predicate)this.qCustAccountDO.deleteFlag.eq((Object)0));
        Optional optional = this.custAccountRepo.findOne((Predicate)e);
        if (optional.isPresent()) {
            return (CustAccountDO)optional.get();
        }
        return new CustAccountDO();
    }

    public CustAccountDO getByUserId(Long userId) {
        BooleanExpression e = this.qCustAccountDO.userId.eq((Object)userId).and((Predicate)this.qCustAccountDO.deleteFlag.eq((Object)0));
        Optional optional = this.custAccountRepo.findOne((Predicate)e);
        if (optional.isPresent()) {
            return (CustAccountDO)optional.get();
        }
        return new CustAccountDO();
    }

    public CustAccountDO getByMobileDo(String mobile) {
        BooleanExpression e = this.qCustAccountDO.mobile.eq((Object)mobile).and((Predicate)this.qCustAccountDO.deleteFlag.eq((Object)0));
        Optional optional = this.custAccountRepo.findOne((Predicate)e);
        if (optional.isPresent()) {
            return (CustAccountDO)optional.get();
        }
        return new CustAccountDO();
    }

    public CustAccountDO getByMobile(String mobile, List<String> custType) {
        BooleanExpression e = this.qCustAccountDO.mobile.eq((Object)mobile).and((Predicate)this.qCustAccountDO.dealerType.in(custType)).and((Predicate)this.qCustAccountDO.deleteFlag.eq((Object)0));
        Optional optional = this.custAccountRepo.findOne((Predicate)e);
        if (optional.isPresent()) {
            return (CustAccountDO)optional.get();
        }
        return new CustAccountDO();
    }

    public CustAccountVO getAccountByCustCode(String custCode) {
        return (CustAccountVO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.custAccountVOQBean).from((EntityPath)this.qCustAccountDO)).where((Predicate)this.qCustAccountDO.deleteFlag.eq((Object)0).and((Predicate)this.qCustAccountDO.custCode.eq((Object)custCode)))).limit(1L)).fetchOne();
    }

    public Object delSonAccount(List<Long> accountIds) {
        this.jpaQueryFactory.delete((EntityPath)this.qCustAccountDO).where(new Predicate[]{this.qCustAccountDO.id.in(accountIds)}).execute();
        return "SUCCESS";
    }

    public List<CustAccountVO> getAccountByUserNames(List<String> usernames) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.custAccountVOQBean).from((EntityPath)this.qCustAccountDO)).where((Predicate)this.qCustAccountDO.deleteFlag.eq((Object)0).and((Predicate)this.qCustAccountDO.userName.in(usernames)))).fetch();
    }

    public List<CustAccountVO> getAccountByUserNamesAndSource(List<String> usernames, List<String> dealerTypes, String businessTypeCust) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.custAccountVOQBean).from((EntityPath)this.qCustAccountDO)).where((Predicate)this.qCustAccountDO.deleteFlag.eq((Object)0).and((Predicate)this.qCustAccountDO.userName.in(usernames)).and((Predicate)this.qCustAccountDO.dealerType.in(dealerTypes)).and((Predicate)this.qCustAccountDO.businessTypeCust.eq((Object)businessTypeCust)))).fetch();
    }

    public List<CustAccountVO> getByCustCodesAndUserName(String custCode, String userName, List<String> dealerTypes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.custAccountVOQBean).from((EntityPath)this.qCustAccountDO)).where(this.getAccountCust(custCode, userName, dealerTypes))).fetch();
    }

    public List<CustAccountVO> getAccountByCustCode(List<String> custCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.custAccountVOQBean).from((EntityPath)this.qCustAccountDO)).where((Predicate)this.qCustAccountDO.deleteFlag.eq((Object)0).and((Predicate)this.qCustAccountDO.custCode.in(custCode)))).fetch();
    }

    public List<CustAccountVO> getByParentCustCode(String custCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.custAccountVOQBean).from((EntityPath)this.qCustAccountDO)).where((Predicate)this.qCustAccountDO.deleteFlag.eq((Object)0).and((Predicate)this.qCustAccountDO.custCode.eq((Object)custCode)).and((Predicate)this.qCustAccountDO.subAcFlag.eq(Boolean.FALSE)))).fetch();
    }

    public List<CustAccountVO> getAccountPage(CustAccountQueryParam param) {
        JPAQuery vojpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.custAccountVOQBean).from((EntityPath)this.qCustAccountDO)).where(this.where(param));
        param.setPaging(vojpaQuery);
        param.fillOrders(vojpaQuery, (EntityPathBase)this.qCustAccountDO);
        return vojpaQuery.fetch();
    }

    public CustAccountVO getAccountByUserName(String userName) {
        return (CustAccountVO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.custAccountVOQBean).from((EntityPath)this.qCustAccountDO)).where((Predicate)this.qCustAccountDO.deleteFlag.eq((Object)0).and((Predicate)this.qCustAccountDO.userName.eq((Object)userName)))).limit(1L)).fetchOne();
    }

    public CustAccountVO getAccountByMobile(String mobile) {
        return (CustAccountVO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.custAccountVOQBean).from((EntityPath)this.qCustAccountDO)).where((Predicate)this.qCustAccountDO.deleteFlag.eq((Object)0).and((Predicate)this.qCustAccountDO.mobile.eq((Object)mobile)).and((Predicate)this.qCustAccountDO.dealerType.notEqualsIgnoreCase("STORE")))).limit(1L)).fetchOne();
    }

    public CustAccountVO getAccountByMobileAndBusinessTypeCust(String mobile, String businessTypeCust) {
        return (CustAccountVO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.custAccountVOQBean).from((EntityPath)this.qCustAccountDO)).where(this.getAccountPredicate(mobile, businessTypeCust))).limit(1L)).fetchOne();
    }

    private Predicate getAccountCust(String custCode, String userName, List<String> dealerTypes) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(this.qCustAccountDO.dealerType.notEqualsIgnoreCase("STORE"));
        if (StringUtils.isNotBlank((CharSequence)custCode)) {
            predicates.add(this.qCustAccountDO.custCode.eq((Object)custCode));
        }
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            predicates.add(this.qCustAccountDO.userName.eq((Object)userName));
        }
        if (CollectionUtil.isNotEmpty(dealerTypes)) {
            predicates.add(this.qCustAccountDO.dealerType.in(dealerTypes));
        }
        return ExpressionUtils.allOf(predicates);
    }

    private Predicate getAccountPredicate(String mobile, String businessTypeCust) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(this.qCustAccountDO.deleteFlag.eq((Object)1));
        predicates.add(this.qCustAccountDO.dealerType.notEqualsIgnoreCase("STORE"));
        if (StringUtils.isNotBlank((CharSequence)mobile)) {
            predicates.add(this.qCustAccountDO.mobile.eq((Object)mobile));
        }
        if (StringUtils.isNotBlank((CharSequence)businessTypeCust)) {
            predicates.add(this.qCustAccountDO.businessTypeCust.eq((Object)businessTypeCust));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public CustAccountVO getAccountByUserId(Long userId) {
        return (CustAccountVO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.custAccountVOQBean).from((EntityPath)this.qCustAccountDO)).where((Predicate)this.qCustAccountDO.deleteFlag.eq((Object)0).and((Predicate)this.qCustAccountDO.userId.eq((Object)userId)))).limit(1L)).fetchOne();
    }

    public long getAccountPageCount(CustAccountQueryParam param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qCustAccountDO.count()).from((EntityPath)this.qCustAccountDO);
        jpaQuery.where(this.where(param));
        return jpaQuery.fetchCount();
    }

    public List<CustAccountVO> getAccountListByUserName(String userName) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.custAccountVOQBean).from((EntityPath)this.qCustAccountDO)).where((Predicate)this.qCustAccountDO.deleteFlag.eq((Object)0).and((Predicate)this.qCustAccountDO.userName.eq((Object)userName)).and((Predicate)this.qCustAccountDO.isOpenAccount.eq(Boolean.TRUE)))).fetch();
    }

    public Boolean exists(String userName, Long id, String source) {
        BooleanExpression predicate = this.qCustAccountDO.deleteFlag.eq((Object)0).or((Predicate)this.qCustAccountDO.deleteFlag.isNull());
        predicate = ObjectUtils.isEmpty((Object)userName) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.userName.eq((Object)userName));
        Object object = predicate = ObjectUtils.isEmpty((Object)id) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.id.ne((Object)id));
        if (source.equals("CUST")) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.dealerType.ne((Object)"STORE"));
        }
        predicate = ObjectUtils.isEmpty((Object)id) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.id.ne((Object)id));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCustAccountDO).from((EntityPath)this.qCustAccountDO)).where((Predicate)predicate)).fetchCount() > 0L;
    }

    public Boolean existsMobile(String mobile, Long id, String source) {
        BooleanExpression predicate = this.qCustAccountDO.deleteFlag.eq((Object)0).or((Predicate)this.qCustAccountDO.deleteFlag.isNull());
        predicate = ObjectUtils.isEmpty((Object)mobile) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.mobile.eq((Object)mobile));
        Object object = predicate = ObjectUtils.isEmpty((Object)id) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.id.ne((Object)id));
        if (source.equals("CUST")) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.dealerType.ne((Object)"STORE"));
        }
        predicate = ObjectUtils.isEmpty((Object)id) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.id.ne((Object)id));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCustAccountDO).from((EntityPath)this.qCustAccountDO)).where((Predicate)predicate)).fetchCount() > 0L;
    }

    public Boolean existsMobile2(String mobile, Long id, String source, String businessTypeCust) {
        BooleanExpression predicate = this.qCustAccountDO.deleteFlag.eq((Object)0).or((Predicate)this.qCustAccountDO.deleteFlag.isNull());
        predicate = ObjectUtils.isEmpty((Object)mobile) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.mobile.eq((Object)mobile));
        predicate = ObjectUtils.isEmpty((Object)id) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.id.ne((Object)id));
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.dealerType.ne((Object)"STORE"));
        predicate = ObjectUtils.isEmpty((Object)id) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.id.ne((Object)id));
        predicate = ObjectUtils.isEmpty((Object)businessTypeCust) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.businessTypeCust.eq((Object)businessTypeCust));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCustAccountDO).from((EntityPath)this.qCustAccountDO)).where((Predicate)predicate)).fetchCount() > 0L;
    }

    public Boolean exists1(String userName, String custCode, String source, String businessTypeCust) {
        BooleanExpression predicate = this.qCustAccountDO.deleteFlag.eq((Object)0).or((Predicate)this.qCustAccountDO.deleteFlag.isNull());
        predicate = ObjectUtils.isEmpty((Object)userName) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.mobile.eq((Object)userName));
        predicate = ObjectUtils.isEmpty((Object)custCode) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.custCode.ne((Object)custCode));
        Object object = predicate = ObjectUtils.isEmpty((Object)businessTypeCust) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.businessTypeCust.eq((Object)businessTypeCust));
        if (source.equals("CUST")) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.dealerType.ne((Object)"STORE"));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCustAccountDO).from((EntityPath)this.qCustAccountDO)).where((Predicate)predicate)).fetchCount() > 0L;
    }

    public Boolean existsCustAccount(String mobile, Long id, String source) {
        BooleanExpression predicate = this.qCustAccountDO.deleteFlag.eq((Object)0).or((Predicate)this.qCustAccountDO.deleteFlag.isNull());
        predicate = ObjectUtils.isEmpty((Object)mobile) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.mobile.eq((Object)mobile));
        Object object = predicate = ObjectUtils.isEmpty((Object)id) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.id.ne((Object)id));
        if (source.equals("CUST")) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.dealerType.ne((Object)"STORE"));
        }
        predicate = ObjectUtils.isEmpty((Object)id) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.id.ne((Object)id));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCustAccountDO).from((EntityPath)this.qCustAccountDO)).where((Predicate)predicate)).fetchCount() > 0L;
    }

    public void saveAccountCust(String custCode, CustAccountVO custAccountVO) {
        CustAccountDO custAccountDO = new CustAccountDO();
        BeanUtils.copyProperties((Object)custAccountVO, (Object)custAccountDO);
        custAccountDO.setCustCode(custCode);
        this.custAccountRepo.save(custAccountDO);
    }

    private Predicate where(CustAccountQueryParam param) {
        BooleanExpression predicate = this.qCustAccountDO.isNotNull();
        if (!ObjectUtils.isEmpty((Object)param.getCustCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.custCode.eq((Object)param.getCustCode()));
        }
        if (!ObjectUtils.isEmpty((Object)param.getKeyword())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.nickName.like("%" + param.getKeyword() + "%").or((Predicate)this.qCustAccountDO.mobile.like("%" + param.getKeyword() + "%")));
        }
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCustAccountDO.subAcFlag.eq(Boolean.TRUE));
        return predicate;
    }
}

