/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo.shop;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.yst.production.sale.entity.BipOrderDDO;
import com.elitesland.yst.production.sale.entity.QBipOrderDDO;
import com.elitesland.yst.production.sale.entity.QBipOrderDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class BipOrderDRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QBipOrderDDO DO = QBipOrderDDO.bipOrderDDO;

    public BipOrderDRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }

    public Long countItemSaleNum(Long itemId) {
        return (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)BipOrderDRepoProc.DO.buyQty.sum()).from((EntityPath)DO)).where((Predicate)BipOrderDRepoProc.DO.itemId.eq((Object)itemId).and((Predicate)BipOrderDRepoProc.DO.payTime.isNotNull()))).fetchOne();
    }

    public Long countItemSaleNum(Long itemId, LocalDateTime start, LocalDateTime end) {
        BooleanExpression condition = BipOrderDRepoProc.DO.itemId.eq((Object)itemId);
        if (start != null) {
            condition = condition.and((Predicate)BipOrderDRepoProc.DO.payTime.after((Comparable)start));
        }
        if (end != null) {
            condition = condition.and((Predicate)BipOrderDRepoProc.DO.payTime.before((Comparable)end));
        }
        return (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)BipOrderDRepoProc.DO.buyQty.sum()).from((EntityPath)DO)).where((Predicate)condition)).fetchOne();
    }

    public List<Long> queryRecentOrderItemId(Long userId, Integer size) {
        QBipOrderDO order = QBipOrderDO.bipOrderDO;
        BooleanExpression condition = order.custAccountId.eq((Object)userId);
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipOrderDRepoProc.DO.itemId).from((EntityPath)DO)).leftJoin((EntityPath)order)).on((Predicate)BipOrderDRepoProc.DO.orderId.eq(order.id))).where((Predicate)condition)).limit((long)((Integer)ObjectUtil.defaultIfNull((Object)size, (Object)10)).intValue())).fetch();
    }

    public BipOrderDDO findorderItemIdAndSkuIdByOrderId(Long orderId) {
        return (BipOrderDDO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipOrderDDO.class, (Expression[])new Expression[]{BipOrderDRepoProc.DO.itemId, BipOrderDRepoProc.DO.skuId, BipOrderDRepoProc.DO.itemCode, BipOrderDRepoProc.DO.itemBrand, BipOrderDRepoProc.DO.itemTitle, BipOrderDRepoProc.DO.relateItemId, BipOrderDRepoProc.DO.itemType, BipOrderDRepoProc.DO.itemSpec, BipOrderDRepoProc.DO.itemName})).from((EntityPath)DO)).where((Predicate)BipOrderDRepoProc.DO.id.eq((Object)orderId))).fetchOne();
    }

    public List<Long> findGiftOrderId(Long orderId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipOrderDRepoProc.DO.id).from((EntityPath)DO)).where((Predicate)BipOrderDRepoProc.DO.pid.eq((Object)orderId))).fetch();
    }

    public boolean updateStatus(Long orderId, String status) {
        QBipOrderDDO qBipOrderDDO = QBipOrderDDO.bipOrderDDO;
        BooleanExpression predicate = qBipOrderDDO.isNotNull();
        return this.jpaQueryFactory.update((EntityPath)qBipOrderDDO).set((Path)qBipOrderDDO.status, (Object)status).where(new Predicate[]{qBipOrderDDO.orderId.eq((Object)orderId)}).execute() == 1L;
    }

    public boolean updateOrderDAllowStatus(Long orderId, String status) {
        QBipOrderDDO qBipOrderDDO = QBipOrderDDO.bipOrderDDO;
        BooleanExpression predicate = qBipOrderDDO.isNotNull();
        return this.jpaQueryFactory.update((EntityPath)qBipOrderDDO).set((Path)qBipOrderDDO.status, (Object)status).where(new Predicate[]{qBipOrderDDO.orderId.eq((Object)orderId)}).execute() == 1L;
    }

    public boolean updateOrderDAllowBackNum(Long id, Long num) {
        QBipOrderDDO qBipOrderDDO = QBipOrderDDO.bipOrderDDO;
        BooleanExpression predicate = qBipOrderDDO.isNotNull();
        return this.jpaQueryFactory.update((EntityPath)qBipOrderDDO).set(qBipOrderDDO.allowBackNum, (Expression)qBipOrderDDO.allowBackNum.add((Number)num)).where(new Predicate[]{qBipOrderDDO.id.eq((Object)id).and((Predicate)qBipOrderDDO.allowBackNum.goe((Number)num))}).execute() == 1L;
    }

    public boolean updateOrderDLogist(Long id, Long orderId, String logistNo) {
        QBipOrderDDO qBipOrderDDO = QBipOrderDDO.bipOrderDDO;
        BooleanExpression predicate = qBipOrderDDO.isNotNull();
        return this.jpaQueryFactory.update((EntityPath)qBipOrderDDO).set((Path)qBipOrderDDO.logisNo, (Object)logistNo).where(new Predicate[]{qBipOrderDDO.id.eq((Object)id).and((Predicate)qBipOrderDDO.orderId.eq((Object)orderId))}).execute() == 1L;
    }

    public List<Long> findOrderDSkuIdByIds(List<Long> orderDIds) {
        QBipOrderDDO qBipOrderDDO = QBipOrderDDO.bipOrderDDO;
        BooleanExpression predicate = qBipOrderDDO.isNotNull();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(qBipOrderDDO.skuId).from((EntityPath)qBipOrderDDO)).where((Predicate)qBipOrderDDO.id.in(orderDIds))).fetch();
    }

    public List<Long> findOrderDIdBySkuId(List<Long> skuIds, Long orderId) {
        QBipOrderDDO qBipOrderDDO = QBipOrderDDO.bipOrderDDO;
        BooleanExpression predicate = qBipOrderDDO.isNotNull();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(qBipOrderDDO.id).from((EntityPath)qBipOrderDDO)).where((Predicate)qBipOrderDDO.skuId.in(skuIds).and((Predicate)qBipOrderDDO.orderId.eq((Object)orderId)))).fetch();
    }
}

