/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.dto.PriBasePriceDTO;
import com.elitesland.yst.production.sale.dto.PriCrossPriceDTO;
import com.elitesland.yst.production.sale.dto.PriSalePriceDTO;
import com.elitesland.yst.production.sale.dto.query.PriBasePriceReqDTO;
import com.elitesland.yst.production.sale.dto.query.PriCrossPriceReqDTO;
import com.elitesland.yst.production.sale.dto.query.PriSalePriceReqDTO;
import com.elitesland.yst.production.sale.entity.PriSalePriceDO;
import com.elitesland.yst.production.sale.entity.QPriSalePriceDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.rmi.ystpur.RmiPurPriceService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiPriMainPriceService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
import com.elitesland.yst.production.sale.service.PriSalePriceRpcService;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemUomConvRpcDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/rpc/cloudt/sale/saleprice"})
public class PriSalePriceRpcServiceImpl
extends BaseServiceImpl
implements PriSalePriceRpcService {
    private static final Logger log = LoggerFactory.getLogger(PriSalePriceRpcServiceImpl.class);
    private final QPriSalePriceDO qPriSalePriceDO = QPriSalePriceDO.priSalePriceDO;
    private final RmiPriMainPriceService rmiPriMainPriceService;
    private final CrmCustService crmCustService;
    private final RmiPurPriceService rmiPurPriceService;
    private final RmiCommonService rmiCommonService;
    private final CrmCustRepoProc crmCustRepoProc;
    public static final String TYPE_BASE = UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCode();
    public static final String TYPE_CUST = UdcEnum.PRI_SALE_PRICE_TYPE_CUST.getValueCode();
    public static final String TYPE_GROUP = UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode();
    public static final String TYPE_CROSS = UdcEnum.PRI_SALE_PRICE_TYPE_CROSS.getValueCode();

    public ApiResult<PriSalePriceDTO> findSalePriceDto(PriSalePriceReqDTO param) {
        return null;
    }

    public ApiResult<List<PriSalePriceDTO>> findSalePriceListDto(List<PriSalePriceReqDTO> params) throws InterruptedException {
        if (CollectionUtils.isEmpty(params)) {
            return ApiResult.ok();
        }
        ExecutorService executorService = Executors.newFixedThreadPool(200);
        ArrayList tasks = new ArrayList(params.size());
        params.forEach(p -> tasks.add(() -> (PriSalePriceDTO)this.findSalePriceDto((PriSalePriceReqDTO)p).getData()));
        ArrayList<PriSalePriceDTO> resList = new ArrayList<PriSalePriceDTO>();
        List list = executorService.invokeAll(tasks);
        for (Future f : list) {
            try {
                resList.add((PriSalePriceDTO)f.get());
            }
            catch (Exception e) {
                log.info(e.getMessage());
                return ApiResult.fail();
            }
        }
        return ApiResult.ok(resList);
    }

    public ApiResult<PriCrossPriceDTO> findCrossPriceDto(PriCrossPriceReqDTO param) {
        return null;
    }

    public ApiResult<PriBasePriceDTO> findBasePriceDto(PriBasePriceReqDTO param) {
        return null;
    }

    public ApiResult<PriSalePriceDTO> findSaleTaxRateDto(PriSalePriceReqDTO param) {
        return null;
    }

    private List<PriSalePriceDO> doQueryPrice(boolean crossType, Long ouId, String currCode, List<Long> itemIds) {
        BooleanExpression predicate = this.qPriSalePriceDO.ouId.eq((Object)ouId);
        predicate = crossType ? ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.priceType.eq((Object)TYPE_CROSS)) : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.priceType.notIn((Object[])new String[]{TYPE_CROSS}));
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.currCode.eq((Object)currCode));
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.itemId.in(itemIds));
        LocalDateTime validTime = LocalDateTime.now();
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.validFrom.before((Comparable)validTime).or((Predicate)this.qPriSalePriceDO.validFrom.eq((Object)validTime)));
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.validTo.after((Comparable)validTime).or((Predicate)this.qPriSalePriceDO.validTo.eq((Object)validTime)));
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)this.qPriSalePriceDO).where((Predicate)predicate);
        return jpaQuery.fetch();
    }

    private BigDecimal getItemUomConvRatio(List<ItmItemUomConvRpcDTO> itmUomConvRpcResult, Long itemId, String fromUom, String toUom) {
        Optional<ItmItemUomConvRpcDTO> uo = itmUomConvRpcResult.stream().filter(u -> u.getItemId().equals(itemId) && fromUom.equals(u.getFromUom()) && toUom.equals(u.getToUom())).findFirst();
        return uo.map(ItmItemUomConvRpcDTO::getRatio).orElse(null);
    }

    public PriSalePriceRpcServiceImpl(RmiPriMainPriceService rmiPriMainPriceService, CrmCustService crmCustService, RmiPurPriceService rmiPurPriceService, RmiCommonService rmiCommonService, CrmCustRepoProc crmCustRepoProc) {
        this.rmiPriMainPriceService = rmiPriMainPriceService;
        this.crmCustService = crmCustService;
        this.rmiPurPriceService = rmiPurPriceService;
        this.rmiCommonService = rmiCommonService;
        this.crmCustRepoProc = crmCustRepoProc;
    }
}

