/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.param.AreaVO;
import com.elitescloud.boot.excel.util.ExcelImportUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.ExectRecordService;
import com.elitesland.yst.production.sale.api.service.ExectRecordTempService;
import com.elitesland.yst.production.sale.api.service.SalesmanInfoService;
import com.elitesland.yst.production.sale.api.service.TaskInfoDtlService;
import com.elitesland.yst.production.sale.api.service.TaskInfoService;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanInfoSimpleQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.TaskInfoAppQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.TaskInfoDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.TaskInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.SalesmanInfoSimpleRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExectRecordTempRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskExecuteRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoCommonAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoDtlImportRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoDtlRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.save.TaskExecutionRecordSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.TaskInfoDtlSaveVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.TaskInfoDtlConvert;
import com.elitesland.yst.production.sale.entity.TaskInfoDtlDO;
import com.elitesland.yst.production.sale.repo.TaskInfoDtlRepo;
import com.elitesland.yst.production.sale.repo.TaskInfoDtlRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgAddrService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgStoreRpcService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiEmployeeRpcService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysAreaRpcService;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgAddressRpcDtoParam;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TaskInfoDtlServiceImpl
implements TaskInfoDtlService {
    private static final Logger log = LoggerFactory.getLogger(TaskInfoDtlServiceImpl.class);
    @Autowired
    private TaskInfoDtlRepo taskInfoDtlRepo;
    @Autowired
    private TaskInfoDtlRepoProc taskInfoDtlRepoProc;
    @Autowired
    private TaskInfoService taskInfoService;
    @Autowired
    private RmiEmployeeRpcService rmiEmployeeRpcService;
    @Autowired
    private RmiOrgStoreRpcService rmiOrgStoreRpcService;
    @Autowired
    private RmiSysAreaRpcService rmiSysAreaRpcService;
    @Autowired
    private CrmCustService crmCustService;
    @Autowired
    private SalesmanInfoService salesmanInfoService;
    @Autowired
    private RmiOrgAddrService rmiOrgAddrService;
    private ExectRecordService exectRecordService;
    private ExectRecordTempService exectRecordTempService;

    @Autowired
    @Lazy
    public void setExectRecordService(ExectRecordService exectRecordService) {
        this.exectRecordService = exectRecordService;
    }

    @Autowired
    @Lazy
    public void setExectRecordTempService(ExectRecordTempService exectRecordTempService) {
        this.exectRecordTempService = exectRecordTempService;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<Long> saveTaskInfoDtl(List<TaskInfoDtlSaveVO> saveVOList) {
        List taskInfoDtlDOList = saveVOList.stream().map(TaskInfoDtlConvert.INSTANCE::saveVoToDo).collect(Collectors.toList());
        return this.taskInfoDtlRepo.saveAll(taskInfoDtlDOList).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Long masId) {
        this.taskInfoDtlRepo.deleteByMasId(masId);
    }

    @SysCodeProc
    public List<TaskInfoDtlRespVO> selectByMasId(Long masId) {
        if (Objects.isNull(masId)) {
            return Collections.emptyList();
        }
        TaskInfoDtlQueryVO queryVO = new TaskInfoDtlQueryVO();
        queryVO.setMasId(masId);
        List<TaskInfoDtlRespVO> taskInfoDtlRespVOList = this.taskInfoDtlRepoProc.selectByQueryVO(queryVO);
        if (org.springframework.util.CollectionUtils.isEmpty(taskInfoDtlRespVOList)) {
            return Collections.emptyList();
        }
        this.translateTaskDtl(taskInfoDtlRespVOList);
        this.translateArea(taskInfoDtlRespVOList);
        return taskInfoDtlRespVOList;
    }

    private void translateTaskDtl(List<TaskInfoDtlRespVO> dtlRespVOList) {
        List dealerCodeList = dtlRespVOList.stream().map(TaskInfoDtlRespVO::getDealerCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List dealerList = this.crmCustService.getCustInfoByCustCodes(dealerCodeList);
        Set<String> executeUserCodeList = dtlRespVOList.stream().map(TaskInfoDtlRespVO::getExecutUserCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List<SysEmployeeBasicDTO> executeUserList = this.rmiEmployeeRpcService.findEmployeeByCodes(executeUserCodeList);
        List<Object> storeList = new ArrayList();
        List custList = new ArrayList();
        List<Object> employeeList = new ArrayList();
        Map<String, List<TaskInfoDtlRespVO>> businessTypeListMap = dtlRespVOList.stream().filter(dtlRespVO -> StringUtils.isNotBlank((CharSequence)dtlRespVO.getBusinessType())).collect(Collectors.groupingBy(TaskInfoDtlRespVO::getBusinessType));
        for (String key : businessTypeListMap.keySet()) {
            List<String> businessCodes = businessTypeListMap.get(key).stream().map(TaskInfoDtlRespVO::getBusinessCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (Objects.equals(key, UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_STORE.getValueCode())) {
                storeList = this.rmiOrgStoreRpcService.findStoreByStoreCodes(businessCodes);
                continue;
            }
            if (Objects.equals(key, UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_DEALER.getValueCode())) {
                custList = this.crmCustService.getCustInfoByCustCodes(businessCodes);
                continue;
            }
            if (!Objects.equals(key, UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_SALESMAN.getValueCode())) continue;
            Set<String> businessCodeSet = businessCodes.stream().collect(Collectors.toSet());
            employeeList = this.rmiEmployeeRpcService.findEmployeeByCodes(businessCodeSet);
        }
        for (TaskInfoDtlRespVO respVO : dtlRespVOList) {
            if (Objects.equals(respVO.getBusinessType(), UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_STORE.getValueCode())) {
                Optional<OrgStoreDetailRpcDTO> storeOptional = storeList.stream().filter(storeVO -> Objects.equals(storeVO.getStoreCode(), respVO.getBusinessCode())).findFirst();
                storeOptional.ifPresent(storeVO -> {
                    respVO.setBusinessName(storeVO.getStoreName());
                    respVO.setContactName(storeVO.getStoreManager());
                    respVO.setContactPhone(storeVO.getStoreContPhone());
                });
            }
            if (Objects.equals(respVO.getBusinessType(), UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_DEALER.getValueCode())) {
                Optional<LmSaveCustRespVO> custOptional = custList.stream().filter(custVO -> Objects.equals(custVO.getCustCode(), respVO.getBusinessCode())).findFirst();
                custOptional.ifPresent(custVO -> {
                    respVO.setBusinessName(custVO.getCustName());
                    respVO.setCustCode2(custVO.getCustCode2());
                    respVO.setContactName(custVO.getContactName());
                    respVO.setContactPhone(custVO.getContactPhone());
                });
            }
            if (Objects.equals(respVO.getBusinessType(), UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_SALESMAN.getValueCode())) {
                Optional<SysEmployeeBasicDTO> employeeOptional = employeeList.stream().filter(employeeVO -> Objects.equals(employeeVO.getCode(), respVO.getBusinessCode())).findFirst();
                employeeOptional.ifPresent(employeeVO -> {
                    respVO.setBusinessName(employeeVO.getFullName());
                    respVO.setContactName(employeeVO.getFullName());
                    respVO.setContactPhone(employeeVO.getPhone());
                });
            }
            Optional<LmSaveCustRespVO> dealerOptional = dealerList.stream().filter(dealerVO -> Objects.equals(dealerVO.getCustCode(), respVO.getDealerCode())).findFirst();
            dealerOptional.ifPresent(dealerVO -> respVO.setDealerName(dealerVO.getCustName()));
            Optional<SysEmployeeBasicDTO> executeUserOptional = executeUserList.stream().filter(executeUser -> Objects.equals(executeUser.getCode(), respVO.getExecutUserCode())).findFirst();
            executeUserOptional.ifPresent(executeUser -> respVO.setExecutUser(executeUser.getFullName()));
        }
    }

    private void translateArea(List<TaskInfoDtlRespVO> dtlRespVOList) {
        Set provinces = dtlRespVOList.stream().map(TaskInfoDtlRespVO::getProvince).distinct().filter(Objects::nonNull).collect(Collectors.toSet());
        Set cities = dtlRespVOList.stream().map(TaskInfoDtlRespVO::getCity).distinct().filter(Objects::nonNull).collect(Collectors.toSet());
        Set counties = dtlRespVOList.stream().map(TaskInfoDtlRespVO::getDistrict).distinct().filter(Objects::nonNull).collect(Collectors.toSet());
        HashSet<String> areaCodes = new HashSet<String>();
        areaCodes.addAll(provinces);
        areaCodes.addAll(cities);
        areaCodes.addAll(counties);
        List<SysAreaRespDTO> areaList = this.rmiSysAreaRpcService.findAreaByCodes(areaCodes);
        dtlRespVOList.forEach(dtlRespVO -> {
            Optional<SysAreaRespDTO> areaOptional1 = areaList.stream().filter(d -> Objects.equals(d.getAreaCode(), dtlRespVO.getProvince())).findFirst();
            areaOptional1.ifPresent(areaRespDTO -> dtlRespVO.setProvinceName(areaRespDTO.getAreaName()));
            Optional<SysAreaRespDTO> areaOptional2 = areaList.stream().filter(d -> Objects.equals(d.getAreaCode(), dtlRespVO.getCity())).findFirst();
            areaOptional2.ifPresent(areaRespDTO -> dtlRespVO.setCityName(areaRespDTO.getAreaName()));
            Optional<SysAreaRespDTO> areaOptional3 = areaList.stream().filter(d -> Objects.equals(d.getAreaCode(), dtlRespVO.getDistrict())).findFirst();
            areaOptional3.ifPresent(areaRespDTO -> dtlRespVO.setDistrictName(areaRespDTO.getAreaName()));
        });
    }

    @SysCodeProc
    public TaskInfoDtlRespVO selectById(Long id) {
        if (Objects.isNull(id)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4efb\u52a1\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Optional optional = this.taskInfoDtlRepo.findById(id);
        if (optional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u660e\u7ec6\u6570\u636e\u4fe1\u606f!");
        }
        TaskInfoDtlRespVO taskInfoDtlRespVO = TaskInfoDtlConvert.INSTANCE.doToRespVo((TaskInfoDtlDO)((Object)optional.get()));
        this.translateTaskDtl(Collections.singletonList(taskInfoDtlRespVO));
        this.translateArea(Collections.singletonList(taskInfoDtlRespVO));
        return taskInfoDtlRespVO;
    }

    @SysCodeProc
    public TaskInfoDtlRespVO findById(Long id) {
        if (Objects.isNull(id)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4efb\u52a1\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        TaskInfoDtlQueryVO dtlQueryVO = new TaskInfoDtlQueryVO();
        dtlQueryVO.setId(id);
        List<TaskInfoDtlRespVO> dtlRespVOList = this.taskInfoDtlRepoProc.selectByQueryVO(dtlQueryVO);
        if (org.springframework.util.CollectionUtils.isEmpty(dtlRespVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u660e\u7ec6\u6570\u636e\u4fe1\u606f!");
        }
        if (dtlRespVOList.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u67e5\u8be2\u5230\u591a\u6761\u4efb\u52a1\u660e\u7ec6\u6570\u636e\u4fe1\u606f!");
        }
        TaskInfoDtlRespVO taskInfoDtlRespVO = dtlRespVOList.get(0);
        return taskInfoDtlRespVO;
    }

    @SysCodeProc
    public List<TaskInfoDtlRespVO> selectByParam(TaskInfoDtlQueryVO queryVO) {
        List<TaskInfoDtlRespVO> taskInfoDtlRespVOList = this.taskInfoDtlRepoProc.selectByQueryVO(queryVO);
        if (org.springframework.util.CollectionUtils.isEmpty(taskInfoDtlRespVOList)) {
            return Collections.emptyList();
        }
        return taskInfoDtlRespVOList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlag(Integer deleteFlag, Long masId) {
        this.taskInfoDtlRepoProc.updateDeleteFlag(deleteFlag, masId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> masIds) {
        this.taskInfoDtlRepoProc.updateDeleteFlagBatch(deleteFlag, masIds);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateCompleteStateByMasId(String completeState, Long masId) {
        this.taskInfoDtlRepoProc.updateCompleteStateByMasId(completeState, masId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateCompleteStateAndTimeByMasId(String completeState, LocalDateTime completeTime, Long masId) {
        this.taskInfoDtlRepoProc.updateCompleteStateAndCompleteTimeByMasId(completeState, completeTime, masId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateCompleteStateAndTimeByIdBatch(String completeState, LocalDateTime completeTime, List<Long> ids) {
        this.taskInfoDtlRepoProc.updateCompleteStateAndTimeByIdBatch(completeState, completeTime, ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateCompleteStateByIdBatch(String completeState, List<Long> ids) {
        this.taskInfoDtlRepoProc.updateCompleteStateByIdBatch(completeState, ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDelayFlagByIdBatch(String delayFlag, List<Long> ids) {
        this.taskInfoDtlRepoProc.updateDelayFlagByIdBatch(delayFlag, ids);
    }

    public TaskExecuteRespVO taskDtlExecuteCheck(Long id, Boolean checkSignFlag) {
        Optional optional = this.taskInfoDtlRepo.findById(id);
        if (optional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u660e\u7ec6\u6570\u636e\u4fe1\u606f!");
        }
        TaskInfoDtlRespVO dtlRespVO = TaskInfoDtlConvert.INSTANCE.doToRespVo((TaskInfoDtlDO)((Object)optional.get()));
        if (!Objects.equals(dtlRespVO.getCompleteState(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WEE.getValueCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4efb\u52a1\u660e\u7ec6\u662f\u5f85\u6267\u884c\u72b6\u6001\u7684\u624d\u53ef\u6267\u884c!");
        }
        TaskInfoRespVO respVO = this.taskInfoService.findById(dtlRespVO.getMasId());
        if (Objects.isNull(respVO.getStartTime())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a!");
        }
        boolean startTimeFlag = LocalDateTime.now().isBefore(respVO.getStartTime());
        if (startTimeFlag) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6b64\u4efb\u52a1\u8fd8\u672a\u5f00\u59cb!");
        }
        SysUserDTO sysUserDTO = this.getSysUser();
        if (Objects.isNull(dtlRespVO.getExecutUserCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6267\u884c\u4eba\u4e3a\u7a7a!");
        }
        SysEmployeeBasicDTO employeeBasicDTO = this.getEmployeeByUser(sysUserDTO);
        if (!Objects.equals(dtlRespVO.getExecutUserCode(), employeeBasicDTO.getCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u6307\u6d3e\u7ed9\u81ea\u5df1\u7684\u4efb\u52a1\u660e\u7ec6\u8fdb\u884c\u6267\u884c!");
        }
        if (checkSignFlag.booleanValue() && Objects.equals(respVO.getForceSignFlag(), UdcEnum.SALESMAN_TASK_FORCE_SIGN_FLAG_Y.getValueCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4efb\u52a1\u9700\u8981\u5b9a\u4f4d\u6253\u5361,\u8bf7\u5728\u4e1a\u52a1\u5458APP\u8fdb\u884c\u64cd\u4f5c!");
        }
        if (Objects.equals(dtlRespVO.getBusinessType(), UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_STORE.getValueCode())) {
            List<OrgStoreDetailRpcDTO> storeList = this.rmiOrgStoreRpcService.findStoreByStoreCodes(Collections.singletonList(dtlRespVO.getBusinessCode()));
            if (!org.springframework.util.CollectionUtils.isEmpty(storeList)) {
                dtlRespVO.setContactName(storeList.get(0).getStoreManager());
                dtlRespVO.setContactPhone(storeList.get(0).getStoreContPhone());
            }
        } else if (Objects.equals(dtlRespVO.getBusinessType(), UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_DEALER.getValueCode())) {
            List custList = this.crmCustService.getCustInfoByCustCodes(Collections.singletonList(dtlRespVO.getBusinessCode()));
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)custList)) {
                dtlRespVO.setContactName(((LmSaveCustRespVO)custList.get(0)).getContactName());
                dtlRespVO.setContactPhone(((LmSaveCustRespVO)custList.get(0)).getContactPhone());
            }
        } else if (Objects.equals(dtlRespVO.getBusinessType(), UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_SALESMAN.getValueCode())) {
            Set<String> businessCodeSet = Collections.singletonList(dtlRespVO.getBusinessCode()).stream().collect(Collectors.toSet());
            List<SysEmployeeBasicDTO> employeeList = this.rmiEmployeeRpcService.findEmployeeByCodes(businessCodeSet);
            dtlRespVO.setContactName(dtlRespVO.getBusinessName());
            if (!org.springframework.util.CollectionUtils.isEmpty(employeeList)) {
                dtlRespVO.setContactPhone(employeeList.get(0).getPhone());
            }
        }
        return this.assembleExecute(respVO, dtlRespVO);
    }

    private SysEmployeeBasicDTO getEmployeeByUser(SysUserDTO sysUserDTO) {
        if (Objects.isNull(sysUserDTO)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a!");
        }
        SysEmployeeBasicDTO employeeBasicDTO = this.rmiEmployeeRpcService.findEmployeeByUserId(sysUserDTO.getId());
        if (Objects.isNull(employeeBasicDTO)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u6240\u5c5e\u5458\u5de5\u4fe1\u606f\u4e3a\u7a7a!");
        }
        return employeeBasicDTO;
    }

    private TaskExecuteRespVO assembleExecute(TaskInfoRespVO respVO, TaskInfoDtlRespVO dtlRespVO) {
        TaskExecuteRespVO taskExecuteRespVO = new TaskExecuteRespVO();
        taskExecuteRespVO.setTaskId(respVO.getId());
        taskExecuteRespVO.setTaskCode(respVO.getCode());
        taskExecuteRespVO.setTaskName(respVO.getName());
        taskExecuteRespVO.setTaskType(respVO.getType());
        taskExecuteRespVO.setTaskTypeName(respVO.getTypeName());
        taskExecuteRespVO.setStartTime(respVO.getStartTime());
        taskExecuteRespVO.setEndTime(respVO.getEndTime());
        taskExecuteRespVO.setPublishUser(respVO.getPublishUser());
        taskExecuteRespVO.setPublishUserId(respVO.getPublishUserId());
        taskExecuteRespVO.setPublishUserCode(respVO.getPublishUserCode());
        taskExecuteRespVO.setExecutTemplate(respVO.getExecutTemplate());
        taskExecuteRespVO.setExecutTemplateId(respVO.getExecutTemplateId());
        taskExecuteRespVO.setExecutTemplateCode(respVO.getExecutTemplateCode());
        taskExecuteRespVO.setExecutTemplateName(respVO.getExecutTemplateName());
        taskExecuteRespVO.setForceSignFlag(respVO.getForceSignFlag());
        taskExecuteRespVO.setSignInRange(respVO.getSignInRange());
        taskExecuteRespVO.setSignOutRange(respVO.getSignOutRange());
        taskExecuteRespVO.setTaskDtlId(dtlRespVO.getId());
        taskExecuteRespVO.setExecutUser(dtlRespVO.getExecutUser());
        taskExecuteRespVO.setExecutUserId(dtlRespVO.getExecutUserId());
        taskExecuteRespVO.setExecutUserCode(dtlRespVO.getExecutUserCode());
        taskExecuteRespVO.setBusinessType(dtlRespVO.getBusinessType());
        taskExecuteRespVO.setBusinessCode(dtlRespVO.getBusinessCode());
        taskExecuteRespVO.setBusinessName(dtlRespVO.getBusinessName());
        taskExecuteRespVO.setBusinessTime(dtlRespVO.getBusinessTime());
        taskExecuteRespVO.setXLon(dtlRespVO.getXLon());
        taskExecuteRespVO.setYLat(dtlRespVO.getYLat());
        taskExecuteRespVO.setCoordType(dtlRespVO.getCoordType());
        taskExecuteRespVO.setEmployeeId(dtlRespVO.getEmployeeId());
        taskExecuteRespVO.setContactName(dtlRespVO.getContactName());
        taskExecuteRespVO.setContactPhone(dtlRespVO.getContactPhone());
        taskExecuteRespVO.setDealerName(dtlRespVO.getDealerName());
        taskExecuteRespVO.setDealerCode(dtlRespVO.getDealerCode());
        return taskExecuteRespVO;
    }

    public Boolean closeCheckTaskBatch(List<Long> ids) {
        TaskInfoRespVO respVO = this.closeCheckSelect(ids);
        List dtlVOList = respVO.getDtlRespVOList();
        List recordCode = dtlVOList.stream().map(TaskInfoDtlRespVO::getExecutRecordCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        boolean recordFlag = this.taskInfoService.selectExecutionRecordCheck(recordCode);
        if (recordFlag) {
            return false;
        }
        return true;
    }

    private TaskInfoRespVO closeCheckSelect(List<Long> ids) {
        TaskInfoDtlQueryVO dtlQueryVO = new TaskInfoDtlQueryVO();
        dtlQueryVO.setIds(ids);
        List<TaskInfoDtlRespVO> dtlVOList = this.selectByParam(dtlQueryVO);
        if (org.springframework.util.CollectionUtils.isEmpty(dtlVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u660e\u7ec6\u6570\u636e!");
        }
        ArrayList completionStatusList = Lists.newArrayList((Object[])new String[]{UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CPD.getValueCode(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CSD.getValueCode(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CCD.getValueCode()});
        boolean completionStatusFlag = dtlVOList.stream().anyMatch(dtlVo -> completionStatusList.contains(dtlVo.getCompleteState()));
        if (completionStatusFlag) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u72b6\u6001\u975e\u5df2\u5173\u95ed\u3001\u5df2\u5b8c\u6210\u3001\u5df2\u53d6\u6d88\u7684\u624d\u53ef\u6267\u884c\u5173\u95ed!");
        }
        List masIds = dtlVOList.stream().map(TaskInfoDtlRespVO::getMasId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (masIds.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u76f8\u540c\u4efb\u52a1\u4e3b\u8868\u7684\u4efb\u52a1\u660e\u7ec6!");
        }
        TaskInfoRespVO respVO = this.taskInfoService.findById((Long)masIds.get(0));
        if (Objects.isNull(respVO)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u4e3b\u8868\u6570\u636e!");
        }
        ArrayList taskStatusList = Lists.newArrayList((Object[])new String[]{UdcEnum.SALESMAN_TASK_STATUS_CPD.getValueCode(), UdcEnum.SALESMAN_TASK_STATUS_CCD.getValueCode(), UdcEnum.SALESMAN_TASK_STATUS_CSD.getValueCode()});
        if (taskStatusList.contains(respVO.getState())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4efb\u52a1\u4e3b\u8868\u72b6\u6001\u975e\u5df2\u5b8c\u6210\u3001\u5df2\u5173\u95ed\u3001\u5df2\u53d6\u6d88\u7684\u624d\u53ef\u6267\u884c\u5173\u95ed!");
        }
        respVO.setDtlRespVOList(dtlVOList);
        return respVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void closeTaskBatch(List<Long> ids) {
        TaskInfoRespVO respVO = this.closeCheckSelect(ids);
        List dtlVOList = respVO.getDtlRespVOList();
        this.updateCompleteStateByIdBatch(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CSD.getValueCode(), ids);
        this.closeUpdateExecuteRecord(dtlVOList);
        List<TaskInfoDtlRespVO> dtlAllVoList = this.selectByMasId(respVO.getId());
        boolean completionStatusFlag1 = dtlAllVoList.stream().allMatch(dtlVo -> Objects.equals(dtlVo.getCompleteState(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CSD.getValueCode()));
        if (completionStatusFlag1) {
            this.taskInfoService.updateStateById(UdcEnum.SALESMAN_TASK_STATUS_CSD.getValueCode(), respVO.getId());
        } else {
            ArrayList completionStatusList = Lists.newArrayList((Object[])new String[]{UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CPD.getValueCode(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CSD.getValueCode()});
            boolean completionStatusFlag = dtlAllVoList.stream().allMatch(dtlVo -> completionStatusList.contains(dtlVo.getCompleteState()));
            if (completionStatusFlag) {
                this.taskInfoService.updateStateAndCompleteTime(UdcEnum.SALESMAN_TASK_STATUS_CPD.getValueCode(), LocalDateTime.now(), respVO.getId());
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void del(List<Long> ids) {
        this.taskInfoDtlRepo.deleteAllById(ids);
    }

    private void closeUpdateExecuteRecord(List<TaskInfoDtlRespVO> dtlRespVOList) {
        List recordCodes = dtlRespVOList.stream().map(TaskInfoDtlRespVO::getExecutRecordCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (!org.springframework.util.CollectionUtils.isEmpty(recordCodes)) {
            this.exectRecordService.close(recordCodes);
        }
    }

    @SysCodeProc
    public PagingVO<TaskInfoDtlRespVO> page(TaskInfoDtlQueryVO pageParam) {
        PagingVO<TaskInfoDtlRespVO> pagingVO = this.taskInfoDtlRepoProc.page(pageParam);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List dtlRespVOList = pagingVO.getRecords();
        this.translateTaskDtl(dtlRespVOList);
        this.translateArea(dtlRespVOList);
        return PagingVO.builder().total(pagingVO.getTotal()).records(dtlRespVOList).build();
    }

    private void transitionDtlToCodes(List<TaskInfoDtlRespVO> respVOList) {
        respVOList.forEach(respVO -> {});
    }

    @Transactional(rollbackFor={Exception.class})
    public List<Long> updateExecuteUserBatch(TaskInfoDtlSaveVO saveVO) {
        TaskInfoDtlQueryVO dtlQueryVO = new TaskInfoDtlQueryVO();
        dtlQueryVO.setIds(saveVO.getIds());
        List<TaskInfoDtlRespVO> dtlVOList = this.selectByParam(dtlQueryVO);
        if (org.springframework.util.CollectionUtils.isEmpty(dtlVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u660e\u7ec6\u6570\u636e!");
        }
        ArrayList completionStatusList = Lists.newArrayList((Object[])new String[]{UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WRE.getValueCode(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WEE.getValueCode()});
        boolean completionStatusFlag = dtlVOList.stream().allMatch(dtlVo -> completionStatusList.contains(dtlVo.getCompleteState()));
        if (!completionStatusFlag) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u72b6\u6001\u5f85\u53d1\u5e03\u3001\u5f85\u6267\u884c\u7684\u624d\u53ef\u5206\u914d\u6267\u884c\u4eba!");
        }
        List masIds = dtlVOList.stream().map(TaskInfoDtlRespVO::getMasId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (masIds.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u76f8\u540c\u4efb\u52a1\u4e3b\u8868\u7684\u4efb\u52a1\u660e\u7ec6!");
        }
        TaskInfoRespVO respVO = this.taskInfoService.findById((Long)masIds.get(0));
        if (Objects.isNull(respVO)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u4e3b\u8868\u6570\u636e!");
        }
        ArrayList taskStatusList = Lists.newArrayList((Object[])new String[]{UdcEnum.SALESMAN_TASK_STATUS_CPD.getValueCode(), UdcEnum.SALESMAN_TASK_STATUS_CCD.getValueCode(), UdcEnum.SALESMAN_TASK_STATUS_CSD.getValueCode()});
        if (taskStatusList.contains(respVO.getState())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4efb\u52a1\u4e3b\u8868\u72b6\u6001\u975e\u5df2\u5b8c\u6210\u3001\u5df2\u5173\u95ed\u3001\u5df2\u53d6\u6d88\u7684\u624d\u53ef\u5206\u914d\u6267\u884c\u4eba!");
        }
        this.taskInfoDtlRepoProc.updateExecuteUserByIdBatch(saveVO.getExecutUser(), saveVO.getExecutUserId(), saveVO.getExecutUserCode(), null, saveVO.getIds());
        return saveVO.getIds();
    }

    public Long selectEmployeeIdByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e1a\u52a1\u5458\u7f16\u7801\u4e3a\u7a7a!");
        }
        SysEmployeeBasicDTO employeeBasicDTO = this.rmiEmployeeRpcService.findEmployeeByCode(code);
        if (Objects.isNull(employeeBasicDTO) || Objects.isNull(employeeBasicDTO.getId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u5458\u7684\u5458\u5de5\u4fe1\u606f!");
        }
        return employeeBasicDTO.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public List<TaskInfoDtlRespVO> importTaskInfoDtl(MultipartFile file) {
        if (file == null || file.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u5bfc\u5165\u6587\u4ef6!");
        }
        Integer headRow = 2;
        Integer dataTypeAttr = 2;
        List dataList = null;
        try {
            dataList = ExcelImportUtil.instance((InputStream)file.getInputStream()).headRow(headRow).dataType(TaskInfoDtlImportRespVO.class, dataTypeAttr).readAllSync();
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u660e\u7ec6\u5bfc\u5165\u5931\u8d25:", (Throwable)e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4efb\u52a1\u660e\u7ec6\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
        }
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)dataList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!");
        }
        AtomicInteger sheetCount = new AtomicInteger(1);
        dataList.forEach(dtlRespVO -> {
            sheetCount.addAndGet(1);
            if (StringUtils.isBlank((CharSequence)dtlRespVO.getBusinessTypeName()) || StringUtils.isBlank((CharSequence)dtlRespVO.getBusinessCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7b2c" + sheetCount + "\u884c\u6570\u636e\u5b58\u5728\u7a7a\u503c,\u8bf7\u68c0\u67e5!");
            }
            if (!ConstantsSale.SALESMAN_TASK_BUSINESS_TYPE_NAME_LIST.contains(dtlRespVO.getBusinessTypeName())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7b2c" + sheetCount + "\u884c\u6570\u636e\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5!");
            }
        });
        List<TaskInfoDtlRespVO> taskInfoDtlRespVOList = this.disposeImportTaskDtl(dataList);
        return taskInfoDtlRespVOList;
    }

    public List<TaskInfoDtlRespVO> disposeImportTaskDtl(List<TaskInfoDtlImportRespVO> dataList) {
        ArrayList<TaskInfoDtlImportRespVO> errorDataList = new ArrayList<TaskInfoDtlImportRespVO>();
        ArrayList<TaskInfoDtlImportRespVO> successDataList = new ArrayList<TaskInfoDtlImportRespVO>();
        Map<String, List<TaskInfoDtlImportRespVO>> importListMap = dataList.stream().filter(dtlRespVO -> Objects.nonNull(dtlRespVO.getBusinessTypeName())).collect(Collectors.groupingBy(TaskInfoDtlImportRespVO::getBusinessTypeName));
        for (String key : importListMap.keySet()) {
            List<TaskInfoDtlImportRespVO> importDataList = importListMap.get(key);
            List<String> businessCodes = importDataList.stream().map(TaskInfoDtlImportRespVO::getBusinessCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (Objects.equals(UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_STORE.getValueCodeName(), key)) {
                List<OrgStoreDetailRpcDTO> storeRespVOList = new ArrayList<OrgStoreDetailRpcDTO>();
                if (!org.springframework.util.CollectionUtils.isEmpty(businessCodes)) {
                    storeRespVOList = this.selectStore(businessCodes);
                }
                this.disposeStoreImport(importDataList, storeRespVOList, errorDataList, successDataList);
                continue;
            }
            if (Objects.equals(UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_DEALER.getValueCodeName(), key)) {
                List<LmSaveCustRespVO> custRespVOList = new ArrayList<LmSaveCustRespVO>();
                if (!org.springframework.util.CollectionUtils.isEmpty(businessCodes)) {
                    custRespVOList = this.selectCustByCustCode2(businessCodes);
                }
                this.disposeCustImport(importDataList, custRespVOList, errorDataList, successDataList);
                continue;
            }
            if (!Objects.equals(UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_SALESMAN.getValueCodeName(), key)) continue;
            List<SalesmanInfoSimpleRespVO> salesmanRespVOList = new ArrayList<SalesmanInfoSimpleRespVO>();
            if (!org.springframework.util.CollectionUtils.isEmpty(businessCodes)) {
                salesmanRespVOList = this.selectSalesman(businessCodes);
            }
            this.disposeSalesmanImport(importDataList, salesmanRespVOList, errorDataList, successDataList);
        }
        this.checkImportTaskDtl(errorDataList);
        List<TaskInfoDtlRespVO> taskInfoDtlRespVOList = this.assembleImportTaskDtl(successDataList);
        return taskInfoDtlRespVOList;
    }

    public void disposeStoreImport(List<TaskInfoDtlImportRespVO> dataList, List<OrgStoreDetailRpcDTO> storeRespVOList, List<TaskInfoDtlImportRespVO> errorDataList, List<TaskInfoDtlImportRespVO> successDataList) {
        for (TaskInfoDtlImportRespVO dtlRespVO : dataList) {
            Optional<OrgStoreDetailRpcDTO> storeOptional = storeRespVOList.stream().filter(storeRespVO -> Objects.equals(storeRespVO.getStoreCode(), dtlRespVO.getBusinessCode())).findFirst();
            if (storeOptional.isPresent()) {
                OrgStoreDetailRpcDTO storeRespVO2 = storeOptional.get();
                dtlRespVO.setBusinessType(UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_STORE.getValueCode());
                dtlRespVO.setBusinessTypeName(dtlRespVO.getBusinessTypeName());
                dtlRespVO.setBusinessId(storeRespVO2.getId());
                dtlRespVO.setCustCode2(storeRespVO2.getCustCode2());
                dtlRespVO.setBusinessName(storeRespVO2.getStoreName());
                dtlRespVO.setDealerCode(storeRespVO2.getCustCode());
                dtlRespVO.setDealerName(storeRespVO2.getCustName());
                dtlRespVO.setBusinessTime(storeRespVO2.getOpenTimeSpan());
                OrgAddrAddressRpcDTO orgAddrAddressRpcDTO = storeRespVO2.getAddressRpcDTO();
                if (Objects.nonNull(orgAddrAddressRpcDTO)) {
                    dtlRespVO.setProvince(orgAddrAddressRpcDTO.getProvince());
                    dtlRespVO.setProvinceName(orgAddrAddressRpcDTO.getProvinceName());
                    dtlRespVO.setCity(orgAddrAddressRpcDTO.getCity());
                    dtlRespVO.setCityName(orgAddrAddressRpcDTO.getCityName());
                    dtlRespVO.setDistrict(orgAddrAddressRpcDTO.getCounty());
                    dtlRespVO.setDistrictName(orgAddrAddressRpcDTO.getCountyName());
                    dtlRespVO.setAddress(orgAddrAddressRpcDTO.getDetailAddr());
                }
                dtlRespVO.setAssociatedExecutorCode(storeRespVO2.getAgentEmpCode());
                if (Objects.nonNull(storeRespVO2.getAddressRpcDTO())) {
                    OrgAddrAddressRpcDTO addressRpcDTO = storeRespVO2.getAddressRpcDTO();
                    dtlRespVO.setXLon(addressRpcDTO.getXLon());
                    dtlRespVO.setYLat(addressRpcDTO.getYLat());
                    dtlRespVO.setCoordType(null);
                }
                dtlRespVO.setContactName(storeRespVO2.getStoreManager());
                dtlRespVO.setContactPhone(storeRespVO2.getStoreContPhone());
                successDataList.add(dtlRespVO);
                continue;
            }
            errorDataList.add(dtlRespVO);
        }
    }

    public void disposeCustImport(List<TaskInfoDtlImportRespVO> dataList, List<LmSaveCustRespVO> custRespVOList, List<TaskInfoDtlImportRespVO> errorDataList, List<TaskInfoDtlImportRespVO> successDataList) {
        for (TaskInfoDtlImportRespVO dtlRespVO : dataList) {
            Optional<LmSaveCustRespVO> custOptional = custRespVOList.stream().filter(custRespVO -> Objects.equals(custRespVO.getCustCode2(), dtlRespVO.getBusinessCode())).findFirst();
            if (custOptional.isPresent()) {
                LmSaveCustRespVO custRespVO2 = custOptional.get();
                dtlRespVO.setBusinessType(UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_DEALER.getValueCode());
                dtlRespVO.setBusinessTypeName(dtlRespVO.getBusinessTypeName());
                dtlRespVO.setBusinessCode(custRespVO2.getCustCode());
                dtlRespVO.setBusinessId(custRespVO2.getId());
                dtlRespVO.setCustCode2(custRespVO2.getCustCode2());
                dtlRespVO.setBusinessName(custRespVO2.getCustName());
                dtlRespVO.setAddrNo(custRespVO2.getAddrNo());
                dtlRespVO.setAssociatedExecutorId(custRespVO2.getAgentEmpId());
                dtlRespVO.setXLon(null);
                dtlRespVO.setYLat(null);
                dtlRespVO.setCoordType(null);
                dtlRespVO.setContactName(custRespVO2.getContactName());
                dtlRespVO.setContactPhone(custRespVO2.getContactPhone());
                successDataList.add(dtlRespVO);
                continue;
            }
            errorDataList.add(dtlRespVO);
        }
    }

    public void disposeSalesmanImport(List<TaskInfoDtlImportRespVO> dataList, List<SalesmanInfoSimpleRespVO> salesmanRespVOList, List<TaskInfoDtlImportRespVO> errorDataList, List<TaskInfoDtlImportRespVO> successDataList) {
        for (TaskInfoDtlImportRespVO dtlRespVO : dataList) {
            Optional<SalesmanInfoSimpleRespVO> salesmanOptional = salesmanRespVOList.stream().filter(salesmanRespVO -> Objects.equals(salesmanRespVO.getSalesmanNo(), dtlRespVO.getBusinessCode())).findFirst();
            if (salesmanOptional.isPresent()) {
                SalesmanInfoSimpleRespVO salesmanRespVO2 = salesmanOptional.get();
                dtlRespVO.setBusinessType(UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_SALESMAN.getValueCode());
                dtlRespVO.setBusinessTypeName(dtlRespVO.getBusinessTypeName());
                dtlRespVO.setBusinessId(salesmanRespVO2.getId());
                dtlRespVO.setBusinessName(salesmanRespVO2.getFullName());
                dtlRespVO.setAddress(salesmanRespVO2.getAddress());
                AreaVO areaVO = salesmanRespVO2.getAreaVO();
                if (Objects.nonNull(areaVO)) {
                    dtlRespVO.setProvince(areaVO.getProvinceCode());
                    dtlRespVO.setProvinceName(areaVO.getProvinceName());
                    dtlRespVO.setCity(areaVO.getCityCode());
                    dtlRespVO.setCityName(areaVO.getCityName());
                    dtlRespVO.setDistrict(areaVO.getCountyCode());
                    dtlRespVO.setDistrictName(areaVO.getCountyName());
                }
                dtlRespVO.setAssociatedExecutorCode(salesmanRespVO2.getSalesmanNo());
                dtlRespVO.setExecutUser(salesmanRespVO2.getFullName());
                dtlRespVO.setExecutUserId(salesmanRespVO2.getId());
                dtlRespVO.setXLon(null);
                dtlRespVO.setYLat(null);
                dtlRespVO.setCoordType(null);
                dtlRespVO.setContactName(salesmanRespVO2.getFullName());
                dtlRespVO.setContactPhone(salesmanRespVO2.getPhone());
                successDataList.add(dtlRespVO);
                continue;
            }
            errorDataList.add(dtlRespVO);
        }
    }

    public List<TaskInfoDtlRespVO> assembleImportTaskDtl(List<TaskInfoDtlImportRespVO> dataList) {
        List associatedExecutorIds = dataList.stream().map(TaskInfoDtlImportRespVO::getAssociatedExecutorId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArrayList<SalesmanInfoSimpleRespVO> custSalesmanVoList = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty(associatedExecutorIds)) {
            SalesmanInfoSimpleQueryVO salesmanQuery1VO = new SalesmanInfoSimpleQueryVO();
            salesmanQuery1VO.setIds(associatedExecutorIds);
            custSalesmanVoList = this.salesmanInfoService.simpleQuery(salesmanQuery1VO);
        }
        List executUserCodes = dataList.stream().map(TaskInfoDtlImportRespVO::getExecutUserCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List associatedExecutorCodes = dataList.stream().map(TaskInfoDtlImportRespVO::getAssociatedExecutorCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List executUserCodeList = Stream.of(executUserCodes, associatedExecutorCodes).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArrayList<SalesmanInfoSimpleRespVO> salesmanVoList = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty(executUserCodeList)) {
            SalesmanInfoSimpleQueryVO salesmanQuery2VO = new SalesmanInfoSimpleQueryVO();
            salesmanQuery2VO.setCodes(executUserCodeList);
            salesmanVoList = this.salesmanInfoService.simpleQuery(salesmanQuery2VO);
        }
        List addrNos = dataList.stream().map(TaskInfoDtlImportRespVO::getAddrNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArrayList<OrgAddressRpcDTO> orgAddressRpcDTOList = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty(addrNos)) {
            OrgAddressRpcDtoParam orgAddressRpcDtoParam = new OrgAddressRpcDtoParam();
            orgAddressRpcDtoParam.setAddrNos(addrNos);
            orgAddressRpcDTOList = this.rmiOrgAddrService.findAddrAddressListByParam(orgAddressRpcDtoParam);
        }
        ArrayList<TaskInfoDtlImportRespVO> errorDataList = new ArrayList<TaskInfoDtlImportRespVO>();
        for (TaskInfoDtlImportRespVO dtlRespVO : dataList) {
            dtlRespVO.setCompleteState(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WRE.getValueCode());
            dtlRespVO.setCompleteStateName(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WRE.getValueCodeName());
            dtlRespVO.setDelayFlag(UdcEnum.SALESMAN_TASK_DELAY_FLAG_N.getValueCode());
            dtlRespVO.setDelayFlagName(UdcEnum.SALESMAN_TASK_DELAY_FLAG_N.getValueCodeName());
            if (Objects.equals(UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_STORE.getValueCodeName(), dtlRespVO.getBusinessTypeName())) {
                this.fillStoreDtl(dtlRespVO, salesmanVoList, errorDataList);
                continue;
            }
            if (Objects.equals(UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_DEALER.getValueCodeName(), dtlRespVO.getBusinessTypeName())) {
                this.fillCustDtl(dtlRespVO, orgAddressRpcDTOList, custSalesmanVoList, salesmanVoList, errorDataList);
                continue;
            }
            if (!Objects.equals(UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_SALESMAN.getValueCodeName(), dtlRespVO.getBusinessTypeName())) continue;
            this.fillSalesmanDtl(dtlRespVO, salesmanVoList, errorDataList);
        }
        this.checkImportTaskDtlExecuteUser(errorDataList);
        List<TaskInfoDtlRespVO> taskInfoDtlDOList = dataList.stream().map(TaskInfoDtlConvert.INSTANCE::importVoToRespVo).collect(Collectors.toList());
        return taskInfoDtlDOList;
    }

    public void fillStoreDtl(TaskInfoDtlImportRespVO dtlRespVO, List<SalesmanInfoSimpleRespVO> salesmanVoList, List<TaskInfoDtlImportRespVO> errorDataList) {
        if (StringUtils.isBlank((CharSequence)dtlRespVO.getExecutUserCode())) {
            Optional<SalesmanInfoSimpleRespVO> salesmanOptional = salesmanVoList.stream().filter(salesmanVo -> Objects.equals(salesmanVo.getSalesmanNo(), dtlRespVO.getAssociatedExecutorCode())).findFirst();
            if (salesmanOptional.isPresent()) {
                SalesmanInfoSimpleRespVO salesmanVo2 = salesmanOptional.get();
                dtlRespVO.setExecutUserCode(salesmanVo2.getSalesmanNo());
                dtlRespVO.setExecutUser(salesmanVo2.getFullName());
                dtlRespVO.setExecutUserId(salesmanVo2.getId());
            }
        } else {
            Optional<SalesmanInfoSimpleRespVO> salesmanVoOptional = salesmanVoList.stream().filter(salesmanVo -> Objects.equals(salesmanVo.getSalesmanNo(), dtlRespVO.getExecutUserCode())).findFirst();
            if (salesmanVoOptional.isPresent()) {
                SalesmanInfoSimpleRespVO salesmanVo3 = salesmanVoOptional.get();
                dtlRespVO.setExecutUserCode(salesmanVo3.getSalesmanNo());
                dtlRespVO.setExecutUser(salesmanVo3.getFullName());
                dtlRespVO.setExecutUserId(salesmanVo3.getId());
            } else {
                errorDataList.add(dtlRespVO);
            }
        }
    }

    public void fillCustDtl(TaskInfoDtlImportRespVO dtlRespVO, List<OrgAddressRpcDTO> orgAddressRpcDTOList, List<SalesmanInfoSimpleRespVO> custSalesmanVoList, List<SalesmanInfoSimpleRespVO> salesmanVoList, List<TaskInfoDtlImportRespVO> errorDataList) {
        Optional<OrgAddressRpcDTO> orgAddressOptional = orgAddressRpcDTOList.stream().filter(orgAddressVo -> Objects.equals(orgAddressVo.getAddrNo(), dtlRespVO.getAddrNo())).findFirst();
        if (orgAddressOptional.isPresent()) {
            OrgAddressRpcDTO orgAddressRpcDTO = orgAddressOptional.get();
            dtlRespVO.setAddress(orgAddressRpcDTO.getDetailAddr());
            dtlRespVO.setCountry(orgAddressRpcDTO.getCountry());
            dtlRespVO.setCountryName(orgAddressRpcDTO.getCountryName());
            dtlRespVO.setProvince(orgAddressRpcDTO.getProvince());
            dtlRespVO.setProvinceName(orgAddressRpcDTO.getProvinceName());
            dtlRespVO.setCity(orgAddressRpcDTO.getCity());
            dtlRespVO.setCityName(orgAddressRpcDTO.getCityName());
            dtlRespVO.setDistrict(orgAddressRpcDTO.getCounty());
            dtlRespVO.setDistrictName(orgAddressRpcDTO.getCountyName());
        }
        if (StringUtils.isBlank((CharSequence)dtlRespVO.getExecutUserCode())) {
            Optional<SalesmanInfoSimpleRespVO> custSalesmanOptional = custSalesmanVoList.stream().filter(custSalesmanVo -> Objects.equals(custSalesmanVo.getId(), dtlRespVO.getAssociatedExecutorId())).findFirst();
            if (custSalesmanOptional.isPresent()) {
                SalesmanInfoSimpleRespVO custSalesmanVo2 = custSalesmanOptional.get();
                dtlRespVO.setExecutUserCode(custSalesmanVo2.getSalesmanNo());
                dtlRespVO.setExecutUser(custSalesmanVo2.getFullName());
                dtlRespVO.setExecutUserId(custSalesmanVo2.getId());
            }
        } else {
            Optional<SalesmanInfoSimpleRespVO> salesmanVoOptional = salesmanVoList.stream().filter(salesmanVo -> Objects.equals(salesmanVo.getSalesmanNo(), dtlRespVO.getExecutUserCode())).findFirst();
            if (salesmanVoOptional.isPresent()) {
                SalesmanInfoSimpleRespVO salesmanVo2 = salesmanVoOptional.get();
                dtlRespVO.setExecutUserCode(salesmanVo2.getSalesmanNo());
                dtlRespVO.setExecutUser(salesmanVo2.getFullName());
                dtlRespVO.setExecutUserId(salesmanVo2.getId());
            } else {
                errorDataList.add(dtlRespVO);
            }
        }
    }

    public void fillSalesmanDtl(TaskInfoDtlImportRespVO dtlRespVO, List<SalesmanInfoSimpleRespVO> salesmanVoList, List<TaskInfoDtlImportRespVO> errorDataList) {
        if (StringUtils.isBlank((CharSequence)dtlRespVO.getExecutUserCode())) {
            Optional<SalesmanInfoSimpleRespVO> salesmanOptional = salesmanVoList.stream().filter(salesmanVo -> Objects.equals(salesmanVo.getSalesmanNo(), dtlRespVO.getAssociatedExecutorCode())).findFirst();
            if (salesmanOptional.isPresent()) {
                SalesmanInfoSimpleRespVO salesmanVo2 = salesmanOptional.get();
                dtlRespVO.setExecutUserCode(salesmanVo2.getSalesmanNo());
                dtlRespVO.setExecutUser(salesmanVo2.getFullName());
                dtlRespVO.setExecutUserId(salesmanVo2.getId());
            }
        } else {
            Optional<SalesmanInfoSimpleRespVO> salesmanVoOptional = salesmanVoList.stream().filter(salesmanVo -> Objects.equals(salesmanVo.getSalesmanNo(), dtlRespVO.getExecutUserCode())).findFirst();
            if (salesmanVoOptional.isPresent()) {
                SalesmanInfoSimpleRespVO salesmanVo3 = salesmanVoOptional.get();
                dtlRespVO.setExecutUserCode(salesmanVo3.getSalesmanNo());
                dtlRespVO.setExecutUser(salesmanVo3.getFullName());
                dtlRespVO.setExecutUserId(salesmanVo3.getId());
            } else {
                errorDataList.add(dtlRespVO);
            }
        }
    }

    public void checkImportTaskDtl(List<TaskInfoDtlImportRespVO> errorDataList) {
        if (!org.springframework.util.CollectionUtils.isEmpty(errorDataList)) {
            String checkResult = errorDataList.stream().map(vo -> "\u4e1a\u52a1\u7c7b\u578b:(" + vo.getBusinessTypeName() + ")-\u5173\u8054\u4e1a\u52a1\u7f16\u7801:(" + vo.getBusinessCode() + ")").collect(Collectors.joining(";", "\u5173\u8054\u4e1a\u52a1\u7f16\u7801\u4e0d\u5b58\u5728:[", "].\u8bf7\u68c0\u67e5!"));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
        }
    }

    public void checkImportTaskDtlExecuteUser(List<TaskInfoDtlImportRespVO> errorDataList) {
        if (!org.springframework.util.CollectionUtils.isEmpty(errorDataList)) {
            String checkResult = errorDataList.stream().map(vo -> "\u4e1a\u52a1\u7c7b\u578b:(" + vo.getBusinessTypeName() + ")-\u5173\u8054\u4e1a\u52a1\u7f16\u7801:(" + this.judgmentBusinessCode((TaskInfoDtlImportRespVO)vo) + ")").collect(Collectors.joining(";", "\u672a\u67e5\u8be2\u5230\u6267\u884c\u4eba\u4fe1\u606f:[", "].\u8bf7\u68c0\u67e5!"));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
        }
    }

    private String judgmentBusinessCode(TaskInfoDtlImportRespVO dtlRespVO) {
        String businessCode = "";
        if (Objects.equals(UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_STORE.getValueCodeName(), dtlRespVO.getBusinessTypeName())) {
            businessCode = dtlRespVO.getBusinessCode();
        } else if (Objects.equals(UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_DEALER.getValueCodeName(), dtlRespVO.getBusinessTypeName())) {
            businessCode = StringUtils.isBlank((CharSequence)dtlRespVO.getCustCode2()) ? dtlRespVO.getBusinessCode() : dtlRespVO.getCustCode2();
        } else if (Objects.equals(UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_SALESMAN.getValueCodeName(), dtlRespVO.getBusinessTypeName())) {
            businessCode = dtlRespVO.getBusinessCode();
        }
        return businessCode;
    }

    public List<OrgStoreDetailRpcDTO> selectStore(List<String> storeCodes) {
        if (org.springframework.util.CollectionUtils.isEmpty(storeCodes)) {
            return Collections.EMPTY_LIST;
        }
        List<OrgStoreDetailRpcDTO> storeRespVOList = this.rmiOrgStoreRpcService.findStoreByStoreCodes(storeCodes);
        if (org.springframework.util.CollectionUtils.isEmpty(storeRespVOList)) {
            return Collections.EMPTY_LIST;
        }
        List<OrgStoreDetailRpcDTO> storeVoList = storeRespVOList.stream().filter(storeRespVO -> Objects.equals(storeRespVO.getStoreStatus(), "ACTIVE")).collect(Collectors.toList());
        return storeVoList;
    }

    public List<LmSaveCustRespVO> selectCust(List<String> custCodes) {
        if (org.springframework.util.CollectionUtils.isEmpty(custCodes)) {
            return Collections.EMPTY_LIST;
        }
        List custRespVOList = this.crmCustService.getCustInfoByCustCodes(custCodes);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)custRespVOList)) {
            return Collections.EMPTY_LIST;
        }
        List<LmSaveCustRespVO> custVoList = custRespVOList.stream().filter(custRespVO -> Objects.equals(custRespVO.getCustStatus(), UdcEnum.CRM_CUST_STATUS_ACTIVE.getValueCode())).collect(Collectors.toList());
        return custVoList;
    }

    public List<LmSaveCustRespVO> selectCustByCustCode2(List<String> custCode2List) {
        if (org.springframework.util.CollectionUtils.isEmpty(custCode2List)) {
            return Collections.EMPTY_LIST;
        }
        List custRespVOList = this.crmCustService.getCustInfoByCustCode2s(custCode2List);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)custRespVOList)) {
            return Collections.EMPTY_LIST;
        }
        List<LmSaveCustRespVO> custVoList = custRespVOList.stream().filter(custRespVO -> Objects.equals(custRespVO.getCustStatus(), UdcEnum.CRM_CUST_STATUS_ACTIVE.getValueCode())).collect(Collectors.toList());
        if (org.springframework.util.CollectionUtils.isEmpty(custVoList)) {
            return Collections.EMPTY_LIST;
        }
        return custVoList;
    }

    public List<SalesmanInfoSimpleRespVO> selectSalesman(List<String> salesmanCodes) {
        if (org.springframework.util.CollectionUtils.isEmpty(salesmanCodes)) {
            return Collections.EMPTY_LIST;
        }
        SalesmanInfoSimpleQueryVO salesmanQueryVO = new SalesmanInfoSimpleQueryVO();
        salesmanQueryVO.setCodes(salesmanCodes);
        salesmanQueryVO.setEnableStatus(Integer.valueOf(1));
        List salesmanRespVOList = this.salesmanInfoService.simpleQuery(salesmanQueryVO);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)salesmanRespVOList)) {
            return Collections.EMPTY_LIST;
        }
        return salesmanRespVOList;
    }

    @SysCodeProc
    public PagingVO<TaskInfoAppRespVO> appDtlPage(TaskInfoAppQueryVO pageParam) {
        SysUserDTO sysUserDTO = this.getSysUser();
        SysEmployeeBasicDTO employeeBasicDTO = this.getEmployeeByUser(sysUserDTO);
        pageParam.setExecutUserCode(employeeBasicDTO.getCode());
        return this.appDtlCommonPage(pageParam);
    }

    @SysCodeProc
    public PagingVO<TaskInfoAppRespVO> appDtlTeamPage(TaskInfoAppQueryVO queryVO) {
        SysUserDTO sysUserDTO = this.getSysUser();
        SysEmployeeBasicDTO employeeBasicDTO = this.getEmployeeByUser(sysUserDTO);
        if (Objects.isNull(employeeBasicDTO.getCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e1a\u52a1\u5458\u7f16\u7801\u4e3a\u7a7a");
        }
        List<String> subEmployeeCodeList = this.queryAllSubEmployeeByCode(employeeBasicDTO.getCode());
        if (org.springframework.util.CollectionUtils.isEmpty(subEmployeeCodeList)) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        queryVO.setExecutUserCodes(subEmployeeCodeList);
        return this.appDtlCommonPage(queryVO);
    }

    private List<String> queryAllSubEmployeeByCode(String salesmanNo) {
        List<EmployeeUnderlingDTO> resultData = this.rmiEmployeeRpcService.getUnderlingByCode(salesmanNo, Boolean.TRUE, Boolean.TRUE);
        if (org.springframework.util.CollectionUtils.isEmpty(resultData)) {
            return Collections.EMPTY_LIST;
        }
        HashSet codeList = new HashSet();
        if (!org.springframework.util.CollectionUtils.isEmpty(resultData)) {
            ArrayList<EmployeeUnderlingDTO> listEmp = new ArrayList<EmployeeUnderlingDTO>();
            List<EmployeeUnderlingDTO> res = this.queryAllSubTreeToList(resultData, listEmp);
            codeList.addAll(res.stream().map(EmployeeUnderlingDTO::getCode).collect(Collectors.toList()));
        }
        return codeList.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<EmployeeUnderlingDTO> queryAllSubTreeToList(List<EmployeeUnderlingDTO> source, List<EmployeeUnderlingDTO> obj) {
        source.stream().forEach(v -> {
            EmployeeUnderlingDTO t = new EmployeeUnderlingDTO();
            BeanUtils.copyProperties((Object)v, (Object)t);
            t.setUnderlingList(new ArrayList());
            obj.add(t);
            if (CollectionUtil.isNotEmpty((Collection)v.getUnderlingList())) {
                this.queryAllSubTreeToList(v.getUnderlingList(), obj);
            }
        });
        return obj;
    }

    @SysCodeProc
    private PagingVO<TaskInfoAppRespVO> appDtlCommonPage(TaskInfoAppQueryVO queryVO) {
        List<EmployeePageRespDTO> employeePageRespDTOList;
        ArrayList completionStatusList = Lists.newArrayList((Object[])new String[]{UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WEE.getValueCode(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_IPS.getValueCode(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WAT.getValueCode(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_ARN.getValueCode(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CPD.getValueCode()});
        queryVO.setCompleteStates((List)completionStatusList);
        if (StringUtils.isNotBlank((CharSequence)queryVO.getQueryKeyword()) && !org.springframework.util.CollectionUtils.isEmpty(employeePageRespDTOList = this.rmiEmployeeRpcService.findEmployeeByFullName(queryVO.getQueryKeyword()))) {
            List executUserCodes = employeePageRespDTOList.stream().map(EmployeePageRespDTO::getCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            queryVO.setExecutUserCodeList(executUserCodes);
        }
        PagingVO<TaskInfoAppRespVO> pagingVO = null;
        if (queryVO.getAllStateSign().booleanValue()) {
            pagingVO = this.taskInfoDtlRepoProc.selectAppTask(queryVO);
        } else if (Objects.equals(queryVO.getCompleteState(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CPD.getValueCode())) {
            pagingVO = this.taskInfoDtlRepoProc.selectAppTaskComplete(queryVO);
        } else if (Objects.equals(queryVO.getCompleteState(), "OVERDUE")) {
            ArrayList delayFlagCompletionStatusList = Lists.newArrayList((Object[])new String[]{UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WEE.getValueCode(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_IPS.getValueCode(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WAT.getValueCode(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_ARN.getValueCode()});
            queryVO.setCompleteStates((List)delayFlagCompletionStatusList);
            queryVO.setDelayFlag(UdcEnum.SALESMAN_TASK_DELAY_FLAG_Y.getValueCode());
            queryVO.setCompleteState(null);
            pagingVO = this.taskInfoDtlRepoProc.selectAppTaskOverdue(queryVO);
        } else if (completionStatusList.contains(queryVO.getCompleteState())) {
            pagingVO = this.taskInfoDtlRepoProc.selectAppTaskOther(queryVO);
        }
        if (Objects.isNull(pagingVO) || org.springframework.util.CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List dtlRespVOList = pagingVO.getRecords();
        this.translateAppTask(dtlRespVOList);
        this.translateAppArea(dtlRespVOList);
        return PagingVO.builder().total(pagingVO.getTotal()).records(dtlRespVOList).build();
    }

    private void translateAppTask(List<TaskInfoAppRespVO> appRespVOS) {
        Set<String> executeUserCodeList = appRespVOS.stream().map(TaskInfoAppRespVO::getExecutUserCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List<SysEmployeeBasicDTO> executeUserList = this.rmiEmployeeRpcService.findEmployeeByCodes(executeUserCodeList);
        List templateCodeList = appRespVOS.stream().map(TaskInfoAppRespVO::getExecutTemplateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List recordTempVOList = this.exectRecordTempService.queryByCodes(templateCodeList);
        List<Object> storeList = new ArrayList();
        List custList = new ArrayList();
        List<Object> employeeList = new ArrayList();
        Map<String, List<TaskInfoAppRespVO>> businessTypeListMap = appRespVOS.stream().filter(dtlRespVO -> StringUtils.isNotBlank((CharSequence)dtlRespVO.getBusinessType())).collect(Collectors.groupingBy(TaskInfoAppRespVO::getBusinessType));
        for (String key : businessTypeListMap.keySet()) {
            List<String> businessCodes = businessTypeListMap.get(key).stream().map(TaskInfoAppRespVO::getBusinessCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (Objects.equals(key, UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_STORE.getValueCode())) {
                storeList = this.rmiOrgStoreRpcService.findStoreByStoreCodes(businessCodes);
                continue;
            }
            if (Objects.equals(key, UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_DEALER.getValueCode())) {
                custList = this.crmCustService.getCustInfoByCustCodes(businessCodes);
                continue;
            }
            if (!Objects.equals(key, UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_SALESMAN.getValueCode())) continue;
            Set<String> businessCodeSet = businessCodes.stream().collect(Collectors.toSet());
            employeeList = this.rmiEmployeeRpcService.findEmployeeByCodes(businessCodeSet);
        }
        for (TaskInfoAppRespVO respVO : appRespVOS) {
            if (Objects.equals(respVO.getBusinessType(), UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_STORE.getValueCode())) {
                Optional<OrgStoreDetailRpcDTO> storeOptional = storeList.stream().filter(storeVO -> Objects.equals(storeVO.getStoreCode(), respVO.getBusinessCode())).findFirst();
                storeOptional.ifPresent(storeVO -> {
                    respVO.setBusinessName(storeVO.getStoreName());
                    respVO.setContactName(storeVO.getStoreManager());
                    respVO.setContactPhone(storeVO.getStoreContPhone());
                });
            }
            if (Objects.equals(respVO.getBusinessType(), UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_DEALER.getValueCode())) {
                Optional<LmSaveCustRespVO> custOptional = custList.stream().filter(custVO -> Objects.equals(custVO.getCustCode(), respVO.getBusinessCode())).findFirst();
                custOptional.ifPresent(custVO -> {
                    respVO.setBusinessName(custVO.getCustName());
                    respVO.setCustCode2(custVO.getCustCode2());
                    respVO.setContactName(custVO.getContactName());
                    respVO.setContactPhone(custVO.getContactPhone());
                });
            }
            if (Objects.equals(respVO.getBusinessType(), UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_SALESMAN.getValueCode())) {
                Optional<SysEmployeeBasicDTO> employeeOptional = employeeList.stream().filter(employeeVO -> Objects.equals(employeeVO.getCode(), respVO.getBusinessCode())).findFirst();
                employeeOptional.ifPresent(employeeVO -> {
                    respVO.setBusinessName(employeeVO.getFullName());
                    respVO.setContactName(employeeVO.getFullName());
                    respVO.setContactPhone(employeeVO.getPhone());
                });
            }
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)recordTempVOList)) {
                Optional<ExectRecordTempRespVO> recordTempOptional = recordTempVOList.stream().filter(tempRespVO -> Objects.equals(tempRespVO.getTempCode(), respVO.getExecutTemplateCode())).findFirst();
                recordTempOptional.ifPresent(tempRespVO -> respVO.setExecutTemplateName(tempRespVO.getTempName()));
            }
            Optional<SysEmployeeBasicDTO> executeUserOptional = executeUserList.stream().filter(executeUser -> Objects.equals(executeUser.getCode(), respVO.getExecutUserCode())).findFirst();
            executeUserOptional.ifPresent(executeUser -> respVO.setExecutUser(executeUser.getFullName()));
        }
    }

    private void translateAppArea(List<TaskInfoAppRespVO> appRespVOS) {
        Set provinces = appRespVOS.stream().map(TaskInfoAppRespVO::getProvince).distinct().filter(Objects::nonNull).collect(Collectors.toSet());
        Set cities = appRespVOS.stream().map(TaskInfoAppRespVO::getCity).distinct().filter(Objects::nonNull).collect(Collectors.toSet());
        Set counties = appRespVOS.stream().map(TaskInfoAppRespVO::getDistrict).distinct().filter(Objects::nonNull).collect(Collectors.toSet());
        HashSet<String> areaCodes = new HashSet<String>();
        areaCodes.addAll(provinces);
        areaCodes.addAll(cities);
        areaCodes.addAll(counties);
        List<SysAreaRespDTO> areaList = this.rmiSysAreaRpcService.findAreaByCodes(areaCodes);
        appRespVOS.forEach(dtlRespVO -> {
            Optional<SysAreaRespDTO> areaOptional1 = areaList.stream().filter(d -> Objects.equals(d.getAreaCode(), dtlRespVO.getProvince())).findFirst();
            areaOptional1.ifPresent(areaRespDTO -> dtlRespVO.setProvinceName(areaRespDTO.getAreaName()));
            Optional<SysAreaRespDTO> areaOptional2 = areaList.stream().filter(d -> Objects.equals(d.getAreaCode(), dtlRespVO.getCity())).findFirst();
            areaOptional2.ifPresent(areaRespDTO -> dtlRespVO.setCityName(areaRespDTO.getAreaName()));
            Optional<SysAreaRespDTO> areaOptional3 = areaList.stream().filter(d -> Objects.equals(d.getAreaCode(), dtlRespVO.getDistrict())).findFirst();
            areaOptional3.ifPresent(areaRespDTO -> dtlRespVO.setDistrictName(areaRespDTO.getAreaName()));
        });
    }

    public List<TaskInfoCommonAppRespVO> queryAngleMark(TaskInfoAppQueryVO queryVO) {
        String executeUserCode = queryVO.getExecutUserCode();
        List typeList = queryVO.getTypeList();
        if (StringUtils.isBlank((CharSequence)executeUserCode)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e1a\u52a1\u5458\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)typeList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4efb\u52a1\u7c7b\u578b\u4e3a\u7a7a!");
        }
        ArrayList<TaskInfoCommonAppRespVO> commonAppRespVOList = new ArrayList<TaskInfoCommonAppRespVO>();
        typeList.forEach(s -> {
            TaskInfoCommonAppRespVO commonAppRespVO = new TaskInfoCommonAppRespVO();
            commonAppRespVO.setAngleMarkType(s);
            commonAppRespVO.setAngleMarkCount(Integer.valueOf(0));
            commonAppRespVOList.add(commonAppRespVO);
        });
        TaskInfoDtlQueryVO taskInfoDtlQueryVO = new TaskInfoDtlQueryVO();
        taskInfoDtlQueryVO.setExecutUserCode(executeUserCode);
        taskInfoDtlQueryVO.setCompleteState(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WEE.getValueCode());
        List<TaskInfoDtlRespVO> taskInfoDtlRespVOList = this.taskInfoDtlRepoProc.selectByQueryVO(taskInfoDtlQueryVO);
        if (org.springframework.util.CollectionUtils.isEmpty(taskInfoDtlRespVOList)) {
            return commonAppRespVOList;
        }
        List masIdList = taskInfoDtlRespVOList.stream().map(TaskInfoDtlRespVO::getMasId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        TaskInfoQueryVO taskInfoQueryVO = new TaskInfoQueryVO();
        taskInfoQueryVO.setIds(masIdList);
        taskInfoQueryVO.setTypeList(typeList);
        List taskInfoRespVOList = this.taskInfoService.selectByParam(taskInfoQueryVO);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)taskInfoRespVOList)) {
            return commonAppRespVOList;
        }
        HashMap map = new HashMap();
        taskInfoDtlRespVOList.forEach(dtlRespVO -> {
            Optional<TaskInfoRespVO> respVOOptional = taskInfoRespVOList.stream().filter(respVO -> Objects.equals(dtlRespVO.getMasId(), respVO.getId())).findFirst();
            if (respVOOptional.isPresent()) {
                TaskInfoRespVO taskInfoRespVO = respVOOptional.get();
                if (!map.isEmpty() && map.containsKey(taskInfoRespVO.getType())) {
                    Integer angleMarkCount = (Integer)map.get(taskInfoRespVO.getType());
                    map.put(taskInfoRespVO.getType(), angleMarkCount + 1);
                } else {
                    map.put(taskInfoRespVO.getType(), 1);
                }
            }
        });
        commonAppRespVOList.forEach(commonAppRespVO -> {
            if (!map.isEmpty() && map.containsKey(commonAppRespVO.getAngleMarkType())) {
                Integer angleMarkCount = (Integer)map.get(commonAppRespVO.getAngleMarkType());
                commonAppRespVO.setAngleMarkCount(angleMarkCount);
            }
        });
        return commonAppRespVOList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void executionRecordCallback(TaskExecutionRecordSaveVO saveVO) {
        if (StringUtils.isBlank((CharSequence)saveVO.getExecuteType())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e1a\u52a1\u64cd\u4f5c\u6267\u884c\u7c7b\u578b\u4e3a\u7a7a!");
        }
        if (Objects.isNull(saveVO.getTaskDtlId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4efb\u52a1\u660e\u7ec6ID\u4e3a\u7a7a!");
        }
        if (!ConstantsSale.TASK_EXECUTION_RECORD_LIST.contains(saveVO.getExecuteType())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u5339\u914d\u5230\u4e1a\u52a1\u64cd\u4f5c\u6267\u884c\u7c7b\u578b!");
        }
        TaskInfoDtlRespVO dtlRespVO = this.findById(saveVO.getTaskDtlId());
        if (Objects.isNull(dtlRespVO)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u660e\u7ec6\u6570\u636e!");
        }
        TaskInfoRespVO respVO = this.taskInfoService.findById(dtlRespVO.getMasId());
        if (Objects.isNull(respVO)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u6570\u636e!");
        }
        switch (saveVO.getExecuteType()) {
            case "SAVE": {
                this.executionRecordSaveCallback(saveVO, dtlRespVO);
                break;
            }
            case "SUBMIT": {
                this.executionRecordSubmitCallback(saveVO, dtlRespVO);
                break;
            }
            case "REFUSE": {
                this.executionRecordRefuseCallback(saveVO);
                break;
            }
            case "PASS": {
                this.executionRecordPassCallback(saveVO, dtlRespVO);
                break;
            }
            case "CLOSE": {
                this.executionRecordCloseCallback(saveVO, dtlRespVO);
            }
        }
    }

    public void releaseDtl(Long id, String valueCode) {
        this.taskInfoDtlRepo.releaseDtl(id, valueCode);
    }

    private void executionRecordSaveCallback(TaskExecutionRecordSaveVO saveVO, TaskInfoDtlRespVO dtlRespVO) {
        if (StringUtils.isBlank((CharSequence)saveVO.getExecutRecordCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6267\u884c\u8bb0\u5f55\u7f16\u7801\u4e3a\u7a7a!");
        }
        this.taskInfoDtlRepoProc.updateExecuteRecordById(saveVO.getExecutRecordCode(), saveVO.getExecutRecordId(), saveVO.getExecutRecordName(), saveVO.getTaskDtlId());
        this.taskInfoDtlRepoProc.updateCompleteStateById(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_IPS.getValueCode(), saveVO.getTaskDtlId());
        this.taskInfoService.updateStateById(UdcEnum.SALESMAN_TASK_STATUS_IPS.getValueCode(), dtlRespVO.getMasId());
    }

    private void executionRecordSubmitCallback(TaskExecutionRecordSaveVO saveVO, TaskInfoDtlRespVO dtlRespVO) {
        this.executionRecordSaveCallback(saveVO, dtlRespVO);
        if (Objects.equals(dtlRespVO.getBusinessType(), UdcEnum.SALESMAN_TASK_TYPE_DST.getValueCode())) {
            this.taskInfoDtlRepoProc.updateCompleteStateById(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WAT.getValueCode(), saveVO.getTaskDtlId());
        } else {
            this.taskInfoDtlRepoProc.updateCompleteStateById(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WAT.getValueCode(), saveVO.getTaskDtlId());
        }
        this.taskInfoService.updateStateById(UdcEnum.SALESMAN_TASK_STATUS_IPS.getValueCode(), dtlRespVO.getMasId());
    }

    private void executionRecordRefuseCallback(TaskExecutionRecordSaveVO saveVO) {
        this.taskInfoDtlRepoProc.updateCompleteStateById(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_ARN.getValueCode(), saveVO.getTaskDtlId());
    }

    private void executionRecordPassCallback(TaskExecutionRecordSaveVO saveVO, TaskInfoDtlRespVO dtlRespVO) {
        List dtlCompleteVOList;
        if (Objects.equals(dtlRespVO.getBusinessType(), UdcEnum.SALESMAN_TASK_TYPE_DST.getValueCode())) {
            this.taskInfoDtlRepoProc.updateCompleteStateAndTimeById(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CPD.getValueCode(), LocalDateTime.now(), saveVO.getTaskDtlId());
        } else {
            this.taskInfoDtlRepoProc.updateCompleteStateAndTimeById(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CPD.getValueCode(), LocalDateTime.now(), saveVO.getTaskDtlId());
        }
        List<TaskInfoDtlRespVO> dtlRespVOList = this.selectByMasId(dtlRespVO.getMasId());
        if (org.springframework.util.CollectionUtils.isEmpty(dtlRespVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u660e\u7ec6\u6570\u636e!");
        }
        boolean completeStateFlag = dtlRespVOList.stream().allMatch(vo -> this.checkAllCompleteState(vo.getCompleteState()));
        if (completeStateFlag) {
            this.taskInfoService.updateStateAndCompleteTime(UdcEnum.SALESMAN_TASK_STATUS_CPD.getValueCode(), LocalDateTime.now(), dtlRespVO.getMasId());
        }
        BigDecimal completeSize = Objects.isNull((dtlCompleteVOList = dtlRespVOList.stream().filter(vo -> Objects.equals(vo.getCompleteState(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CPD.getValueCode())).collect(Collectors.toList())).size()) ? BigDecimal.ZERO : BigDecimal.valueOf(dtlCompleteVOList.size());
        BigDecimal allSize = Objects.isNull(dtlRespVOList.size()) ? BigDecimal.ZERO : BigDecimal.valueOf(dtlRespVOList.size());
        BigDecimal progress = completeSize.divide(allSize, 4, RoundingMode.HALF_UP).setScale(4, RoundingMode.HALF_UP);
        BigDecimal finallyProgress = progress.multiply(BigDecimal.valueOf(100L));
        this.taskInfoService.updateProgressById(finallyProgress, dtlRespVO.getMasId());
    }

    private boolean checkAllCompleteState(String completeState) {
        if (StringUtils.isBlank((CharSequence)completeState)) {
            return false;
        }
        return Objects.equals(completeState, UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CPD.getValueCode()) || Objects.equals(completeState, UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CSD.getValueCode());
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateProgressById(Long id) {
        List<TaskInfoDtlRespVO> dtlRespVOList = this.selectByMasId(id);
        if (org.springframework.util.CollectionUtils.isEmpty(dtlRespVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u660e\u7ec6\u6570\u636e!");
        }
        List dtlCompleteVOList = dtlRespVOList.stream().filter(vo -> Objects.equals(vo.getCompleteState(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CPD.getValueCode())).collect(Collectors.toList());
        BigDecimal completeSize = Objects.isNull(dtlCompleteVOList.size()) ? BigDecimal.ZERO : BigDecimal.valueOf(dtlCompleteVOList.size());
        BigDecimal allSize = Objects.isNull(dtlRespVOList.size()) ? BigDecimal.ZERO : BigDecimal.valueOf(dtlRespVOList.size());
        BigDecimal progress = completeSize.divide(allSize, 4, RoundingMode.HALF_UP).setScale(4, RoundingMode.HALF_UP);
        BigDecimal finallyProgress = progress.multiply(BigDecimal.valueOf(100L));
        this.taskInfoService.updateProgressById(finallyProgress, id);
    }

    private void executionRecordCloseCallback(TaskExecutionRecordSaveVO saveVO, TaskInfoDtlRespVO dtlRespVO) {
        this.taskInfoDtlRepoProc.updateCompleteStateById(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CSD.getValueCode(), saveVO.getTaskDtlId());
        List<TaskInfoDtlRespVO> dtlRespVOList = this.selectByMasId(dtlRespVO.getMasId());
        if (org.springframework.util.CollectionUtils.isEmpty(dtlRespVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u660e\u7ec6\u6570\u636e!");
        }
        boolean completeStateFlag = dtlRespVOList.stream().allMatch(vo -> Objects.equals(vo.getCompleteState(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CSD.getValueCode()));
        if (completeStateFlag) {
            this.taskInfoService.updateStateAndCompleteTime(UdcEnum.SALESMAN_TASK_STATUS_CSD.getValueCode(), LocalDateTime.now(), dtlRespVO.getMasId());
        }
    }

    private SysUserDTO getSysUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (Objects.isNull(userDetails) || Objects.isNull(userDetails.getUser())) {
            throw new BusinessException(ApiCode.UNAUTHORIZED, "\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        SysUserDTO sysUser = userDetails.getUser();
        if (ObjectUtils.isEmpty((Object)sysUser)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        return sysUser;
    }

    private String transitionCodesToStr(List<String> codeList) {
        if (org.springframework.util.CollectionUtils.isEmpty(codeList)) {
            return null;
        }
        String codeString = codeList.stream().distinct().collect(Collectors.joining(","));
        return codeString;
    }

    private List<String> transitionStrToCodes(String codeString) {
        if (StringUtils.isEmpty((CharSequence)codeString)) {
            return Collections.emptyList();
        }
        List<String> codeList = Arrays.asList(codeString.split(","));
        return codeList;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> importTaskDtl(MultipartFile file, Long masId) {
        if (file == null || file.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u5bfc\u5165\u6587\u4ef6!");
        }
        Integer headRow = 2;
        Integer dataTypeAttr = 2;
        List dataList = null;
        try {
            dataList = ExcelImportUtil.instance((InputStream)file.getInputStream()).headRow(headRow).dataType(TaskInfoDtlImportRespVO.class, dataTypeAttr).readAllSync();
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u660e\u7ec6\u5bfc\u5165\u5931\u8d25:", (Throwable)e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4efb\u52a1\u660e\u7ec6\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
        }
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)dataList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!");
        }
        Set<String> repeatCode = TaskInfoDtlServiceImpl.findDuplicateStrings(dataList.stream().map(TaskInfoDtlImportRespVO::getBusinessCode).collect(Collectors.toList()));
        if (!repeatCode.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u6570\u636e\u91cd\u590d" + repeatCode + ",\u8bf7\u68c0\u67e5!");
        }
        TaskInfoDtlQueryVO queryVO = new TaskInfoDtlQueryVO();
        queryVO.setMasId(masId);
        List<TaskInfoDtlDO> detailData = this.taskInfoDtlRepoProc.getByMasId(masId);
        if (!detailData.isEmpty()) {
            List impotCodes = dataList.stream().map(TaskInfoDtlImportRespVO::getBusinessCode).collect(Collectors.toList());
            List detailCodeList = detailData.stream().map(TaskInfoDtlDO::getBusinessCode).collect(Collectors.toList());
            ArrayList<String> repeatCodes = new ArrayList<String>();
            for (String code2 : detailCodeList) {
                if (!impotCodes.contains(code2)) continue;
                repeatCodes.add(code2);
            }
            if (CollectionUtils.isNotEmpty(repeatCodes)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u6570\u636e" + repeatCodes + "\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5!");
            }
        }
        AtomicInteger sheetCount = new AtomicInteger(1);
        dataList.forEach(dtlRespVO -> {
            sheetCount.addAndGet(1);
            if (StringUtils.isBlank((CharSequence)dtlRespVO.getBusinessTypeName()) || StringUtils.isBlank((CharSequence)dtlRespVO.getBusinessCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7b2c" + sheetCount + "\u884c\u6570\u636e\u5b58\u5728\u7a7a\u503c,\u8bf7\u68c0\u67e5!");
            }
            if (!ConstantsSale.SALESMAN_TASK_BUSINESS_TYPE_NAME_LIST.contains(dtlRespVO.getBusinessTypeName())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7b2c" + sheetCount + "\u884c\u6570\u636e\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5!");
            }
        });
        return this.disposeImportDtl(dataList, masId);
    }

    public static Set<String> findDuplicateStrings(List<String> list) {
        return list.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public ApiResult<Object> disposeImportDtl(List<TaskInfoDtlImportRespVO> dataList, Long masId) {
        ArrayList<TaskInfoDtlImportRespVO> errorDataList = new ArrayList<TaskInfoDtlImportRespVO>();
        ArrayList<TaskInfoDtlImportRespVO> successDataList = new ArrayList<TaskInfoDtlImportRespVO>();
        Map<String, List<TaskInfoDtlImportRespVO>> importListMap = dataList.stream().filter(dtlRespVO -> Objects.nonNull(dtlRespVO.getBusinessTypeName())).collect(Collectors.groupingBy(TaskInfoDtlImportRespVO::getBusinessTypeName));
        for (String key : importListMap.keySet()) {
            List<TaskInfoDtlImportRespVO> importDataList = importListMap.get(key);
            List<String> businessCodes = importDataList.stream().map(TaskInfoDtlImportRespVO::getBusinessCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (Objects.equals(UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_STORE.getValueCodeName(), key)) {
                List<OrgStoreDetailRpcDTO> storeRespVOList = new ArrayList<OrgStoreDetailRpcDTO>();
                if (!org.springframework.util.CollectionUtils.isEmpty(businessCodes)) {
                    storeRespVOList = this.selectStore(businessCodes);
                }
                this.disposeStoreImport(importDataList, storeRespVOList, errorDataList, successDataList);
                continue;
            }
            if (Objects.equals(UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_DEALER.getValueCodeName(), key)) {
                List<LmSaveCustRespVO> custRespVOList = new ArrayList<LmSaveCustRespVO>();
                if (!org.springframework.util.CollectionUtils.isEmpty(businessCodes)) {
                    custRespVOList = this.selectCustByCustCode2(businessCodes);
                }
                this.disposeCustImport(importDataList, custRespVOList, errorDataList, successDataList);
                continue;
            }
            if (!Objects.equals(UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_SALESMAN.getValueCodeName(), key)) continue;
            List<SalesmanInfoSimpleRespVO> salesmanRespVOList = new ArrayList<SalesmanInfoSimpleRespVO>();
            if (!org.springframework.util.CollectionUtils.isEmpty(businessCodes)) {
                salesmanRespVOList = this.selectSalesman(businessCodes);
            }
            this.disposeSalesmanImport(importDataList, salesmanRespVOList, errorDataList, successDataList);
        }
        this.checkImportTaskDtl(errorDataList);
        List<TaskInfoDtlRespVO> taskInfoDtlRespVOList = this.assembleImportTaskDtl(successDataList);
        ArrayList list = new ArrayList();
        taskInfoDtlRespVOList.forEach(taskDtl -> {
            TaskInfoDtlDO taskInfoDtl = new TaskInfoDtlDO();
            taskInfoDtl.setMasId(masId);
            taskInfoDtl.setBusinessCode(taskDtl.getBusinessCode());
            taskInfoDtl.setBusinessType(taskDtl.getBusinessType());
            taskInfoDtl.setBusinessName(taskDtl.getBusinessName());
            taskInfoDtl.setDealerCode(taskDtl.getDealerCode());
            taskInfoDtl.setAddress(taskDtl.getAddress());
            taskInfoDtl.setExecutUser(taskDtl.getExecutUser());
            taskInfoDtl.setCompleteState(UdcEnum.SALESMAN_TASK_STATUS_WRE.getValueCode());
            taskInfoDtl.setExecutUserCode(taskDtl.getExecutUserCode());
            taskInfoDtl.setCustCode2(taskDtl.getCustCode2());
            list.add(taskInfoDtl);
        });
        this.taskInfoDtlRepo.saveAll(list);
        return ApiResult.ok();
    }
}

