/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.IterUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.ZoneSettingDService;
import com.elitesland.yst.production.sale.api.vo.param.zone.ZoneSettingDetailPageParam;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSettingDVO;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSettingSaveDVO;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.QBusFirstMenuConfDDO;
import com.elitesland.yst.production.sale.entity.QZoneSettingDDO;
import com.elitesland.yst.production.sale.entity.ZoneSettingDDO;
import com.elitesland.yst.production.sale.repo.BusFirstMenuConfDRepo;
import com.elitesland.yst.production.sale.repo.ZoneSettingDRepo;
import com.elitesland.yst.production.sale.repo.ZoneSettingDRepoProc;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgBuRpcService;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ZoneSettingDServiceImpl
implements ZoneSettingDService {
    private static final Logger log = LoggerFactory.getLogger(ZoneSettingDServiceImpl.class);
    private final OrgBuRpcService orgBuRpcService;
    private final ZoneSettingDRepoProc zoneSettingDRepoProc;
    private final ZoneSettingDRepo zoneSettingDRepo;
    private final OrgEmpRpcService orgEmpRpcService;
    private final BusFirstMenuConfDRepo busFirstMenuConfDRepo;

    public PagingVO<ZoneSettingDVO> findPagingResult(ZoneSettingDetailPageParam param) {
        if (null == param.getOuId()) {
            OrgUserEmpInfoRpcDTO empInfo = this.getCurrentEmpInfo();
            if (null == empInfo.getOuId()) {
                return new PagingVO();
            }
            param.setOuId(empInfo.getOuId());
        }
        PagingVO<ZoneSettingDVO> list = this.zoneSettingDRepoProc.findPagingResult(param);
        return list;
    }

    public ApiResult<Object> addZoneDetail(List<ZoneSettingSaveDVO> param) {
        OrgUserEmpInfoRpcDTO empInfo = this.getCurrentEmpInfo();
        ArrayList list = new ArrayList();
        param.stream().forEach(p -> {
            ZoneSettingDDO zoneSettingDDO = new ZoneSettingDDO();
            BeanUtils.copyProperties((Object)p, (Object)zoneSettingDDO);
            zoneSettingDDO.setOuId(empInfo.getOuId());
            zoneSettingDDO.setOuName(empInfo.getOuName());
            list.add(zoneSettingDDO);
        });
        if (!list.isEmpty()) {
            this.zoneSettingDRepo.saveAll(list);
        }
        return ApiResult.ok();
    }

    public ApiResult<Object> delZoneDetail(List<Long> ids) {
        ids.stream().forEach(id -> {
            Optional optional = this.zoneSettingDRepo.findById(id);
            if (optional.isPresent()) {
                ZoneSettingDDO zoneSettingDDO = (ZoneSettingDDO)optional.get();
                zoneSettingDDO.setDeleteFlag(1);
                this.zoneSettingDRepo.save(zoneSettingDDO);
            }
        });
        return ApiResult.ok();
    }

    public ApiResult<Object> updateItemState(Long itemId, Long ouId, String state) {
        QZoneSettingDDO qZoneSettingDDO = QZoneSettingDDO.zoneSettingDDO;
        BooleanExpression zoneExpr = qZoneSettingDDO.itemId.eq((Object)itemId).and((Predicate)qZoneSettingDDO.ouId.eq((Object)ouId)).and((Predicate)qZoneSettingDDO.deleteFlag.eq((Object)0));
        Iterable zoneIterables = this.zoneSettingDRepo.findAll((Predicate)zoneExpr);
        if (!IterUtil.isEmpty((Iterable)zoneIterables)) {
            ArrayList zoneList = Lists.newArrayList((Iterable)zoneIterables);
            zoneList.stream().forEach(z -> {
                z.setState(state);
                this.zoneSettingDRepo.save(z);
            });
        }
        QBusFirstMenuConfDDO qBusFirstMenuConfDDO = QBusFirstMenuConfDDO.busFirstMenuConfDDO;
        BooleanExpression menuExpr = qBusFirstMenuConfDDO.itemId.eq((Object)itemId).and((Predicate)qBusFirstMenuConfDDO.ouId.eq((Object)ouId)).and((Predicate)qBusFirstMenuConfDDO.deleteFlag.eq((Object)0));
        Iterable menuIterables = this.busFirstMenuConfDRepo.findAll((Predicate)menuExpr);
        if (!IterUtil.isEmpty((Iterable)menuIterables)) {
            ArrayList menuList = Lists.newArrayList((Iterable)menuIterables);
            menuList.stream().forEach(m -> {
                m.setState(state);
                this.busFirstMenuConfDRepo.save(m);
            });
        }
        return ApiResult.ok();
    }

    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u5df2\u5931\u6548,\u8bf7\u91cd\u767b\u5f55\u91cd\u8bd5");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = this.orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f");
        }
        return userEmpInfo;
    }

    public ZoneSettingDServiceImpl(OrgBuRpcService orgBuRpcService, ZoneSettingDRepoProc zoneSettingDRepoProc, ZoneSettingDRepo zoneSettingDRepo, OrgEmpRpcService orgEmpRpcService, BusFirstMenuConfDRepo busFirstMenuConfDRepo) {
        this.orgBuRpcService = orgBuRpcService;
        this.zoneSettingDRepoProc = zoneSettingDRepoProc;
        this.zoneSettingDRepo = zoneSettingDRepo;
        this.orgEmpRpcService = orgEmpRpcService;
        this.busFirstMenuConfDRepo = busFirstMenuConfDRepo;
    }
}

