package com.elitesland.yst.production.sale.common.constant;

/**
 * 缓存常量.
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/01
 */
public interface ConstantsCache {

    /**
     * key生成器名称：当前用户ID
     */
    String KEY_GENERATOR_CURRENT_USER = "currentUserKeyGenerator";

    /**
     * key生成器名称：当前用户所属客户的绑定公司ID
     */
    String KEY_GENERATOR_CURRENT_USER_CUST_OU = "currentUserCustOuIdKeyGenerator";

    /**
     * 商品分类
     */
    String ITEM_CAT_NAME = "yst_sale_item_cat";

    /**
     * 用户绑定的客户
     * 客户信息从缓存中取，修改绑定和修改客户信息时都要删掉缓存
     */
    String BIP_USER_BIND_CUST = "yst_sale_user_bind_cust";

    /**
     * 客户价格
     * 客户价格变更时需要清掉
     */
    String CUST_PRICE = "yst_sale_item_price";
}
