package com.elitesland.yst.production.sale.controller.component;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.component.SalesmanParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.component.SalesmanPageRespVO;
import com.elitesland.yst.production.sale.service.component.SalesmanComponentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author: ryan.xu
 * @since 2023/6/25
 */
@RestController
@RequestMapping("/sale/component")
@RequiredArgsConstructor
@Api(value = "销售中心-公共组件接口", tags = {"销售中心-公共组件接口"})
public class SaleComponentController {

    private final SalesmanComponentService salesmanComponentService;

    @ApiOperation("员工分页查询-放大镜组件")
    @PostMapping("/emp/paging")
    public ApiResult<PagingVO<SalesmanPageRespVO>> empPagingSearch(@RequestBody SalesmanParamVO paramVO) {
        return ApiResult.ok(salesmanComponentService.querySalesmanList(paramVO));
    }

}
