package com.elitesland.yst.production.sale.controller.crm;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.service.CustLoginLogService;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustLoginLogRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustLoginLogVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/cust/login", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "客户登录日志")
@Slf4j
public class CustLoginLogController extends BaseController {

    @Autowired
    private CustLoginLogService custLoginLogService;

    @PostMapping(value = "/save")
    @ApiOperation(value = "保存登录日志")
    public ApiResult<Object> saveCustLoginLog(@RequestBody CustLoginLogVO custLoginLogVO){
        custLoginLogService.save(custLoginLogVO);
        return ApiResult.ok();
    }


    @GetMapping(value = "/getCustLoginInfo/{userName}")
    @ApiOperation(value = "查询用户登录信息")
    public ApiResult<CustLoginLogRespVO> getCustLoginInfo(@PathVariable String userName){
        CustLoginLogRespVO custLoginLogRespVO = custLoginLogService.getCustLoginInfo(userName);
        return ApiResult.ok(custLoginLogRespVO);
    }



}
