package com.elitesland.yst.production.sale.controller.pri;

import com.elitesland.yst.production.sale.api.service.PriSalePrice2Service;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.vo.param.pri.*;
import com.elitesland.yst.production.sale.api.vo.resp.pri.*;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitesland.yst.production.sale.core.util.excel.support.ExportColumnParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.excel.common.ExportExcelService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;

/**
 * 销售价格
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/19 1:52 下午
 */
@RestController
@RequestMapping(value = "/pri/sale/price", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "销售价格")
public class PriSalePriceController extends BaseController {

    @Autowired(required=false)
    private PriSalePriceService priSalePriceService;

    @Autowired
    private PriSalePrice2Service priSalePrice2Service;

    @Autowired
    private ExportExcelService exportExcelService;

    @PostMapping(value = "/query")
    @ApiOperation(value = "销售价格分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<PriSalePricePageRespVO>> query(@RequestBody PriSalePricePagingParam pagingParamVO) {
        PagingVO<PriSalePricePageRespVO> pageResult = priSalePriceService.query(pagingParamVO);
        return ApiResult.ok(pageResult);
    }

    @PostMapping(value = "/detail")
    @ApiOperation(value = "获取商品详情及相关价格")
    @ApiOperationSupport(order = 2)
    public ApiResult<PriSalePriceDetailVO> queryOnePrice(@RequestBody PriSalePriceQueryOneParam param) {
        PriSalePriceDetailVO result = priSalePriceService.queryOnePrice(param);
        return ApiResult.ok(result);
    }

    @PostMapping(value = "/salePrice")
    @ApiOperation(value = "对外销售价格获取")
    @ApiOperationSupport(order = 3)
    public ApiResult<PriSalePriceRespVO> querySalePrice(@RequestBody @Valid PriSalePriceQueryParam param) {
        return priSalePriceService.querySalePrice(param);
    }

    @PostMapping(value = "/crossPrice")
    @ApiOperation(value = "内部结算价格获取")
    @ApiOperationSupport(order = 4)
    public ApiResult<PriCrossPriceRespVO> queryCrossPrice(@RequestBody @Valid PriCrossPriceQueryParam param) {
        return priSalePriceService.queryCrossPrice(param);
    }

    @PostMapping(value = "/queryPrice")
    @ApiOperation(value = "获取指定类型价格")
    @ApiOperationSupport(order = 5)
    public ApiResult<PriSalePriceTypeRespVO> queryPrice(@RequestBody @Valid PriSalePriceTypeQueryParam param) {
        return ApiResult.ok(priSalePriceService.queryPrice(param));
    }

    @PostMapping(value = "/exportData")
    @ApiOperation(value = "销售价格导出")
    @ApiOperationSupport(order = 5)
    @Deprecated
    public ApiResult<Long> exportSalQuotation(HttpServletResponse response, @RequestBody  PriSalePricePagingParam pagingParamVO) {
        //导出列
        List<ExportColumnParam> columnParamList = new ArrayList<>(16);
        //确定导出字段
        columnParamList.add(new ExportColumnParam("itemCode", "商品编号"));
        columnParamList.add(new ExportColumnParam("itemName", "商品名称"));
        columnParamList.add(new ExportColumnParam("barcode", "商品条码"));
        columnParamList.add(new ExportColumnParam("itemSpec", "商品规格/型号"));
        columnParamList.add(new ExportColumnParam("itemCateCode", "商品品类编码"));
        columnParamList.add(new ExportColumnParam("uomName", "商品单位"));
        columnParamList.add(new ExportColumnParam("marketPrice", "市场价"));
        columnParamList.add(new ExportColumnParam("price", "含税价格"));
        columnParamList.add(new ExportColumnParam("guidePrice", "指导价"));
        columnParamList.add(new ExportColumnParam("ouName", "公司名称"));
        columnParamList.add(new ExportColumnParam("custCode", "客户编码"));
        columnParamList.add(new ExportColumnParam("custName", "客户名称"));
        columnParamList.add(new ExportColumnParam("custGroupName", "客户等级"));
        columnParamList.add(new ExportColumnParam("saleRegionName", "销售区域"));
        columnParamList.add(new ExportColumnParam("taxRateDesc", "税率编号描述"));
        columnParamList.add(new ExportColumnParam("taxRate", "税率"));
        columnParamList.add(new ExportColumnParam("currCode", "币种名称"));
        columnParamList.add(new ExportColumnParam("validFromLD", "生效时间"));
        columnParamList.add(new ExportColumnParam("validToLD", "失效时间"));
        columnParamList.add(new ExportColumnParam("promotionPrice", "活动含税价格"));
        columnParamList.add(new ExportColumnParam("promotionNetPrice", "活动不含税价格"));
        columnParamList.add(new ExportColumnParam("promDateFLD", "活动价格开始时间"));
        columnParamList.add(new ExportColumnParam("promDateTLD", "活动价格结束时间"));
        columnParamList.add(new ExportColumnParam("priceStatusName", "价格状态"));
        columnParamList.add(new ExportColumnParam("priceTypeName", "价格类型"));
        columnParamList.add(new ExportColumnParam("creator", "创建人"));
        columnParamList.add(new ExportColumnParam("createTimeLD", "创建时间"));
        columnParamList.add(new ExportColumnParam("updater", "更新人"));
        columnParamList.add(new ExportColumnParam("modifyTimeLD", "更新时间"));
        try {
            export(response, "发货单导出数据", columnParamList, paramVO -> priSalePrice2Service.searchForExport(paramVO).getData(), pagingParamVO);
        } catch (Exception e) {
            throw new BusinessException("导出失败");
        }
        return ApiResult.ok();
    }

    @PostMapping(value = "/exportData1")
    @ApiOperation(value = "销售价格导出")
    @ApiOperationSupport(order = 6)
    public void exportSalQuotation1(HttpServletResponse response, @RequestBody PriSalePricePagingParam pagingParamVO) {
        try {
            exportExcelService.export(pagingParamVO, response, param -> priSalePrice2Service.searchForExport((PriSalePricePagingParam) param).getData()).get();
        } catch (Exception e) {
            throw new BusinessException("导出失败");
        }
    }
}
