package com.elitesland.yst.production.sale.controller.sal;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.SalInvApplyService;
import com.elitesland.yst.production.sale.api.vo.param.pri.RmiSalSoDParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalInvApplyCheckParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalInvApplyPageParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalInvApplySaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiSalSoDVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalInvApplyRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalInvSerialVO;
import com.elitesland.yst.production.sale.controller.BaseController;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 销售开票申请
 * @author JinXK
 * @date 2021/6/2 10:35
 */
@RestController
@RequestMapping(value = "/sal/inv", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "销售开票申请")
@Slf4j
public class SalInvApplyController extends BaseController {

    @Autowired
    private SalInvApplyService salInvApplyService;

    @PostMapping(value = "/query")
    @ApiOperation(value = "销售开票申请分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<SalInvApplyRespVO>> query(@RequestBody SalInvApplyPageParam pagingParamVO) {
        PagingVO<SalInvApplyRespVO> result = salInvApplyService.query(pagingParamVO);
        return ApiResult.ok(result);
    }

    @PostMapping(value = "/selectSo")
    @ApiOperation(value = "销售订单查询")
    @ApiOperationSupport(order = 4)
    public ApiResult<PagingVO<RmiSalSoDVO>> selectSo(@RequestBody RmiSalSoDParam param) {
        PagingVO<RmiSalSoDVO> result = salInvApplyService.selectSo(param);
        return ApiResult.ok(result);
    }
}
